/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.aspect.build;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.AspectUpdateType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectUpdateListener;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectValuePropagator;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectWriteActivator;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectWriteDeactivator;
import org.cyclops.integrateddynamics.part.aspect.read.AspectReadBase;
import org.cyclops.integrateddynamics.part.aspect.write.AspectWriteBase;

public class AspectBuilder<V extends IValue, T extends IValueType<V>, O> {
    private final boolean read;
    private final T valueType;
    private final List<String> kinds;
    private final IAspectProperties defaultAspectProperties;
    private final List<IAspectValuePropagator> valuePropagators;
    private final List<IAspectWriteActivator> writeActivators;
    private final List<IAspectWriteDeactivator> writeDeactivators;
    private final ModBase mod;
    private final ModBase modGui;
    private final List<IAspectUpdateListener.Before> beforeUpdateListeners;
    private final List<IAspectUpdateListener.After> afterUpdateListeners;
    private final AspectUpdateType updateType;

    private AspectBuilder(boolean read, T valueType, List<String> kinds, IAspectProperties defaultAspectProperties, List<IAspectValuePropagator> valuePropagators, List<IAspectWriteActivator> writeActivators, List<IAspectWriteDeactivator> writeDeactivators, ModBase mod, ModBase modGui, List<IAspectUpdateListener.Before> beforeUpdateListeners, List<IAspectUpdateListener.After> afterUpdateListeners, AspectUpdateType updateType) {
        this.read = read;
        this.valueType = valueType;
        this.kinds = kinds;
        this.defaultAspectProperties = defaultAspectProperties;
        this.valuePropagators = valuePropagators;
        this.writeActivators = writeActivators;
        this.writeDeactivators = writeDeactivators;
        this.mod = Objects.requireNonNull(mod);
        this.modGui = Objects.requireNonNull(modGui);
        this.beforeUpdateListeners = beforeUpdateListeners;
        this.afterUpdateListeners = afterUpdateListeners;
        this.updateType = updateType;
    }

    public <O2> AspectBuilder<V, T, O2> handle(IAspectValuePropagator<O, O2> valuePropagator) {
        return this.handle(valuePropagator, null);
    }

    public <O2> AspectBuilder<V, T, O2> handle(IAspectValuePropagator<O, O2> valuePropagator, String kind) {
        return new AspectBuilder<V, T, O>(this.read, this.valueType, Helpers.joinList(this.kinds, kind), this.defaultAspectProperties, Helpers.joinList(this.valuePropagators, valuePropagator), Helpers.joinList(this.writeActivators, null), Helpers.joinList(this.writeDeactivators, null), this.mod, this.modGui, this.beforeUpdateListeners, this.afterUpdateListeners, this.updateType);
    }

    public AspectBuilder<V, T, O> appendKind(String kind) {
        return new AspectBuilder<V, T, O>(this.read, this.valueType, Helpers.joinList(this.kinds, kind), this.defaultAspectProperties, Helpers.joinList(this.valuePropagators, null), Helpers.joinList(this.writeActivators, null), Helpers.joinList(this.writeDeactivators, null), this.mod, this.modGui, this.beforeUpdateListeners, this.afterUpdateListeners, this.updateType);
    }

    public AspectBuilder<V, T, O> withProperties(IAspectProperties aspectProperties) {
        return new AspectBuilder<V, T, O>(this.read, this.valueType, Helpers.joinList(this.kinds, null), aspectProperties, Helpers.joinList(this.valuePropagators, null), Helpers.joinList(this.writeActivators, null), Helpers.joinList(this.writeDeactivators, null), this.mod, this.modGui, this.beforeUpdateListeners, this.afterUpdateListeners, this.updateType);
    }

    public AspectBuilder<V, T, O> appendActivator(IAspectWriteActivator activator) {
        if (this.read) {
            throw new RuntimeException("Activators are only applicable for writers.");
        }
        return new AspectBuilder<V, T, O>(this.read, this.valueType, Helpers.joinList(this.kinds, null), this.defaultAspectProperties, Helpers.joinList(this.valuePropagators, null), Helpers.joinList(this.writeActivators, activator), Helpers.joinList(this.writeDeactivators, null), this.mod, this.modGui, this.beforeUpdateListeners, this.afterUpdateListeners, this.updateType);
    }

    public AspectBuilder<V, T, O> appendDeactivator(IAspectWriteDeactivator deactivator) {
        if (this.read) {
            throw new RuntimeException("Deactivators are only applicable for writers.");
        }
        return new AspectBuilder<V, T, O>(this.read, this.valueType, Helpers.joinList(this.kinds, null), this.defaultAspectProperties, Helpers.joinList(this.valuePropagators, null), Helpers.joinList(this.writeActivators, null), Helpers.joinList(this.writeDeactivators, deactivator), this.mod, this.modGui, this.beforeUpdateListeners, this.afterUpdateListeners, this.updateType);
    }

    public AspectBuilder<V, T, O> byMod(ModBase mod) {
        return new AspectBuilder<V, T, O>(this.read, this.valueType, Helpers.joinList(this.kinds, null), this.defaultAspectProperties, Helpers.joinList(this.valuePropagators, null), Helpers.joinList(this.writeActivators, null), Helpers.joinList(this.writeDeactivators, null), mod, this.modGui, this.beforeUpdateListeners, this.afterUpdateListeners, this.updateType);
    }

    public AspectBuilder<V, T, O> byModGui(ModBase modGui) {
        return new AspectBuilder<V, T, O>(this.read, this.valueType, Helpers.joinList(this.kinds, null), this.defaultAspectProperties, Helpers.joinList(this.valuePropagators, null), Helpers.joinList(this.writeActivators, null), Helpers.joinList(this.writeDeactivators, null), this.mod, modGui, this.beforeUpdateListeners, this.afterUpdateListeners, this.updateType);
    }

    public AspectBuilder<V, T, O> appendBeforeUpdateListener(IAspectUpdateListener.Before listener) {
        return new AspectBuilder<V, T, O>(this.read, this.valueType, Helpers.joinList(this.kinds, null), this.defaultAspectProperties, Helpers.joinList(this.valuePropagators, null), Helpers.joinList(this.writeActivators, null), Helpers.joinList(this.writeDeactivators, null), this.mod, this.modGui, Helpers.joinList(this.beforeUpdateListeners, listener), Helpers.joinList(this.afterUpdateListeners, null), this.updateType);
    }

    public AspectBuilder<V, T, O> appendAfterUpdateListener(IAspectUpdateListener.After listener) {
        return new AspectBuilder<V, T, O>(this.read, this.valueType, Helpers.joinList(this.kinds, null), this.defaultAspectProperties, Helpers.joinList(this.valuePropagators, null), Helpers.joinList(this.writeActivators, null), Helpers.joinList(this.writeDeactivators, null), this.mod, this.modGui, Helpers.joinList(this.beforeUpdateListeners, null), Helpers.joinList(this.afterUpdateListeners, listener), this.updateType);
    }

    public AspectBuilder<V, T, O> withUpdateType(AspectUpdateType updateType) {
        if (!this.read) {
            throw new RuntimeException("Custom update types are only applicable to readers.");
        }
        return new AspectBuilder<V, T, O>(this.read, this.valueType, Helpers.joinList(this.kinds, null), this.defaultAspectProperties, Helpers.joinList(this.valuePropagators, null), Helpers.joinList(this.writeActivators, null), Helpers.joinList(this.writeDeactivators, null), this.mod, this.modGui, this.beforeUpdateListeners, this.afterUpdateListeners, updateType);
    }

    public IAspectRead<V, T> buildRead() {
        if (!this.read) {
            throw new RuntimeException("Tried to build a reader from a writer builder");
        }
        return new BuiltReader(this);
    }

    public IAspectWrite<V, T> buildWrite() {
        if (this.read) {
            throw new RuntimeException("Tried to build a writer from a reader builder");
        }
        return new BuiltWriter(this);
    }

    public static <V extends IValue, T extends IValueType<V>> AspectBuilder<V, T, Pair<PartTarget, IAspectProperties>> forReadType(T valueType) {
        return new AspectBuilder(true, valueType, (List<String>)ImmutableList.of((Object)valueType.getTypeName()), null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (ModBase)IntegratedDynamics._instance, (ModBase)IntegratedDynamics._instance, Lists.newArrayList(), Lists.newArrayList(), AspectUpdateType.NETWORK_TICK);
    }

    public static <V extends IValue, T extends IValueType<V>> AspectBuilder<V, T, Triple<PartTarget, IAspectProperties, IVariable<V>>> forWriteType(T valueType) {
        return new AspectBuilder(false, valueType, (List<String>)ImmutableList.of((Object)valueType.getTypeName()), null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (ModBase)IntegratedDynamics._instance, (ModBase)IntegratedDynamics._instance, Lists.newArrayList(), Lists.newArrayList(), AspectUpdateType.NETWORK_TICK);
    }

    private static class BuiltWriter<V extends IValue, T extends IValueType<V>>
    extends AspectWriteBase<V, T> {
        private final T valueType;
        private final List<IAspectValuePropagator> valuePropagators;
        private final List<IAspectWriteActivator> writeActivators;
        private final List<IAspectWriteDeactivator> writeDeactivators;
        private final List<IAspectUpdateListener.Before> beforeUpdateListeners;
        private final List<IAspectUpdateListener.After> afterUpdateListeners;

        public BuiltWriter(AspectBuilder<V, T, V> aspectBuilder) {
            super(((AspectBuilder)aspectBuilder).mod, ((AspectBuilder)aspectBuilder).modGui, BuiltWriter.deriveUnlocalizedType(aspectBuilder), ((AspectBuilder)aspectBuilder).defaultAspectProperties);
            this.valueType = ((AspectBuilder)aspectBuilder).valueType;
            this.valuePropagators = ((AspectBuilder)aspectBuilder).valuePropagators;
            this.writeActivators = ((AspectBuilder)aspectBuilder).writeActivators;
            this.writeDeactivators = ((AspectBuilder)aspectBuilder).writeDeactivators;
            this.beforeUpdateListeners = ((AspectBuilder)aspectBuilder).beforeUpdateListeners;
            this.afterUpdateListeners = ((AspectBuilder)aspectBuilder).afterUpdateListeners;
        }

        protected static <V extends IValue, T extends IValueType<V>> String deriveUnlocalizedType(AspectBuilder<V, T, V> aspectBuilder) {
            StringBuilder sb = new StringBuilder();
            for (String kind : ((AspectBuilder)aspectBuilder).kinds) {
                sb.append(".");
                sb.append(kind);
            }
            return sb.toString();
        }

        @Override
        public T getValueType() {
            return this.valueType;
        }

        @Override
        public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void write(P partType, PartTarget target, S state, IVariable<V> variable) throws EvaluationException {
            IAspectProperties properties = this.hasProperties() ? this.getProperties(partType, target, state) : null;
            Object output = Triple.of((Object)target, (Object)properties, variable);
            for (IAspectValuePropagator valuePropagator : this.valuePropagators) {
                output = valuePropagator.getOutput(output);
            }
        }

        @Override
        public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onActivate(P partType, PartTarget target, S state) {
            super.onActivate(partType, target, state);
            for (IAspectWriteActivator writeActivator : this.writeActivators) {
                writeActivator.onActivate(partType, target, state);
            }
        }

        @Override
        public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onDeactivate(P partType, PartTarget target, S state) {
            super.onDeactivate(partType, target, state);
            for (IAspectWriteDeactivator writeDeactivator : this.writeDeactivators) {
                writeDeactivator.onDeactivate(partType, target, state);
            }
        }

        @Override
        public <P extends IPartType<P, S>, S extends IPartState<P>> void update(INetwork network, IPartNetwork partNetwork, P partType, PartTarget target, S state) {
            this.beforeUpdateListeners.forEach(l -> l.onUpdate(network, partNetwork, partType, target, state));
            super.update(network, partNetwork, partType, target, state);
            this.afterUpdateListeners.forEach(l -> l.onUpdate(network, partNetwork, partType, target, state));
        }
    }

    private static class BuiltReader<V extends IValue, T extends IValueType<V>>
    extends AspectReadBase<V, T> {
        private final T valueType;
        private final List<IAspectValuePropagator> valuePropagators;
        private final List<IAspectUpdateListener.Before> beforeUpdateListeners;
        private final List<IAspectUpdateListener.After> afterUpdateListeners;

        public BuiltReader(AspectBuilder<V, T, V> aspectBuilder) {
            super(((AspectBuilder)aspectBuilder).mod, ((AspectBuilder)aspectBuilder).modGui, BuiltReader.deriveUnlocalizedType(aspectBuilder), ((AspectBuilder)aspectBuilder).defaultAspectProperties, ((AspectBuilder)aspectBuilder).updateType);
            this.valueType = ((AspectBuilder)aspectBuilder).valueType;
            this.valuePropagators = ((AspectBuilder)aspectBuilder).valuePropagators;
            this.beforeUpdateListeners = ((AspectBuilder)aspectBuilder).beforeUpdateListeners;
            this.afterUpdateListeners = ((AspectBuilder)aspectBuilder).afterUpdateListeners;
        }

        protected static <V extends IValue, T extends IValueType<V>> String deriveUnlocalizedType(AspectBuilder<V, T, V> aspectBuilder) {
            StringBuilder sb = new StringBuilder();
            for (String kind : ((AspectBuilder)aspectBuilder).kinds) {
                sb.append(".");
                sb.append(kind);
            }
            return sb.toString();
        }

        @Override
        protected V getValue(PartTarget target, IAspectProperties properties) throws EvaluationException {
            Object output = Pair.of((Object)target, (Object)properties);
            for (IAspectValuePropagator valuePropagator : this.valuePropagators) {
                output = valuePropagator.getOutput(output);
            }
            return (V)((IValue)output);
        }

        @Override
        public T getValueType() {
            return this.valueType;
        }

        @Override
        public <P extends IPartType<P, S>, S extends IPartState<P>> void update(INetwork network, IPartNetwork partNetwork, P partType, PartTarget target, S state) {
            this.beforeUpdateListeners.forEach(l -> l.onUpdate(network, partNetwork, partType, target, state));
            super.update(network, partNetwork, partType, target, state);
            this.afterUpdateListeners.forEach(l -> l.onUpdate(network, partNetwork, partType, target, state));
        }
    }
}

