/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.handlers.java.util.HandleMap;
import info.loenwind.autosave.util.NBTAction;
import info.loenwind.autosave.util.NullHelper;
import info.loenwind.autosave.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class HandleEnumMap<K extends Enum<K>>
extends HandleMap<EnumMap<K, ?>> {
    private final Class<K> enumClass;
    private final K[] enumValues;

    public HandleEnumMap() throws NoHandlerFoundException {
        super(EnumMap.class);
        this.enumClass = Enum.class;
        this.enumValues = new Enum[0];
    }

    protected HandleEnumMap(Registry registry, Class<K> enumClass, Type valueClass) throws NoHandlerFoundException {
        super(EnumMap.class, registry, enumClass, valueClass);
        this.enumClass = enumClass;
        this.enumValues = (Enum[])NullHelper.notnullJ(enumClass.getEnumConstants(), "Class#getEnumConstants");
    }

    @Override
    protected IHandler<? extends EnumMap<K, ?>> create(Registry registry, Type ... types) throws NoHandlerFoundException {
        return new HandleEnumMap(registry, TypeUtil.toClass(types[0]), types[1]);
    }

    @Override
    public boolean store(Registry registry, Set<NBTAction> phase, NBTTagCompound nbt, Type type, String name, EnumMap<K, ?> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagCompound tag = new NBTTagCompound();
        for (K key : this.enumValues) {
            Object val = object.get(key);
            String keystr = NullHelper.notnullJ(Integer.toString(((Enum)key).ordinal()), "Integer.toString is null");
            if (val != null) {
                this.storeRecursive(1, registry, phase, tag, keystr, val);
                continue;
            }
            tag.func_74757_a(keystr + "-", true);
        }
        nbt.func_74782_a(name, (NBTBase)tag);
        return true;
    }

    @Override
    @Nullable
    public EnumMap<K, ?> read(Registry registry, Set<NBTAction> phase, NBTTagCompound nbt, Type type, String name, @Nullable EnumMap<K, ?> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            if (object == null) {
                object = this.createMap();
            }
            NBTTagCompound tag = nbt.func_74775_l(name);
            for (K key : this.enumValues) {
                String keystr = NullHelper.notnullJ(Integer.toString(((Enum)key).ordinal()), "Integer.toString is null");
                if (tag.func_74767_n(keystr + "-")) continue;
                ((EnumMap)object).put(key, this.readRecursive(1, registry, phase, tag, keystr, null));
            }
        }
        return object;
    }

    @Override
    protected EnumMap<K, ?> createMap() {
        return new EnumMap(this.enumClass);
    }
}

