/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.ModBlocks;
import de.maxhenkel.gravestone.ModItems;
import de.maxhenkel.gravestone.entity.EntityGhostPlayer;
import de.maxhenkel.gravestone.tileentity.TileEntityGraveStone;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockEvents {
    private boolean removeDeathNote = Config.removeDeathNote;
    private boolean onlyOwnersCanBreak = Config.onlyPlayersCanBreak;
    private boolean spawnGhost = Config.spawnGhost;

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (event.isCanceled()) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (!event.getState().func_177230_c().equals((Object)ModBlocks.GRAVESTONE)) {
            return;
        }
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (!(te instanceof TileEntityGraveStone)) {
            return;
        }
        TileEntityGraveStone graveTileEntity = (TileEntityGraveStone)te;
        ItemStack stack = event.getPlayer().func_184586_b(event.getHand());
        if (stack == null || !stack.func_77973_b().equals(Item.func_150898_a((Block)ModBlocks.GRAVESTONE))) {
            return;
        }
        if (!stack.func_82837_s()) {
            return;
        }
        String name = stack.func_82833_r();
        if (name == null) {
            return;
        }
        graveTileEntity.setPlayerName(name);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (!event.getState().func_177230_c().equals((Object)ModBlocks.GRAVESTONE)) {
            return;
        }
        if (!this.checkBreak(event)) {
            return;
        }
        this.removeDeathNote(event);
        this.spawnGhost(event);
    }

    private void spawnGhost(BlockEvent.BreakEvent event) {
        if (!this.spawnGhost) {
            return;
        }
        World world = event.getWorld();
        if (!world.func_175623_d(event.getPos().func_177984_a())) {
            return;
        }
        TileEntity te = world.func_175625_s(event.getPos());
        if (te == null || !(te instanceof TileEntityGraveStone)) {
            return;
        }
        TileEntityGraveStone tileentity = (TileEntityGraveStone)te;
        UUID uuid = new UUID(0L, 0L);
        try {
            uuid = UUID.fromString(tileentity.getPlayerUUID());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EntityGhostPlayer z = new EntityGhostPlayer(event.getWorld(), uuid, tileentity.getPlayerName());
        z.func_70107_b((double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 0.1, (double)event.getPos().func_177952_p() + 0.5);
        world.func_72838_d((Entity)z);
    }

    private void removeDeathNote(BlockEvent.BreakEvent event) {
        if (!this.removeDeathNote) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        InventoryPlayer inv = player.field_71071_by;
        BlockPos pos = event.getPos();
        int dim = player.field_71093_bK;
        for (ItemStack stack : inv.field_70462_a) {
            DeathInfo info;
            if (stack == null || !stack.func_77973_b().equals((Object)ModItems.DEATH_INFO) || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("info") || (info = DeathInfo.fromNBT(stack.func_77978_p().func_74775_l("info"))) == null || dim != info.getDimension() || !pos.equals((Object)info.getDeathLocation())) continue;
            inv.func_184437_d(stack);
        }
        for (ItemStack stack : inv.field_70460_b) {
            if (stack == null || !stack.func_77973_b().equals((Object)ModItems.DEATH_INFO)) continue;
            inv.func_184437_d(stack);
        }
        for (ItemStack stack : inv.field_184439_c) {
            if (stack == null || !stack.func_77973_b().equals((Object)ModItems.DEATH_INFO)) continue;
            inv.func_184437_d(stack);
        }
    }

    public boolean checkBreak(BlockEvent.BreakEvent event) {
        EntityPlayerMP p;
        boolean isOp;
        if (!this.onlyOwnersCanBreak) {
            return true;
        }
        World world = event.getWorld();
        EntityPlayer player = event.getPlayer();
        TileEntity te = world.func_175625_s(event.getPos());
        if (te == null || !(te instanceof TileEntityGraveStone)) {
            return true;
        }
        TileEntityGraveStone tileentity = (TileEntityGraveStone)te;
        if (player instanceof EntityPlayerMP && (isOp = (p = (EntityPlayerMP)player).func_70003_b(p.field_71133_b.func_110455_j(), "op"))) {
            return true;
        }
        String uuid = tileentity.getPlayerUUID();
        if (uuid == null) {
            return true;
        }
        if (player.func_110124_au().toString().equals(uuid)) {
            return true;
        }
        event.setCanceled(true);
        return false;
    }
}

