/*
 * Decompiled with CFR 0.152.
 */
package net.jaspr.base.module;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.jaspr.base.module.ConfigHelper;
import net.jaspr.base.module.Feature;
import net.jaspr.base.module.Module;
import net.jaspr.fasterladderclimbing.feature.FeatureLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModuleLoader {
    private static List<Class<? extends Module>> moduleClasses = new ArrayList<Class<? extends Module>>();
    public static Map<Class<? extends Module>, Module> moduleInstances;
    public static Map<Class<? extends Feature>, Feature> featureInstances;
    public static List<Module> enabledModules;
    public static Configuration config;
    public static File configFile;

    public static void preInit(FMLPreInitializationEvent event) {
        moduleClasses.forEach(clazz -> {
            try {
                moduleInstances.put((Class<? extends Module>)clazz, (Module)clazz.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("Can't initialize module " + clazz, e);
            }
        });
        ModuleLoader.setupConfig(event);
        ModuleLoader.forEachModule(module -> FMLLog.info((String)("[FasterLadderClimbing] Module " + module.name + " is " + (module.enabled ? "enabled" : "disabled")), (Object[])new Object[0]));
        ModuleLoader.forEachEnabled(module -> module.preInit(event));
    }

    public static void init(FMLInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.init(event));
    }

    public static void postInit(FMLPostInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.postInit(event));
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient(FMLPreInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.preInitClient(event));
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient(FMLInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.initClient(event));
    }

    @SideOnly(value=Side.CLIENT)
    public static void postInitClient(FMLPostInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.postInitClient(event));
    }

    public static void serverStarting(FMLServerStartingEvent event) {
        ModuleLoader.forEachEnabled(module -> module.serverStarting(event));
    }

    public static void setupConfig(FMLPreInitializationEvent event) {
        configFile = event.getSuggestedConfigurationFile();
        config = new Configuration(configFile);
        config.load();
        ModuleLoader.forEachModule(module -> {
            module.enabled = true;
            if (module.canBeDisabled()) {
                ConfigHelper.needsRestart = true;
                module.enabled = ConfigHelper.loadPropBool(module.name, "_modules", module.getModuleDescription(), module.isEnabledByDefault());
            }
        });
        enabledModules = new ArrayList<Module>(moduleInstances.values());
        enabledModules.removeIf(module -> !module.enabled);
        ModuleLoader.loadModuleConfigs();
        MinecraftForge.EVENT_BUS.register((Object)new ChangeListener());
    }

    private static void loadModuleConfigs() {
        ModuleLoader.forEachModule(Module::setupConfig);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean isModuleEnabled(Class<? extends Module> clazz) {
        return ModuleLoader.moduleInstances.get(clazz).enabled;
    }

    public static boolean isFeatureEnabled(Class<? extends Feature> clazz) {
        return ModuleLoader.featureInstances.get(clazz).enabled;
    }

    public static void forEachModule(Consumer<Module> consumer) {
        moduleInstances.values().forEach(consumer);
    }

    public static void forEachEnabled(Consumer<Module> consumer) {
        enabledModules.forEach(consumer);
    }

    private static void registerModule(Class<? extends Module> clazz) {
        if (!moduleClasses.contains(clazz)) {
            moduleClasses.add(clazz);
        }
    }

    static {
        ModuleLoader.registerModule(FeatureLoader.class);
        moduleInstances = new HashMap<Class<? extends Module>, Module>();
        featureInstances = new HashMap<Class<? extends Feature>, Feature>();
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.getModID().equals("fasterladderclimbing")) {
                ModuleLoader.loadModuleConfigs();
            }
        }

        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.PostConfigChangedEvent eventArgs) {
            if (eventArgs.getModID().equals("fasterladderclimbing")) {
                ModuleLoader.loadModuleConfigs();
            }
        }
    }
}

