/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.tipthescales.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiNewOptionSlider
extends GuiButton {
    public static final String[] GUISCALES = new String[]{"options.guiScale.auto", "options.guiScale.small", "options.guiScale.normal", "options.guiScale.large"};
    public int sliderValue = 1;
    public boolean dragging;
    public final GameSettings.Options options;
    private final int minValue;
    private final int maxValue;

    public GuiNewOptionSlider(int buttonId, int x, int y, GameSettings.Options optionIn, int minValueIn, int maxValue) {
        super(buttonId, x, y, 150, 20, "");
        this.options = optionIn;
        this.minValue = minValueIn;
        this.maxValue = maxValue;
        Minecraft minecraft = Minecraft.func_71410_x();
        this.sliderValue = MathHelper.func_76125_a((int)minecraft.field_71474_y.field_74335_Z, (int)minValueIn, (int)maxValue);
        this.field_146126_j = this.getDisplayString(minecraft);
    }

    protected int func_146114_a(boolean mouseOver) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            if (this.dragging) {
                float index = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 10);
                this.sliderValue = Math.round(mc.field_71474_y.field_74335_Z > this.maxValue ? (float)mc.field_71474_y.field_74335_Z * index : (float)this.maxValue * index);
                this.sliderValue = MathHelper.func_76125_a((int)this.sliderValue, (int)this.minValue, (int)this.maxValue);
                this.field_146126_j = this.getDisplayString(mc);
            }
            mc.func_110434_K().func_110577_a(field_146122_a);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int renderX = Math.round(this.field_146128_h + this.sliderValue * (this.field_146120_f / this.maxValue));
            renderX = Math.max(this.field_146128_h, renderX);
            renderX = Math.min(this.field_146128_h + this.field_146120_f - 8, renderX);
            this.func_73729_b(renderX, this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(renderX + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public String getDisplayString(Minecraft mc) {
        String ret = I18n.func_135052_a((String)"options.guiScale", (Object[])new Object[0]) + ": ";
        if (this.sliderValue < GUISCALES.length) {
            return ret + this.getTranslation(GUISCALES, this.sliderValue) + String.format(" (%s)", this.sliderValue);
        }
        return ret + this.sliderValue;
    }

    public String getTranslation(String[] strArray, int index) {
        if (index < 0 || index >= strArray.length) {
            index = 0;
        }
        return I18n.func_135052_a((String)strArray[index], (Object[])new Object[0]);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.dragging = false;
        Minecraft.func_71410_x().field_71474_y.field_74335_Z = this.sliderValue;
    }
}

