/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class Config {
    private transient String version;
    public String curseProjectID;
    private String promoCode;
    private boolean creeperhostEnabled;
    private boolean mpMenuEnabled;
    private boolean mainMenuEnabled;
    private boolean serverHostButtonImage;
    private boolean serverHostMenuImage;
    private boolean sivIntegration;
    private boolean serverListEnabled;
    private boolean chatEnabled;
    private boolean autoMT;
    private int pregenDiameter = 120;
    private static Config instance;

    public Config() {
        this.version = "0";
        this.curseProjectID = "Insert curse project ID here";
        this.promoCode = "Insert Promo Code here";
        this.creeperhostEnabled = true;
        this.mpMenuEnabled = true;
        this.mainMenuEnabled = true;
        this.serverHostButtonImage = true;
        this.serverHostMenuImage = true;
        this.sivIntegration = true;
        this.serverListEnabled = true;
        this.chatEnabled = true;
        this.autoMT = true;
    }

    private Config(String version, String promoCode, boolean creeperhostEnabled, boolean mpMenuEnabled, boolean mainMenuEnabled, boolean serverHostButtonImage, boolean serverHostMenuImage) {
        this.version = version;
        this.promoCode = promoCode;
        this.creeperhostEnabled = creeperhostEnabled;
        this.mpMenuEnabled = mpMenuEnabled;
        this.mainMenuEnabled = mainMenuEnabled;
        this.serverHostButtonImage = serverHostButtonImage;
        this.serverHostMenuImage = serverHostMenuImage;
    }

    public static Config getInstance() {
        return instance;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPromo() {
        return this.promoCode;
    }

    public boolean isSivIntegration() {
        return this.sivIntegration;
    }

    public boolean isMpMenuEnabled() {
        return this.mpMenuEnabled;
    }

    public boolean isCreeperhostEnabled() {
        return this.creeperhostEnabled;
    }

    public boolean isMainMenuEnabled() {
        return this.mainMenuEnabled;
    }

    public boolean isServerHostButtonImage() {
        return this.serverHostButtonImage;
    }

    public boolean isServerHostMenuImage() {
        return this.serverHostMenuImage;
    }

    public boolean isServerListEnabled() {
        return this.serverListEnabled;
    }

    public int getPregenDiameter() {
        return this.pregenDiameter;
    }

    public void setMpMenuEnabled(boolean value) {
        this.mpMenuEnabled = value;
    }

    public void setServerListEnabled(boolean value) {
        this.serverListEnabled = value;
    }

    public void setChatEnabled(boolean value) {
        this.chatEnabled = value;
    }

    public boolean isChatEnabled() {
        return this.chatEnabled;
    }

    public boolean isAutoMT() {
        return this.autoMT;
    }

    public static void makeConfig(String version, String promoCode, boolean creeperhostEnabled, boolean mpMenuEnabled, boolean mainMenuEnabled, boolean serverHostButtonImage, boolean serverHostMenuImage) {
        if (instance != null) {
            return;
        }
        instance = new Config(version, promoCode, creeperhostEnabled, mpMenuEnabled, mainMenuEnabled, serverHostButtonImage, serverHostMenuImage);
    }

    public static void loadConfig(String configString) {
        Gson gson = new Gson();
        instance = (Config)gson.fromJson(configString, Config.class);
    }

    public static String saveConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)instance);
    }
}

