/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui.chat;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.CreeperHost;
import net.creeperhost.minetogether.chat.ChatHandler;
import net.creeperhost.minetogether.chat.Message;
import net.creeperhost.minetogether.chat.PrivateChat;
import net.creeperhost.minetogether.common.Config;
import net.creeperhost.minetogether.common.LimitedSizeQueue;
import net.creeperhost.minetogether.gui.GuiGDPR;
import net.creeperhost.minetogether.gui.chat.GuiChatFriend;
import net.creeperhost.minetogether.gui.chat.GuiTextFieldLockable;
import net.creeperhost.minetogether.gui.chat.Target;
import net.creeperhost.minetogether.gui.chat.TimestampComponentString;
import net.creeperhost.minetogether.gui.element.DropdownButton;
import net.creeperhost.minetogether.paul.Callbacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.client.GuiScrollingList;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiMTChat
extends GuiScreen {
    private final GuiScreen parent;
    private GuiScrollingChat chat;
    private GuiTextFieldLockable send;
    public DropdownButton<Target> targetDropdownButton;
    private GuiButton friendsButton;
    public static String playerName = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    private String currentTarget = ChatHandler.CHANNEL;
    private DropdownButton<Menu> menuDropdownButton;
    private String activeDropdown;
    private GuiButton reconnectionButton;
    private GuiButton cancelButton;
    private GuiButton invited;
    private boolean inviteTemp = false;
    long tickCounter = 0L;
    boolean disabledDueToConnection = false;
    boolean disabledDueToBadwords = false;
    static final Pattern patternA = Pattern.compile("((?:user)(\\d+))", 10);
    static final Pattern patternB = Pattern.compile("((?:@)(\\d+))", 10);
    static final Pattern patternC = Pattern.compile("((?:@user)(\\d+))", 10);
    private static Field field;
    private static final Pattern nameRegex;
    static SimpleDateFormat timestampFormat;
    static final Pattern URL_PATTERN;

    public GuiMTChat(GuiScreen parent) {
        this.parent = parent;
    }

    public GuiMTChat(GuiScreen parent, boolean invite) {
        this.parent = parent;
        this.inviteTemp = invite;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        if (!CreeperHost.instance.gdpr.hasAcceptedGDPR()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiGDPR(this.parent, () -> new GuiMTChat(this.parent)));
            return;
        }
        this.chat = new GuiScrollingChat(10);
        this.send = new GuiTextFieldLockable(8008, this.field_146297_k.field_71466_p, 10, this.field_146295_m - 50, this.field_146294_l - 20, 20);
        if (this.targetDropdownButton == null) {
            this.targetDropdownButton = new DropdownButton<Target>(-1337, this.field_146294_l - 5 - 100, 5, 100, 20, "Chat: %s", Target.getMainTarget(), true);
        } else {
            this.targetDropdownButton.field_146128_h = this.field_146294_l - 5 - 100;
        }
        this.field_146292_n.add(this.targetDropdownButton);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Mute");
        strings.add("Add friend");
        this.menuDropdownButton = new DropdownButton<Menu>(-1337, -1000, -1000, 100, 20, "Menu", new Menu(strings), true);
        this.field_146292_n.add(this.menuDropdownButton);
        this.friendsButton = new GuiButton(-80088, 5, 5, 100, 20, "Friends list");
        this.field_146292_n.add(this.friendsButton);
        this.cancelButton = new GuiButton(-800885, this.field_146294_l - 100 - 5, this.field_146295_m - 5 - 20, 100, 20, "Cancel");
        this.field_146292_n.add(this.cancelButton);
        this.reconnectionButton = new GuiButton(-80084, 85, this.field_146295_m - 5 - 20, 100, 20, "Reconnect");
        this.field_146292_n.add(this.reconnectionButton);
        this.reconnectionButton.field_146124_l = ChatHandler.tries >= 5;
        this.reconnectionButton.field_146125_m = this.reconnectionButton.field_146124_l;
        this.invited = new GuiButton(777, 75, this.field_146295_m - 5 - 20, 60, 20, "Invites");
        this.field_146292_n.add(this.invited);
        this.invited.field_146125_m = ChatHandler.privateChatInvite != null;
        this.send.func_146203_f(120);
        this.send.func_146195_b(true);
        if (this.inviteTemp) {
            this.confirmInvite();
            this.inviteTemp = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73876_c() {
        super.func_73876_c();
        if (ChatHandler.connectionStatus != ChatHandler.ConnectionStatus.CONNECTING && ChatHandler.connectionStatus != ChatHandler.ConnectionStatus.CONNECTED && this.tickCounter % 1200L == 0L && !ChatHandler.isInitting) {
            ChatHandler.reInit();
        }
        ++this.tickCounter;
        String buttonTarget = this.targetDropdownButton.getSelected().getInternalTarget();
        boolean changed = false;
        if (!buttonTarget.equals(this.currentTarget)) {
            changed = true;
            this.currentTarget = buttonTarget;
        }
        Object object = ChatHandler.ircLock;
        synchronized (object) {
            this.reconnectionButton.field_146124_l = ChatHandler.tries >= 5;
            this.reconnectionButton.field_146125_m = this.reconnectionButton.field_146124_l;
            if (changed || ChatHandler.hasNewMessages(this.currentTarget)) {
                this.chat.updateLines(this.currentTarget);
                ChatHandler.setMessagesRead(this.currentTarget);
            }
        }
    }

    public void rebuildChat() {
        this.chat.updateLines(this.currentTarget);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ChatHandler.ConnectionStatus status = ChatHandler.connectionStatus;
        this.func_146276_q_();
        this.targetDropdownButton.updateDisplayString();
        this.chat.drawScreen(mouseX, mouseY, partialTicks);
        this.send.func_146195_b(true);
        this.send.func_146194_f();
        if (!ChatHandler.isOnline()) {
            this.send.setDisabled("Cannot send messages as not connected");
            this.disabledDueToConnection = true;
        } else if (!this.targetDropdownButton.getSelected().isChannel() && !ChatHandler.friends.containsKey(this.currentTarget)) {
            this.send.setDisabled("Cannot send messages as friend is not online");
            this.disabledDueToConnection = true;
        } else if (this.disabledDueToConnection) {
            this.disabledDueToConnection = false;
            this.send.func_146184_c(true);
            Target.updateCache();
            if (!this.targetDropdownButton.getSelected().getPossibleVals().contains(this.targetDropdownButton.getSelected())) {
                this.targetDropdownButton.setSelected(Target.getMainTarget());
            }
            this.processBadwords();
        }
        this.func_73732_a(this.field_146289_q, "MineTogether Chat", this.field_146294_l / 2, 5, 0xFFFFFF);
        ITextComponent comp = new TextComponentString("\u2022").func_150255_a(new Style().func_150238_a(TextFormatting.func_96300_b((String)status.colour)));
        comp.func_150257_a(new TextComponentString(" " + status.display).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
        this.func_73731_b(this.field_146289_q, comp.func_150254_d(), 10, this.field_146295_m - 20, 0xFFFFFF);
        GuiMTChat.drawLogo(this.field_146289_q, this.field_146294_l - 20, this.field_146295_m - 30, 20, 30, 0.75f);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!this.send.getOurEnabled() && this.send.isHovered(mouseX, mouseY)) {
            this.func_146283_a(Arrays.asList(this.send.getDisabledMessage()), mouseX, mouseY);
        }
    }

    public static void drawLogo(FontRenderer fontRendererObj, int containerWidth, int containerHeight, int containerX, int containerY, float scale) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float adjust = 1.0f / scale;
        int width = (int)((float)containerWidth * adjust);
        int height = (int)((float)containerHeight * adjust);
        int x = (int)((float)containerX * adjust);
        int y = (int)((float)containerY * adjust);
        ResourceLocation resourceLocationCreeperLogo = new ResourceLocation("creeperhost", "textures/creeperhost_logo_1-25.png");
        ResourceLocation resourceLocationMineTogetherLogo = new ResourceLocation("creeperhost", "textures/minetogether25.png");
        GL11.glPushMatrix();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GL11.glEnable((int)3042);
        int mtHeight = 127;
        int mtWidth = 139;
        int creeperHeight = 22;
        int creeperWidth = 80;
        int totalHeight = mtHeight + creeperHeight;
        int totalWidth = mtWidth + creeperWidth;
        totalHeight = (int)((float)totalHeight * adjust);
        totalWidth = (int)((float)totalWidth * adjust);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocationMineTogetherLogo);
        Gui.func_146110_a((int)(x + (width / 2 - mtWidth / 2)), (int)(y + (height / 2 - totalHeight / 2)), (float)0.0f, (float)0.0f, (int)mtWidth, (int)mtHeight, (float)mtWidth, (float)mtHeight);
        String created = "Created by";
        int stringWidth = fontRendererObj.func_78256_a(created);
        int creeperTotalWidth = creeperWidth + stringWidth;
        fontRendererObj.func_175063_a(created, (float)(x + (width / 2 - creeperTotalWidth / 2)), (float)(y + (height / 2 - totalHeight / 2 + mtHeight + 7)), 0x40FFFFFF);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocationCreeperLogo);
        Gui.func_146110_a((int)(x + (width / 2 - creeperTotalWidth / 2 + stringWidth)), (int)(y + (height / 2 - totalHeight / 2 + mtHeight)), (float)0.0f, (float)0.0f, (int)creeperWidth, (int)creeperHeight, (float)creeperWidth, (float)creeperHeight);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public void func_146284_a(GuiButton button) throws IOException {
        if (button == this.targetDropdownButton && this.targetDropdownButton.field_146126_j.contains("new channel")) {
            PrivateChat p;
            ChatHandler.privateChatList = p = new PrivateChat("#" + CreeperHost.instance.ourNick, CreeperHost.instance.ourNick);
            ChatHandler.createChannel(p.getChannelname());
        }
        if (button == this.menuDropdownButton) {
            if (this.menuDropdownButton.getSelected().option.equals("Mute")) {
                CreeperHost.instance.muteUser(this.activeDropdown);
                this.chat.updateLines(this.currentTarget);
            } else if (this.menuDropdownButton.getSelected().option.equals("Add friend")) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiChatFriend(this, playerName, this.activeDropdown, Callbacks.getFriendCode(), "", false));
            }
        } else if (button == this.friendsButton) {
            CreeperHost.proxy.openFriendsGui();
        } else if (button == this.reconnectionButton) {
            ChatHandler.reInit();
        } else if (button == this.cancelButton) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (button == this.invited && ChatHandler.privateChatInvite != null) {
            this.confirmInvite();
        }
        this.chat.actionPerformed(button);
        super.func_146284_a(button);
    }

    public void confirmInvite() {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"You have been invited to join a private channel by %s", (Object[])new Object[]{CreeperHost.instance.getNameForUser(ChatHandler.privateChatInvite.getOwner())}), "Do you wish to accept this invite?" + (ChatHandler.hasGroup ? " You are already in a group chat - if you continue, you will swap groups - or disband the group if you are the host." : ""), 777));
    }

    public void func_73878_a(boolean result, int id) {
        if (result && id == 777 && ChatHandler.privateChatInvite != null) {
            ChatHandler.acceptPrivateChatInvite(ChatHandler.privateChatInvite);
            this.field_146297_k.func_147108_a((GuiScreen)this);
            CreeperHost.instance.clearToast(false);
            return;
        }
        super.func_73878_a(result, id);
    }

    public void processBadwords() {
        String text = this.send.func_146179_b().replaceAll(ChatHandler.badwordsFormat, "");
        boolean veryNaughty = false;
        if (ChatHandler.badwords != null) {
            for (String bad : ChatHandler.badwords) {
                if (bad.startsWith("(") && bad.endsWith(")") && text.matches(bad)) {
                    veryNaughty = true;
                    break;
                }
                if (!text.toLowerCase().contains(bad.toLowerCase())) continue;
                veryNaughty = true;
                break;
            }
        }
        if (veryNaughty) {
            this.send.setDisabled("Cannot send message as contains content which may not be suitable for all audiences");
            this.disabledDueToBadwords = true;
            return;
        }
        if (this.disabledDueToBadwords) {
            this.disabledDueToBadwords = false;
            this.send.func_146184_c(true);
        }
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        this.chat.handleElementClicks();
        this.chat.handleMouseInput(mouseX, mouseY);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.menuDropdownButton.wasJustClosed && !this.menuDropdownButton.dropdownOpen) {
            this.menuDropdownButton.field_146129_i = -10000;
            this.menuDropdownButton.field_146128_h = -10000;
            this.menuDropdownButton.wasJustClosed = false;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean ourEnabled;
        super.func_73869_a(typedChar, keyCode);
        if ((keyCode == 28 || keyCode == 156) && this.send.getOurEnabled() && !this.send.func_146179_b().trim().isEmpty()) {
            ChatHandler.sendMessage(this.currentTarget, GuiMTChat.getStringForSending(this.send.func_146179_b()));
            this.send.func_146180_a("");
        }
        if (!(ourEnabled = this.send.getOurEnabled())) {
            this.send.func_146184_c(true);
        }
        this.send.func_146201_a(typedChar, keyCode);
        if (!ourEnabled) {
            this.send.func_146184_c(false);
        }
        this.processBadwords();
    }

    public static String getStringForSending(String text) {
        CharSequence[] split = text.split(" ");
        for (int i = 0; i < split.length; ++i) {
            String word = split[i].toLowerCase();
            String subst = "User$2";
            Matcher matcher = patternA.matcher(word);
            Matcher matcherb = patternB.matcher(word);
            Matcher matcherc = patternC.matcher(word);
            String justNick = word;
            String result = word;
            if (matcher.matches()) {
                result = matcher.replaceAll("User$2");
            } else if (matcherb.matches()) {
                result = matcherb.replaceAll("User$2");
            } else if (matcherc.matches()) {
                result = matcherc.replaceAll("User$2");
            }
            justNick = result.replaceAll("[^A-Za-z0-9]", "");
            String tempWord = ChatHandler.anonUsersReverse.get(justNick);
            if (tempWord != null) {
                split[i] = result.replaceAll(justNick, tempWord);
                continue;
            }
            if (!justNick.toLowerCase().equals(playerName.toLowerCase())) continue;
            split[i] = result.replaceAll(justNick, CreeperHost.instance.ourNick);
        }
        text = String.join((CharSequence)" ", split);
        return text;
    }

    public boolean func_175276_a(ITextComponent component) {
        ClickEvent event = component.func_150256_b().func_150235_h();
        if (event == null) {
            return false;
        }
        if (event.func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND) {
            int mouseX;
            String eventValue = event.func_150668_b();
            if (eventValue.contains(":")) {
                String[] split = eventValue.split(":");
                if (split.length < 3) {
                    return false;
                }
                String chatInternalName = split[1];
                String friendCode = split[2];
                StringBuilder builder = new StringBuilder();
                for (int i = 3; i < split.length; ++i) {
                    builder.append(split[i]).append(" ");
                }
                String friendName = builder.toString().trim();
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiChatFriend(this, playerName, chatInternalName, friendCode, friendName, true));
                return true;
            }
            this.menuDropdownButton.field_146128_h = mouseX = Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            this.menuDropdownButton.field_146129_i = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.menuDropdownButton.dropdownOpen = true;
            this.activeDropdown = event.func_150668_b();
            return true;
        }
        return super.func_175276_a(component);
    }

    public static ITextComponent formatLine(Message message) {
        String realname;
        String[] splitString;
        String name2;
        String inputNick;
        String outputNick = inputNick = message.sender;
        if (inputNick.contains(":")) {
            String[] split = inputNick.split(":");
            switch (split[0]) {
                case "FR": {
                    if (split.length < 2) {
                        return null;
                    }
                    String nick = split[1];
                    String nickDisplay = ChatHandler.getNameForUser(nick);
                    if (!nickDisplay.startsWith("User")) {
                        return null;
                    }
                    String cmdStr = message.messageStr;
                    String[] cmdSplit = cmdStr.split(" ");
                    if (cmdSplit.length < 2) {
                        return null;
                    }
                    String friendCode = cmdSplit[0];
                    StringBuilder nameBuilder = new StringBuilder();
                    for (int i = 1; i < cmdSplit.length; ++i) {
                        nameBuilder.append(cmdSplit[i]);
                    }
                    String friendName = nameBuilder.toString();
                    TextComponentString userComp = new TextComponentString(friendName + " (" + nickDisplay + ") would like to add you as a friend. Click to ");
                    ITextComponent accept = new TextComponentString("<Accept>").func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "AC:" + nick + ":" + friendCode + ":" + friendName)).func_150238_a(TextFormatting.GREEN));
                    userComp.func_150257_a(accept);
                    return userComp;
                }
                case "FA": {
                    if (split.length < 2) {
                        return null;
                    }
                    String nick = split[1];
                    String nickDisplay = ChatHandler.getNameForUser(nick);
                    String friendName = message.messageStr;
                    TextComponentString userComp = new TextComponentString(friendName + " (" + nickDisplay + ") accepted your friend request.");
                    return userComp;
                }
            }
        }
        boolean friend = false;
        if (inputNick.startsWith("MT")) {
            if (inputNick.equals(CreeperHost.instance.ourNick) || inputNick.equals(CreeperHost.instance.ourNick + "`")) {
                outputNick = playerName;
            } else {
                if (CreeperHost.mutedUsers.contains(inputNick)) {
                    return null;
                }
                String newNick = ChatHandler.getNameForUser(inputNick);
                if (newNick == null) {
                    return null;
                }
                if (!inputNick.equals(newNick) && !newNick.startsWith("User")) {
                    friend = true;
                }
                if (!ChatHandler.autocompleteNames.contains(outputNick = newNick)) {
                    ChatHandler.autocompleteNames.add(outputNick);
                }
            }
        } else if (!inputNick.equals("System")) {
            return null;
        }
        TextComponentString base = new TextComponentString("");
        TextComponentString userComp = new TextComponentString("<" + outputNick + ">");
        userComp.func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
        if (!inputNick.equals(CreeperHost.instance.ourNick) && !inputNick.equals(CreeperHost.instance.ourNick + "`") && inputNick.startsWith("MT")) {
            userComp.func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, inputNick)));
        }
        String messageStr = message.messageStr;
        for (String swear : ChatHandler.badwords) {
            messageStr = messageStr.replace(swear, StringUtils.repeat((String)"*", (int)swear.length()));
        }
        CharSequence[] split = messageStr.split(" ");
        boolean highlight = false;
        for (int i = 0; i < split.length; ++i) {
            String splitStr = split[i];
            String justNick = splitStr.replaceAll("[^A-Za-z0-9]", "");
            if (!justNick.startsWith("MT")) continue;
            if (justNick.equals(ChatHandler.initedString)) {
                splitStr = splitStr.replaceAll(justNick, playerName);
                split[i] = splitStr;
                highlight = true;
                continue;
            }
            String userName = ChatHandler.getNameForUser(justNick);
            if (userName == null) continue;
            splitStr = splitStr.replaceAll(justNick, userName);
            split[i] = splitStr;
        }
        messageStr = String.join((CharSequence)" ", split);
        ITextComponent messageComp = GuiMTChat.newChatWithLinksOurs(messageStr);
        if (CreeperHost.bannedUsers.contains(inputNick)) {
            messageComp = new TextComponentString("message deleted").func_150255_a(new Style().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Message deleted as user was banned"))).func_150238_a(TextFormatting.DARK_GRAY).func_150217_b(Boolean.valueOf(true)));
        }
        messageComp.func_150256_b().func_150238_a(TextFormatting.WHITE);
        if (ChatHandler.curseSync.containsKey(inputNick) && (name2 = (splitString = (realname = ChatHandler.curseSync.get(inputNick).trim()).split(":"))[1]).contains(Config.getInstance().curseProjectID)) {
            userComp.func_150256_b().func_150238_a(TextFormatting.DARK_PURPLE);
        }
        if (inputNick.equals(CreeperHost.instance.ourNick) || inputNick.equals(CreeperHost.instance.ourNick + "`")) {
            messageComp.func_150256_b().func_150238_a(TextFormatting.GRAY);
            userComp.func_150256_b().func_150238_a(TextFormatting.GRAY);
        }
        if (friend) {
            userComp.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        } else if (outputNick.equals("System")) {
            Matcher matcher = nameRegex.matcher(messageStr);
            if (matcher.find()) {
                outputNick = matcher.group();
                messageStr = messageStr.substring(outputNick.length() + 1);
                outputNick = outputNick.substring(0, outputNick.length() - 1);
                messageComp = GuiMTChat.newChatWithLinksOurs(messageStr);
                userComp = new TextComponentString("<" + outputNick + ">");
            }
            userComp.func_150256_b().func_150238_a(TextFormatting.AQUA);
        }
        if (highlight) {
            userComp.func_150256_b().func_150238_a(TextFormatting.RED);
            messageComp.func_150256_b().func_150238_a(TextFormatting.RED);
            base.func_150256_b().func_150238_a(TextFormatting.RED);
        }
        base.func_150256_b().func_150209_a(new HoverEvent(CreeperHost.instance.TIMESTAMP, new TextComponentString(timestampFormat.format(new Date(message.timeReceived))).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY))));
        base.func_150257_a((ITextComponent)new TimestampComponentString("Test"));
        base.func_150257_a((ITextComponent)userComp);
        base.func_150257_a(new TextComponentString(" ").func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
        return base.func_150257_a(messageComp);
    }

    public static ITextComponent newChatWithLinksOurs(String string) {
        ITextComponent component = ForgeHooks.newChatWithLinks((String)string);
        if (component.func_150256_b().func_150235_h() != null) {
            ITextComponent oldcomponent = component;
            List siblings = oldcomponent.func_150253_a();
            component = new TextComponentString("");
            component.func_150257_a(oldcomponent);
            for (ITextComponent sibling : siblings) {
                component.func_150257_a(sibling);
            }
            siblings.clear();
        }
        return component;
    }

    static {
        try {
            field = GuiScrollingList.class.getDeclaredField("scrollDistance");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        nameRegex = Pattern.compile("^(\\w+?):");
        timestampFormat = new SimpleDateFormat("[HH:mm:ss] ");
        URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
    }

    public static class Menu
    implements DropdownButton.IDropdownOption {
        List<DropdownButton.IDropdownOption> possibleValsCache;
        public String option;

        public Menu(List<String> options) {
            this.possibleValsCache = new ArrayList<DropdownButton.IDropdownOption>();
            this.possibleValsCache.add(this);
            this.option = options.get(0);
            options.remove(0);
            for (String option : options) {
                this.possibleValsCache.add(new Menu(this.possibleValsCache, option));
            }
        }

        public Menu(List<DropdownButton.IDropdownOption> vals, String option) {
            this.possibleValsCache = vals;
            this.option = option;
        }

        @Override
        public String getTranslate(DropdownButton.IDropdownOption current, boolean dropdownOpen) {
            return this.option;
        }

        @Override
        public List<DropdownButton.IDropdownOption> getPossibleVals() {
            return this.possibleValsCache;
        }
    }

    private class GuiScrollingChat
    extends GuiScrollingList {
        private ArrayList<ITextComponent> lines;
        int elementClicked;

        GuiScrollingChat(int entryHeight) {
            super(Minecraft.func_71410_x(), GuiMTChat.this.field_146294_l - 20, GuiMTChat.this.field_146295_m - 50, 30, GuiMTChat.this.field_146295_m - 50, 10, entryHeight, GuiMTChat.this.field_146294_l, GuiMTChat.this.field_146295_m);
            this.elementClicked = -1;
            this.lines = new ArrayList();
            this.updateLines(GuiMTChat.this.currentTarget);
        }

        protected int getContentHeight() {
            int viewHeight = this.bottom - this.top - 4;
            return super.getContentHeight() < viewHeight ? viewHeight : super.getContentHeight();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateLines(String key) {
            LimitedSizeQueue<Message> tempMessages;
            Object object = ChatHandler.ircLock;
            synchronized (object) {
                if (ChatHandler.messages == null || ChatHandler.messages.size() == 0) {
                    return;
                }
                tempMessages = ChatHandler.messages.get(key);
            }
            ArrayList<ITextComponent> oldLines = this.lines;
            int listHeight = this.getContentHeight() - (this.bottom - this.top - 4);
            this.lines = new ArrayList();
            if (tempMessages == null) {
                return;
            }
            for (Message message : tempMessages) {
                ITextComponent display = GuiMTChat.formatLine(message);
                if (display == null) continue;
                List strings = GuiUtilRenderComponents.func_178908_a((ITextComponent)display, (int)(this.listWidth - 6), (FontRenderer)GuiMTChat.this.field_146289_q, (boolean)false, (boolean)true);
                for (ITextComponent string : strings) {
                    this.lines.add(string);
                }
            }
            try {
                if (this.lines.size() > oldLines.size() && ((Float)field.get((Object)this)).floatValue() == (float)listHeight || listHeight < 0) {
                    listHeight = this.getContentHeight() - (this.bottom - this.top - 4);
                    field.set((Object)this, listHeight);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        protected int getSize() {
            return this.lines.size();
        }

        protected void handleElementClicks() {
            if (this.elementClicked == -1) {
                return;
            }
            ITextComponent component = this.lines.get(this.elementClicked);
            this.elementClicked = -1;
            int mouseX = Mouse.getX() * GuiMTChat.this.field_146294_l / GuiMTChat.this.field_146297_k.field_71443_c;
            mouseX -= this.left;
            int totalWidth = 0;
            for (ITextComponent sibling : component.func_150253_a()) {
                int oldTotal = totalWidth;
                if (sibling.func_150256_b().func_150235_h() == null || mouseX <= oldTotal || mouseX >= (totalWidth += GuiMTChat.this.field_146289_q.func_78256_a(sibling.func_150254_d()))) continue;
                GuiMTChat.this.func_175276_a(sibling);
                return;
            }
        }

        protected void elementClicked(int index, boolean doubleClick) {
            this.elementClicked = index;
        }

        protected boolean isSelected(int index) {
            return false;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            ITextComponent component = this.lines.get(slotIdx);
            int mouseX = Mouse.getX() * GuiMTChat.this.field_146294_l / GuiMTChat.this.field_146297_k.field_71443_c;
            mouseX -= this.left;
            int totalWidth = 5;
            for (ITextComponent sibling : component.func_150253_a()) {
                boolean hovering;
                int oldTotal = totalWidth;
                boolean bl = hovering = mouseX > oldTotal && mouseX < (totalWidth += GuiMTChat.this.field_146289_q.func_78256_a(sibling.func_150254_d())) && this.mouseY > slotTop && this.mouseY < slotTop + this.slotHeight;
                if (sibling.func_150256_b().func_150235_h() != null) {
                    if (hovering) {
                        GuiMTChat.this.field_146297_k.field_71466_p.func_78276_b(TextFormatting.func_110646_a((String)sibling.func_150261_e()), this.left + oldTotal, slotTop, -16777216);
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
                        GuiMTChat.this.field_146297_k.field_71466_p.func_78276_b(sibling.func_150254_d(), this.left + oldTotal, slotTop, -1140850689);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        continue;
                    }
                    GuiMTChat.this.field_146297_k.field_71466_p.func_78276_b(sibling.func_150254_d(), this.left + oldTotal, slotTop, -1);
                    continue;
                }
                GuiMTChat.this.field_146297_k.field_71466_p.func_78276_b(sibling.func_150254_d(), this.left + oldTotal, slotTop, 0xFFFFFF);
            }
        }
    }
}

