/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui.serverlist.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.ArrayList;
import net.creeperhost.minetogether.CreeperHost;
import net.creeperhost.minetogether.Util;
import net.creeperhost.minetogether.chat.ChatHandler;
import net.creeperhost.minetogether.gui.GuiGDPR;
import net.creeperhost.minetogether.gui.GuiYahNah;
import net.creeperhost.minetogether.gui.element.GuiTextFieldCompat;
import net.creeperhost.minetogether.gui.list.GuiList;
import net.creeperhost.minetogether.gui.list.GuiListEntryFriend;
import net.creeperhost.minetogether.gui.list.GuiListEntryMuted;
import net.creeperhost.minetogether.paul.Callbacks;
import net.creeperhost.minetogether.serverlist.data.Friend;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;

public class GuiFriendsList
extends GuiScreen
implements GuiYesNoCallback {
    private final GuiScreen parent;
    private GuiList<GuiListEntryFriend> list;
    private GuiList<GuiListEntryMuted> listMuted;
    private GuiButton buttonAdd;
    private GuiButton buttonCancel;
    private GuiButton buttonInvite;
    private GuiButton buttonCopy;
    private GuiButton buttonRefresh;
    private GuiButton buttonChat;
    private GuiButton buttonRemove;
    private GuiButton toggle;
    private GuiButton channelInviteButton;
    private GuiTextFieldCompat codeEntry;
    private GuiTextFieldCompat displayEntry;
    private boolean addFriend = false;
    private String friendCode;
    private boolean first = true;
    private String friendDisplayString;
    private String errorText = null;
    private String hoveringText = null;
    private String lastHoveringText = null;
    private ArrayList<String> hoverTextCache = null;
    private Friend removeFriend;
    private String unmutePlayer;
    private Friend invitedPlayer;
    private boolean channelInvite = false;
    private boolean isMuted;

    public GuiFriendsList(GuiScreen currentScreen) {
        this.parent = currentScreen;
        this.friendCode = Callbacks.getFriendCode();
        CreeperHost.instance.clearToast(false);
    }

    public void func_73866_w_() {
        if (!CreeperHost.instance.gdpr.hasAcceptedGDPR()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiGDPR(this.parent, () -> new GuiFriendsList(this.parent)));
            return;
        }
        super.func_73866_w_();
        if (this.listMuted == null) {
            this.listMuted = new GuiList(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 64, 36);
        } else {
            this.listMuted.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 64);
        }
        if (this.list == null) {
            this.list = new GuiList(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 64, 36);
        } else {
            this.list.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 64);
        }
        if (this.first) {
            this.first = false;
            this.refreshFriendsList(true);
            this.refreshMutedList(true);
        }
        int y = this.field_146295_m - 60;
        int margin = 10;
        int buttons = 3;
        int buttonWidth = 80;
        int totalButtonSize = buttonWidth * buttons;
        int nonButtonSpace = this.field_146294_l - margin * 2 - totalButtonSize;
        int spaceInbetween = nonButtonSpace / (buttons - 1) + buttonWidth;
        int buttonX = margin;
        this.buttonCancel = new GuiButton(0, buttonX, y, buttonWidth, 20, Util.localize("button.cancel", new Object[0]));
        this.field_146292_n.add(this.buttonCancel);
        this.buttonAdd = new GuiButton(1, buttonX += spaceInbetween, y, buttonWidth, 20, Util.localize("multiplayer.button.addfriend", new Object[0]));
        this.field_146292_n.add(this.buttonAdd);
        this.buttonInvite = new GuiButton(4, buttonX += spaceInbetween, y, buttonWidth, 20, Util.localize("multiplayer.button.invite", new Object[0]));
        this.buttonInvite.field_146124_l = this.list.getCurrSelected() != null;
        this.field_146292_n.add(this.buttonInvite);
        this.codeEntry = new GuiTextFieldCompat(3, this.field_146289_q, this.field_146294_l / 2 - 80, this.field_146295_m / 2 - 50, 160, 20);
        this.displayEntry = new GuiTextFieldCompat(3, this.field_146289_q, this.field_146294_l / 2 - 80, this.field_146295_m / 2 + 0, 160, 20);
        this.friendDisplayString = Util.localize("multiplayer.friendcode", this.friendCode);
        int friendWidth = this.field_146289_q.func_78256_a(this.friendDisplayString);
        this.buttonCopy = new GuiButton(4, 10 + friendWidth + 3, this.field_146295_m - 26, 80, 20, Util.localize("multiplayer.button.copy", new Object[0]));
        this.field_146292_n.add(this.buttonCopy);
        this.buttonRefresh = new GuiButton(1337, this.field_146294_l - 90, this.field_146295_m - 26, 80, 20, Util.localize("multiplayer.button.refresh", new Object[0]));
        this.field_146292_n.add(this.buttonRefresh);
        this.toggle = new GuiButton(5, this.field_146294_l - 60, 6, 60, 20, this.isMuted ? "Friends" : "Muted");
        this.field_146292_n.add(this.toggle);
    }

    protected void refreshFriendsList(boolean force) {
        ArrayList<Friend> friends = Callbacks.getFriendsList(force);
        this.list.clearList();
        if (friends != null) {
            for (Friend friend : friends) {
                GuiListEntryFriend friendEntry = new GuiListEntryFriend(this, this.list, friend);
                this.list.addEntry(friendEntry);
            }
        }
    }

    protected void refreshMutedList(boolean force) {
        ArrayList<String> mutedUsers = CreeperHost.mutedUsers;
        this.listMuted.clearList();
        if (mutedUsers != null) {
            for (String mute : mutedUsers) {
                String username = CreeperHost.instance.getNameForUser(mute);
                GuiListEntryMuted mutedEntry = new GuiListEntryMuted(this, this.listMuted, username);
                this.listMuted.addEntry(mutedEntry);
            }
        }
    }

    public void func_146281_b() {
        CreeperHost.instance.clearToast(false);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.buttonCancel) {
            if (!this.addFriend) {
                this.field_146297_k.func_147108_a(this.parent);
            } else {
                this.addFriend = false;
                this.buttonInvite.field_146125_m = true;
                this.codeEntry.func_146180_a("");
            }
        } else if (button == this.buttonAdd) {
            if (!this.addFriend) {
                this.addFriend = true;
                this.buttonInvite.field_146125_m = false;
            } else if (!this.codeEntry.func_146179_b().isEmpty()) {
                String result = Callbacks.addFriend(this.codeEntry.func_146179_b(), this.displayEntry.func_146179_b());
                this.addFriend = false;
                if (result == null) {
                    this.list.addEntry(new GuiListEntryFriend(this, this.list, new Friend(this.displayEntry.func_146179_b(), this.codeEntry.func_146179_b(), false)));
                }
                this.buttonInvite.field_146125_m = true;
                this.showAlert(result == null ? Util.localize("multiplayer.friendsent", new Object[0]) : result, 65280, 5000);
            }
        } else if (button == this.buttonInvite && button.field_146124_l && button.field_146125_m) {
            if (CreeperHost.instance.curServerId == -1) {
                this.showAlert(Util.localize("multiplayer.notinvite", new Object[0]), 0xFF0000, 5000);
                return;
            }
            boolean ret = Callbacks.inviteFriend(this.list.getCurrSelected().getFriend());
            if (ret) {
                Callbacks.inviteFriend(this.list.getCurrSelected().getFriend());
                this.showAlert(Util.localize("multiplayer.invitesent", new Object[0]), 65280, 5000);
            } else {
                this.showAlert(Util.localize("multiplayer.couldnotinvite", new Object[0]), 0xFF0000, 5000);
            }
        } else if (button == this.buttonCopy) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.friendCode), null);
            this.showAlert("Copied to clipboard.", 65280, 5000);
        } else if (button == this.buttonRefresh) {
            this.refreshFriendsList(false);
        } else if (button.field_146127_k == this.toggle.field_146127_k) {
            if (button.field_146126_j.contains("Friends")) {
                button.field_146126_j = "Muted";
                this.isMuted = true;
            } else if (button.field_146126_j.contains("Muted")) {
                button.field_146126_j = "Friends";
                this.isMuted = false;
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        if (!this.isMuted) {
            if (!this.addFriend) {
                this.list.func_148128_a(mouseX, mouseY, partialTicks);
            } else {
                this.func_73732_a(this.field_146289_q, Util.localize("multiplayer.othercode", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 60, 0xFFFFFF);
                this.func_73732_a(this.field_146289_q, Util.localize("multiplayer.displayname", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 10, 0xFFFFFF);
                this.codeEntry.func_146194_f();
                this.displayEntry.func_146194_f();
            }
            this.func_73732_a(this.field_146289_q, Util.localize("multiplayer.friends", new Object[0]), this.field_146294_l / 2, 10, -1);
        } else {
            this.listMuted.func_148128_a(mouseX, mouseY, partialTicks);
            this.func_73732_a(this.field_146289_q, Util.localize("multiplayer.muted", new Object[0]), this.field_146294_l / 2, 10, -1);
        }
        this.func_73731_b(this.field_146289_q, this.friendDisplayString, 10, this.field_146295_m - 20, -1);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hoveringText != null) {
            if (this.hoveringText != this.lastHoveringText) {
                this.hoverTextCache = new ArrayList();
                this.hoverTextCache.add(this.hoveringText);
                this.lastHoveringText = this.hoveringText;
            }
            this.func_146283_a(this.hoverTextCache, mouseX + 12, mouseY);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.codeEntry.func_146206_l()) {
            this.codeEntry.func_146201_a(typedChar, keyCode);
        } else if (this.displayEntry.func_146206_l()) {
            this.displayEntry.func_146201_a(typedChar, keyCode);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.func_178039_p();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.codeEntry.myMouseClicked(mouseX, mouseY, mouseButton);
        this.displayEntry.myMouseClicked(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (!this.isMuted) {
            this.list.func_148179_a(mouseX, mouseY, mouseButton);
        } else {
            this.listMuted.func_148179_a(mouseX, mouseY, mouseButton);
        }
        this.buttonInvite.field_146124_l = this.list.getCurrSelected() != null ? this.list.getCurrSelected().getFriend().isAccepted() : false;
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.isMuted) {
            this.list.func_148181_b(mouseX, mouseY, state);
        } else {
            this.listMuted.func_148181_b(mouseX, mouseY, state);
        }
    }

    private void showAlert(String text, int colour, int time) {
        CreeperHost.instance.displayToast(text, time, null);
    }

    public void setHoveringText(String hoveringText) {
        this.hoveringText = hoveringText;
    }

    public void removeFriend(Friend friend) {
        this.removeFriend = friend;
        this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"minetogether.removefriend.sure1", (Object[])new Object[0]), I18n.func_135052_a((String)"minetogether.removefriend.sure2", (Object[])new Object[0]), 0));
    }

    public void inviteGroupChat(Friend invited) {
        this.invitedPlayer = invited;
        this.field_146297_k.func_147108_a((GuiScreen)new GuiYahNah(this, I18n.func_135052_a((String)"minetogether.groupinvite.sure1", (Object[])new Object[0]), I18n.func_135052_a((String)"minetogether.groupinvite.sure2", (Object[])new Object[0]), 1));
    }

    public void unmutePlayer(String muted) {
        this.unmutePlayer = muted;
        this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"minetogether.unmute.sure1", (Object[])new Object[0]), I18n.func_135052_a((String)"minetogether.unmute.sure2", (Object[])new Object[0]), 2));
    }

    public void func_73878_a(boolean result, int id) {
        if (result) {
            if (id == 0) {
                Callbacks.removeFriend(this.removeFriend.getCode());
                this.refreshFriendsList(true);
            } else if (id == 2) {
                CreeperHost.instance.unmuteUser(this.unmutePlayer);
                this.listMuted.clearList();
                this.refreshMutedList(false);
            } else if (id == 1) {
                if (!this.invitedPlayer.isAccepted()) {
                    this.showAlert("Cannot invite pending friends", 65280, 5000);
                } else {
                    String friendCode = "MT" + this.invitedPlayer.getCode().substring(0, 15);
                    this.showAlert("Sent invite to " + this.invitedPlayer.getName(), 65280, 5000);
                    ChatHandler.sendChannelInvite(friendCode, CreeperHost.instance.ourNick);
                }
            }
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }
}

