/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.Command;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ChannelCommand<C extends ChannelCommand<C>>
extends Command<ChannelCommand<C>> {
    private final String channel;

    protected ChannelCommand(@NonNull Client client, @NonNull String channel) {
        super(client);
        Sanity.safeMessageCheck(channel, "Channel");
        Sanity.truthiness(client.getServerInfo().isValidChannel(channel), "Invalid channel name '" + channel + '\'');
        this.channel = channel;
    }

    public @NonNull String getChannel() {
        return this.channel;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("channel", this.getChannel());
    }
}

