/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import java.util.ArrayList;
import java.util.List;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ClientLinked;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.MessageTag;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.MessageTagManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class Command<C extends Command<C>>
implements ClientLinked {
    private final Client client;
    private Tags tags;

    protected Command(@NonNull Client client) {
        this.client = Sanity.nullCheck(client, "Client");
    }

    @Override
    public @NonNull Client getClient() {
        return this.client;
    }

    public abstract void execute();

    protected void sendCommandLine(@NonNull String line) {
        this.sendCommandLine(line, false);
    }

    protected void sendCommandLine(@NonNull String line, boolean immediately) {
        if (this.tags == null || this.tags.tags.isEmpty()) {
            if (immediately) {
                this.client.sendRawLineImmediately(line);
            } else {
                this.client.sendRawLine(line);
            }
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append('@');
            for (MessageTag tag : this.tags.tags) {
                builder.append(tag.getAsString()).append(';');
            }
            builder.setCharAt(builder.length() - 1, ' ');
            builder.append(line);
            if (immediately) {
                this.client.sendRawLineImmediately(builder.toString());
            } else {
                this.client.sendRawLine(builder.toString());
            }
        }
    }

    public Tags tags() {
        if (this.tags == null) {
            this.tags = new Tags();
        }
        return this.tags;
    }

    public String toString() {
        return this.toStringer().toString();
    }

    protected @NonNull ToStringer toStringer() {
        return new ToStringer(this).add("client", this.getClient());
    }

    public class Tags {
        private List<MessageTag> tags = new ArrayList<MessageTag>();

        public Tags add(@NonNull MessageTag tag) {
            this.tags.add(Sanity.nullCheck(tag, "Tag"));
            return this;
        }

        public Tags add(@NonNull String name) {
            this.tags.add(new MessageTagManager.DefaultMessageTag(Sanity.nullCheck(name, "Name"), null));
            return this;
        }

        public Tags add(@NonNull String name, @NonNull String value) {
            Sanity.nullCheck(name, "Name");
            Sanity.nullCheck(value, "Value");
            this.tags.add(new MessageTagManager.DefaultMessageTag(name, value));
            return this;
        }

        public Tags clear() {
            this.tags.clear();
            return this;
        }

        public C then() {
            return Command.this;
        }
    }
}

