/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.Command;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.MessageReceiver;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NoticeCommand
extends Command<NoticeCommand> {
    private String target;
    private String message;

    public NoticeCommand(@NonNull Client client) {
        super(client);
    }

    public @NonNull NoticeCommand target(@NonNull String target) {
        this.target = Sanity.safeMessageCheck(target, "Target");
        return this;
    }

    public @NonNull NoticeCommand target(@NonNull MessageReceiver target) {
        this.target = Sanity.nullCheck(target, "Target").getMessagingName();
        return this;
    }

    public @NonNull NoticeCommand message(@Nullable String message) {
        this.message = Sanity.safeMessageCheck(message, "Message");
        return this;
    }

    @Override
    public void execute() {
        if (this.target == null) {
            throw new IllegalStateException("Target not defined");
        }
        if (this.message == null) {
            throw new IllegalStateException("Message not defined");
        }
        this.sendCommandLine("NOTICE " + this.target + " :" + this.message);
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("target", this.target).add("message", this.message);
    }
}

