/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.MessageTag;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultServerMessage
implements ServerMessage {
    private final String message;
    private final List<MessageTag> tags;

    public DefaultServerMessage(@NonNull String message, @NonNull List<MessageTag> tags) {
        Sanity.nullCheck(message, "Message");
        Sanity.nullCheck(tags, "Tags");
        this.message = message;
        this.tags = Collections.unmodifiableList(new ArrayList<MessageTag>(tags));
    }

    @Override
    public @NonNull String getMessage() {
        return this.message;
    }

    @Override
    public final @NonNull List<MessageTag> getTags() {
        return this.tags;
    }

    public @NonNull String toString() {
        return new ToStringer(this).add("message", this.message).add("tags", this.tags).toString();
    }

    public static class StringCommand
    extends DefaultServerMessage
    implements ServerMessage.StringCommandServerMessage {
        private final String command;

        public StringCommand(@NonNull String command, @NonNull String message, @NonNull List<MessageTag> tags) {
            super(message, tags);
            this.command = command;
        }

        @Override
        public @NonNull String getCommand() {
            return this.command;
        }
    }

    public static class NumericCommand
    extends DefaultServerMessage
    implements ServerMessage.NumericCommandServerMessage {
        private final int command;

        public NumericCommand(int command, @NonNull String message, @NonNull List<MessageTag> tags) {
            super(message, tags);
            this.command = command;
        }

        @Override
        public int getCommand() {
            return this.command;
        }
    }
}

