/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener;

import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultModeInfo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeInfo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelModeInfoListEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AbstractModeInfoListenerBase
extends AbstractDefaultListenerBase {
    public AbstractModeInfoListenerBase( @NonNull Client.WithManagement client) {
        super(client);
    }

    protected void modeInfoList(@NonNull ClientReceiveNumericEvent event, @NonNull String name, char mode, @NonNull List<ServerMessage> messageList, @NonNull List<ModeInfo> infoList) {
        this.modeInfoList(event, name, mode, messageList, infoList, 0);
    }

    protected void modeInfoList(@NonNull ClientReceiveNumericEvent event, @NonNull String name, char mode, @NonNull List<ServerMessage> messageList, @NonNull List<ModeInfo> infoList, int offset) {
        if (event.getParameters().size() < 3 + offset) {
            this.trackException(event, name + " response too short");
            return;
        }
        Channel channel = this.getChannel(event, name);
        if (channel == null) {
            return;
        }
        ChannelMode channelMode = this.getChannelMode(event, name, mode);
        if (channelMode == null) {
            return;
        }
        messageList.add(event.getServerMessage());
        String creator = event.getParameters().size() > 3 + offset ? event.getParameters().get(3 + offset) : null;
        Instant creationTime = null;
        if (event.getParameters().size() > 4 + offset) {
            try {
                creationTime = Instant.ofEpochSecond(Integer.parseInt(event.getParameters().get(4 + offset)));
            }
            catch (NumberFormatException | DateTimeException runtimeException) {
                // empty catch block
            }
        }
        infoList.add(new DefaultModeInfo(this.getClient(), channel, channelMode, event.getParameters().get(2 + offset), creator, creationTime));
    }

    protected void endModeInfoList(@NonNull ClientReceiveNumericEvent event, @NonNull String name, char mode, @NonNull List<ServerMessage> messageList, @NonNull List<ModeInfo> infoList) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, name + " response too short");
            return;
        }
        Channel channel = this.getChannel(event, name);
        if (channel == null) {
            return;
        }
        ChannelMode channelMode = this.getChannelMode(event, name, mode);
        if (channelMode == null) {
            return;
        }
        messageList.add(event.getServerMessage());
        ArrayList<ModeInfo> modeInfos = new ArrayList<ModeInfo>(infoList);
        this.fire(new ChannelModeInfoListEvent(this.getClient(), messageList, channel, channelMode, modeInfos));
        this.getTracker().setChannelModeInfoList(channel.getName(), mode, modeInfos);
        infoList.clear();
        messageList.clear();
    }

    protected @Nullable Channel getChannel(@NonNull ClientReceiveNumericEvent event, @NonNull String name) {
        Channel channel = this.getTracker().getChannel(event.getParameters().get(1)).orElse(null);
        if (channel == null) {
            this.trackException(event, name + " response sent for invalid channel name");
        }
        return channel;
    }

    protected @Nullable ChannelMode getChannelMode(@NonNull ClientReceiveNumericEvent event, @NonNull String name, char mode) {
        ChannelMode channelMode = this.getClient().getServerInfo().getChannelMode(mode).orElse(null);
        if (channelMode == null) {
            this.trackException(event, name + " can't list if there's no '" + mode + "' mode");
        }
        return channelMode;
    }
}

