/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener;

import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientAwayStatusChangeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.UserAwayMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.NumericFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.StringUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultAwayListener
extends AbstractDefaultListenerBase {
    public DefaultAwayListener( @NonNull Client.WithManagement client) {
        super(client);
    }

    @NumericFilter.Numerics(value={@NumericFilter(value=305), @NumericFilter(value=306)})
    @Handler(priority=0x7FFFFFFE)
    public void away(ClientReceiveNumericEvent event) {
        this.fire(new ClientAwayStatusChangeEvent(this.getClient(), event.getSource(), event.getNumeric() == 306));
    }

    @CommandFilter(value="AWAY")
    @Handler(priority=0x7FFFFFFE)
    public void away(ClientReceiveCommandEvent event) {
        if (!(event.getActor() instanceof User)) {
            this.trackException(event, "AWAY message from something other than a user");
            return;
        }
        String awayMessage = event.getParameters().isEmpty() ? null : StringUtil.combineSplit(event.getParameters().toArray(new String[0]), 0);
        this.fire(new UserAwayMessageEvent(this.getClient(), event.getSource(), (User)event.getActor(), awayMessage));
        this.getTracker().setUserAway(((User)event.getActor()).getNick(), awayMessage);
    }
}

