/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.CapabilityRequestCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.DefaultCapabilityState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.CapabilityState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesAcknowledgedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesDeletedSupportedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesListEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesNewSupportedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesRejectedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesSupportedListEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.helper.CapabilityNegotiationRequestEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.helper.CapabilityNegotiationResponseEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.CapabilityManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultCapListener
extends AbstractDefaultListenerBase {
    private static final int CAPABILITY_LIST_INDEX_DEFAULT = 2;
    private final List<CapabilityState> capList = new ArrayList<CapabilityState>();
    private final List<ServerMessage> capListMessages = new ArrayList<ServerMessage>();
    private final List<CapabilityState> capLs = new ArrayList<CapabilityState>();
    private final List<ServerMessage> capLsMessages = new ArrayList<ServerMessage>();

    public DefaultCapListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @CommandFilter(value="CAP")
    @Handler(priority=0x7FFFFFFE)
    public void cap(ClientReceiveCommandEvent event) {
        int capabilityListIndex;
        if (event.getParameters().size() < 3) {
            this.trackException(event, "CAP message too short");
            return;
        }
        CapabilityNegotiationResponseEvent responseEvent = null;
        if ("*".equals(event.getParameters().get(2))) {
            if (event.getParameters().size() < 4) {
                this.trackException(event, "CAP message too short");
                return;
            }
            capabilityListIndex = 3;
        } else {
            capabilityListIndex = 2;
        }
        List<CapabilityState> capabilityStateList = Arrays.stream(event.getParameters().get(capabilityListIndex).split(" ")).filter(string -> !string.isEmpty()).map(capability -> new DefaultCapabilityState(this.getClient(), (String)capability)).collect(Collectors.toCollection(ArrayList::new));
        switch (event.getParameters().get(1).toLowerCase()) {
            case "ack": {
                this.getClient().getCapabilityManager().updateCapabilities(capabilityStateList);
                responseEvent = new CapabilitiesAcknowledgedEvent(this.getClient(), event.getSource(), this.getClient().getCapabilityManager().isNegotiating(), capabilityStateList);
                this.fire(responseEvent);
                break;
            }
            case "list": {
                List<CapabilityState> states;
                this.capListMessages.add(event.getServerMessage());
                if (capabilityListIndex != 2) {
                    this.capList.addAll((Collection<CapabilityState>)capabilityStateList);
                    break;
                }
                if (this.capList.isEmpty()) {
                    states = capabilityStateList;
                } else {
                    states = this.capList;
                    states.addAll(capabilityStateList);
                }
                this.getClient().getCapabilityManager().setCapabilities(states);
                this.fire(new CapabilitiesListEvent(this.getClient(), this.capListMessages, states));
                states.clear();
                break;
            }
            case "ls": {
                List<CapabilityState> states;
                this.capLsMessages.add(event.getServerMessage());
                if (capabilityListIndex != 2) {
                    this.capLs.addAll((Collection<CapabilityState>)capabilityStateList);
                    break;
                }
                if (this.capLs.isEmpty()) {
                    states = capabilityStateList;
                } else {
                    states = this.capLs;
                    states.addAll(capabilityStateList);
                }
                this.getClient().getCapabilityManager().setSupportedCapabilities(states);
                responseEvent = new CapabilitiesSupportedListEvent(this.getClient(), this.capLsMessages, this.getClient().getCapabilityManager().isNegotiating(), states);
                this.fireAndCapReq((CapabilitiesSupportedListEvent)responseEvent);
                this.capLs.clear();
                break;
            }
            case "nak": {
                this.getClient().getCapabilityManager().updateCapabilities(capabilityStateList);
                responseEvent = new CapabilitiesRejectedEvent(this.getClient(), event.getSource(), this.getClient().getCapabilityManager().isNegotiating(), capabilityStateList);
                this.fire(responseEvent);
                break;
            }
            case "new": {
                ArrayList<CapabilityState> statesAdded = new ArrayList<CapabilityState>(this.getClient().getCapabilityManager().getSupportedCapabilities());
                statesAdded.addAll((Collection<CapabilityState>)capabilityStateList);
                this.getClient().getCapabilityManager().setSupportedCapabilities(statesAdded);
                responseEvent = new CapabilitiesNewSupportedEvent(this.getClient(), event.getSource(), this.getClient().getCapabilityManager().isNegotiating(), capabilityStateList);
                this.fireAndCapReq((CapabilitiesNewSupportedEvent)responseEvent);
                break;
            }
            case "del": {
                ArrayList<CapabilityState> statesRemaining = new ArrayList<CapabilityState>(this.getClient().getCapabilityManager().getSupportedCapabilities());
                statesRemaining.removeAll(capabilityStateList);
                this.getClient().getCapabilityManager().setSupportedCapabilities(statesRemaining);
                responseEvent = new CapabilitiesDeletedSupportedEvent(this.getClient(), event.getSource(), this.getClient().getCapabilityManager().isNegotiating(), capabilityStateList);
                this.fire(responseEvent);
            }
        }
        if (responseEvent != null && responseEvent.isNegotiating() && responseEvent.isEndingNegotiation()) {
            this.getClient().sendRawLineImmediately("CAP END");
            this.getClient().getCapabilityManager().endNegotiation();
        }
    }

    private void fireAndCapReq(@NonNull CapabilityNegotiationRequestEvent responseEvent) {
        Set capabilities = this.getClient().getCapabilityManager().getSupportedCapabilities().stream().map(CapabilityState::getName).collect(Collectors.toCollection(HashSet::new));
        capabilities.retainAll(CapabilityManager.Defaults.getDefaults());
        List currentCapabilities = this.getClient().getCapabilityManager().getCapabilities().stream().map(CapabilityState::getName).collect(Collectors.toList());
        capabilities.removeAll(currentCapabilities);
        if (!capabilities.isEmpty()) {
            responseEvent.setEndingNegotiation(false);
            capabilities.forEach(responseEvent::addRequest);
        }
        this.fire(responseEvent);
        List<String> requests = responseEvent.getRequests();
        if (!requests.isEmpty()) {
            CapabilityRequestCommand capabilityRequestCommand = new CapabilityRequestCommand(this.getClient());
            requests.stream().distinct().filter(c -> !currentCapabilities.contains(c)).forEach(capabilityRequestCommand::enable);
            capabilityRequestCommand.execute();
        }
    }
}

