/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener;

import java.util.HashSet;
import java.util.Optional;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelJoinEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.RequestedChannelJoinCompleteEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultJoinListener
extends AbstractDefaultListenerBase {
    public DefaultJoinListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @CommandFilter(value="JOIN")
    @Handler(priority=0x7FFFFFFE)
    public void join(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 1) {
            this.trackException(event, "JOIN message too short");
            return;
        }
        String channelName = event.getParameters().get(0);
        if (!this.getClient().getServerInfo().isValidChannel(channelName)) {
            this.trackException(event, "JOIN message sent for invalid channel name");
            return;
        }
        if (!(event.getActor() instanceof User)) {
            this.trackException(event, "JOIN message sent for non-user");
            return;
        }
        this.getTracker().trackChannel(channelName);
        Channel channel = this.getTracker().getTrackedChannel(channelName).get();
        User user = (User)event.getActor();
        this.getTracker().trackChannelUser(channelName, user, new HashSet<ChannelUserMode>());
        if (event.getParameters().size() > 2) {
            if (!"*".equals(event.getParameters().get(1))) {
                this.getTracker().setUserAccount(user.getNick(), event.getParameters().get(1));
            }
            this.getTracker().setUserRealName(user.getNick(), event.getParameters().get(2));
            Optional<User> u = this.getTracker().getTrackedUser(user.getNick());
            if (u.isPresent()) {
                user = u.get();
            }
        }
        ChannelJoinEvent joinEvent = null;
        if (user.getNick().equals(this.getClient().getNick())) {
            if (this.getClient().getActorTracker().shouldQueryChannelInformation()) {
                this.getClient().sendRawLine("MODE " + channelName);
                this.getClient().sendRawLine("WHO " + channelName + (this.getClient().getServerInfo().hasWhoXSupport() ? " %cuhsnfar" : ""));
            }
            if (this.getClient().getIntendedChannels().contains(channelName)) {
                joinEvent = new RequestedChannelJoinCompleteEvent((Client)this.getClient(), event.getSource(), channel, user);
            }
        }
        if (joinEvent == null) {
            joinEvent = new ChannelJoinEvent((Client)this.getClient(), event.getSource(), channel, user);
        }
        this.fire(joinEvent);
    }
}

