/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener;

import java.time.Instant;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultModeInfo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultModeStatusList;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Actor;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatus;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatusList;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.UserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelModeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.UserModeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.NumericFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.StringUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultModeListener
extends AbstractDefaultListenerBase {
    public DefaultModeListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @NumericFilter(value=324)
    @Handler(priority=0x7FFFFFFE)
    public void channelMode(ClientReceiveNumericEvent event) {
        DefaultModeStatusList<ChannelMode> statusList;
        if (event.getParameters().size() < 3) {
            this.trackException(event, "Channel mode info message too short");
            return;
        }
        Channel channel = this.getTracker().getChannel(event.getParameters().get(1)).orElse(null);
        if (channel == null) {
            this.trackException(event, "Channel mode info message sent for invalid channel name");
            return;
        }
        try {
            statusList = DefaultModeStatusList.fromChannel(this.getClient(), StringUtil.combineSplit(event.getParameters().toArray(new String[0]), 2));
        }
        catch (IllegalArgumentException e) {
            this.trackException(event, e.getMessage());
            return;
        }
        this.getTracker().updateChannelModes(channel.getName(), statusList);
    }

    @CommandFilter(value="MODE")
    @Handler(priority=0x7FFFFFFE)
    public void mode(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "MODE message too short");
            return;
        }
        AbstractDefaultListenerBase.MessageTargetInfo messageTargetInfo = this.getTypeByTarget(event.getParameters().get(0));
        if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.Private) {
            DefaultModeStatusList<UserMode> statusList;
            try {
                statusList = DefaultModeStatusList.fromUser(this.getClient(), StringUtil.combineSplit(event.getParameters().toArray(new String[0]), 1));
            }
            catch (IllegalArgumentException e) {
                this.trackException(event, e.getMessage());
                return;
            }
            this.fire(new UserModeEvent(this.getClient(), event.getSource(), (Actor)event.getActor(), event.getParameters().get(0), (ModeStatusList<UserMode>)statusList));
            this.getClient().updateUserModes(statusList);
        } else if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo) {
            DefaultModeStatusList<ChannelMode> statusList;
            Channel channel = ((AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo)messageTargetInfo).getChannel();
            try {
                statusList = DefaultModeStatusList.fromChannel(this.getClient(), StringUtil.combineSplit(event.getParameters().toArray(new String[0]), 1));
            }
            catch (IllegalArgumentException e) {
                this.trackException(event, e.getMessage());
                return;
            }
            this.fire(new ChannelModeEvent(this.getClient(), event.getSource(), (Actor)event.getActor(), channel, (ModeStatusList<ChannelMode>)statusList));
            statusList.getAll().stream().filter(status -> ((ChannelMode)status.getMode()).getType() == ChannelMode.Type.A_MASK).forEach(status -> this.getTracker().trackChannelModeInfo(channel.getName(), status.getAction() == ModeStatus.Action.ADD, new DefaultModeInfo(this.getClient(), channel, (ChannelMode)status.getMode(), status.getParameter().get(), event.getActor().getName(), Instant.now())));
            this.getTracker().updateChannelModes(channel.getName(), statusList);
        } else {
            this.trackException(event, "MODE message sent for invalid target");
        }
    }
}

