/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener;

import java.util.Optional;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.UserNickChangeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultNickListener
extends AbstractDefaultListenerBase {
    public DefaultNickListener( @NonNull Client.WithManagement client) {
        super(client);
    }

    @CommandFilter(value="NICK")
    @Handler(priority=0x7FFFFFFE)
    public void nick(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 1) {
            this.trackException(event, "NICK message too short");
            return;
        }
        if (!(event.getActor() instanceof User)) {
            this.trackException(event, "NICK message sent for non-user");
            return;
        }
        boolean isSelf = ((User)event.getActor()).getNick().equals(this.getClient().getNick());
        String newNick = event.getParameters().get(0);
        Optional<User> user = this.getTracker().getTrackedUser(((User)event.getActor()).getNick());
        if (!user.isPresent()) {
            if (isSelf) {
                this.getClient().setCurrentNick(newNick);
                return;
            }
            this.trackException(event, "NICK message sent for user not in tracked channels");
            return;
        }
        User oldUser = user.get();
        this.getTracker().trackUserNickChange(user.get().getNick(), newNick);
        User newUser = this.getTracker().getTrackedUser(newNick).get();
        this.fire(new UserNickChangeEvent(this.getClient(), event.getSource(), oldUser, newUser));
        if (isSelf) {
            this.getClient().setCurrentNick(newNick);
        }
    }
}

