/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener;

import java.util.Date;
import java.util.Optional;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelCtcpEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelTargetedCtcpEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelTargetedMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateCtcpQueryEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.CtcpUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultPrivmsgListener
extends AbstractDefaultListenerBase {
    public DefaultPrivmsgListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @CommandFilter(value="PRIVMSG")
    @Handler(priority=0x7FFFFFFE)
    public void privmsg(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "PRIVMSG message too short");
            return;
        }
        if (!(event.getActor() instanceof User)) {
            this.trackException(event, "Message from something other than a user");
            return;
        }
        if (CtcpUtil.isCtcp(event.getParameters().get(1))) {
            String ctcpMessage = CtcpUtil.fromCtcp(event.getParameters().get(1));
            AbstractDefaultListenerBase.MessageTargetInfo messageTargetInfo = this.getTypeByTarget(event.getParameters().get(0));
            User user = (User)event.getActor();
            if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.Private) {
                String reply = null;
                switch (ctcpMessage) {
                    case "VERSION": {
                        reply = "VERSION I am Kitteh!";
                        break;
                    }
                    case "TIME": {
                        reply = "TIME " + new Date().toString();
                        break;
                    }
                    case "FINGER": {
                        reply = "FINGER om nom nom tasty finger";
                    }
                }
                if (ctcpMessage.startsWith("PING ")) {
                    reply = ctcpMessage;
                }
                PrivateCtcpQueryEvent ctcpEvent = new PrivateCtcpQueryEvent(this.getClient(), event.getSource(), user, event.getParameters().get(0), ctcpMessage, reply);
                this.fire(ctcpEvent);
                Optional<String> replyMessage = ctcpEvent.getReply();
                if (ctcpEvent.isToClient()) {
                    replyMessage.ifPresent(message -> this.getClient().sendRawLine("NOTICE " + user.getNick() + " :" + CtcpUtil.toCtcp(message)));
                }
            } else if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo) {
                AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo channelInfo = (AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo)messageTargetInfo;
                this.fire(new ChannelCtcpEvent((Client)this.getClient(), event.getSource(), user, channelInfo.getChannel(), ctcpMessage));
            } else if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.TargetedChannel) {
                AbstractDefaultListenerBase.MessageTargetInfo.TargetedChannel channelInfo = (AbstractDefaultListenerBase.MessageTargetInfo.TargetedChannel)messageTargetInfo;
                this.fire(new ChannelTargetedCtcpEvent(this.getClient(), event.getSource(), user, channelInfo.getChannel(), channelInfo.getPrefix(), ctcpMessage));
            }
            return;
        }
        User user = (User)event.getActor();
        AbstractDefaultListenerBase.MessageTargetInfo messageTargetInfo = this.getTypeByTarget(event.getParameters().get(0));
        if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.Private) {
            this.fire(new PrivateMessageEvent((Client)this.getClient(), event.getSource(), user, event.getParameters().get(0), event.getParameters().get(1)));
        } else if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo) {
            AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo channelInfo = (AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo)messageTargetInfo;
            this.fire(new ChannelMessageEvent((Client)this.getClient(), event.getSource(), user, channelInfo.getChannel(), event.getParameters().get(1)));
        } else if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.TargetedChannel) {
            AbstractDefaultListenerBase.MessageTargetInfo.TargetedChannel channelInfo = (AbstractDefaultListenerBase.MessageTargetInfo.TargetedChannel)messageTargetInfo;
            this.fire(new ChannelTargetedMessageEvent(this.getClient(), event.getSource(), user, channelInfo.getChannel(), channelInfo.getPrefix(), event.getParameters().get(1)));
        }
    }
}

