/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener;

import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultModeStatusList;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.UserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.NumericFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.StringUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultUserModeListener
extends AbstractDefaultListenerBase {
    public DefaultUserModeListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @NumericFilter(value=221)
    @Handler(priority=0x7FFFFFFE)
    public void umode(ClientReceiveNumericEvent event) {
        DefaultModeStatusList<UserMode> modes;
        if (event.getParameters().size() < 2) {
            this.trackException(event, "UMODE response too short");
            return;
        }
        if (!this.getClient().getServerInfo().getCaseMapping().areEqualIgnoringCase(event.getParameters().get(0), this.getClient().getNick())) {
            this.trackException(event, "UMODE response for another user");
            return;
        }
        try {
            modes = DefaultModeStatusList.fromUser(this.getClient(), StringUtil.combineSplit(event.getParameters().toArray(new String[0]), 1));
        }
        catch (IllegalArgumentException e) {
            this.trackException(event, e.getMessage());
            return;
        }
        this.getClient().setUserModes(modes);
    }
}

