/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener;

import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.DefaultWhoisData;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.WhoisData;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.WhoisEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.NumericFilter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultWhoisListener
extends AbstractDefaultListenerBase {
    private @Nullable DefaultWhoisData.Builder whoisBuilder;

    public DefaultWhoisListener( @NonNull Client.WithManagement client) {
        super(client);
    }

    private DefaultWhoisData.Builder getWhoisBuilder(@NonNull ClientReceiveNumericEvent event) {
        String nick = event.getParameters().get(1);
        if (this.whoisBuilder == null || !this.getClient().getServerInfo().getCaseMapping().areEqualIgnoringCase(this.whoisBuilder.getNick(), nick)) {
            this.whoisBuilder = new DefaultWhoisData.Builder(this.getClient(), nick);
        }
        return this.whoisBuilder;
    }

    @NumericFilter(value=301)
    @Handler(priority=0x7FFFFFFE)
    public void whoisAway(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "WHOIS AWAY response too short");
            return;
        }
        this.getWhoisBuilder(event).setAway(event.getParameters().get(event.getParameters().size() == 3 ? 2 : 3));
    }

    @NumericFilter(value=311)
    @Handler(priority=0x7FFFFFFE)
    public void whoisUser(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "WHOIS USER response too short");
            return;
        }
        DefaultWhoisData.Builder whoisBuilder = this.getWhoisBuilder(event);
        switch (event.getParameters().size()) {
            case 6: {
                whoisBuilder.setRealName(event.getParameters().get(5));
            }
            case 4: {
                whoisBuilder.setHost(event.getParameters().get(3));
            }
            case 3: {
                whoisBuilder.setUserString(event.getParameters().get(2));
            }
        }
    }

    @NumericFilter(value=312)
    @Handler(priority=0x7FFFFFFE)
    public void whoisServer(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "WHOIS SERVER response too short");
            return;
        }
        DefaultWhoisData.Builder whoisBuilder = this.getWhoisBuilder(event);
        whoisBuilder.setServer(event.getParameters().get(2));
        if (event.getParameters().size() > 3) {
            whoisBuilder.setServerDescription(event.getParameters().get(3));
        }
    }

    @NumericFilter(value=313)
    @Handler(priority=0x7FFFFFFE)
    public void whoisOperator(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "WHOIS OPERATOR response too short");
            return;
        }
        this.getWhoisBuilder(event).setOperatorInformation(event.getParameters().get(2));
    }

    @NumericFilter(value=317)
    @Handler(priority=0x7FFFFFFE)
    public void whoisIdle(ClientReceiveNumericEvent event) {
        long idleTime;
        if (event.getParameters().size() < 4) {
            this.trackException(event, "WHOIS IDLE response too short");
            return;
        }
        DefaultWhoisData.Builder whoisBuilder = this.getWhoisBuilder(event);
        try {
            idleTime = Long.parseLong(event.getParameters().get(2));
        }
        catch (NumberFormatException e) {
            this.trackException(event, "WHOIS IDLE idle time not a number");
            return;
        }
        whoisBuilder.setIdleTime(idleTime);
        if (event.getParameters().size() > 4) {
            long signOnTime;
            try {
                signOnTime = Long.parseLong(event.getParameters().get(3));
            }
            catch (NumberFormatException e) {
                this.trackException(event, "WHOIS IDLE sign on time not a number");
                return;
            }
            whoisBuilder.setSignOnTime(signOnTime);
        }
    }

    @NumericFilter(value=330)
    @Handler(priority=0x7FFFFFFE)
    public void whoisAccount(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "WHOIS ACCOUNT response too short");
            return;
        }
        this.getWhoisBuilder(event).setAccount(event.getParameters().get(2));
    }

    @NumericFilter(value=319)
    @Handler(priority=0x7FFFFFFE)
    public void whoisChannels(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "WHOIS CHANNELS response too short");
            return;
        }
        this.getWhoisBuilder(event).addChannels(event.getParameters().get(2));
    }

    @NumericFilter(value=671)
    @Handler(priority=0x7FFFFFFE)
    public void whoisSecure(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "WHOIS SECURE response too short");
            return;
        }
        this.getWhoisBuilder(event).setSecure();
    }

    @NumericFilter(value=318)
    @Handler(priority=0x7FFFFFFE)
    public void whoisEnd(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "WHOIS END response too short");
            return;
        }
        WhoisData whois = this.getWhoisBuilder(event).build();
        if (this.getClient().getServerInfo().getCaseMapping().areEqualIgnoringCase(whois.getNick(), this.getClient().getNick()) && !this.getTracker().getTrackedUser(whois.getNick()).isPresent()) {
            this.getTracker().trackUser(whois);
        }
        this.fire(new WhoisEvent(this.getClient(), whois));
        this.whoisBuilder = null;
    }
}

