/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities;

import java.util.Collections;
import java.util.List;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.CapabilityState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase.CapabilityNegotiationResponseEventBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CapabilitiesAcknowledgedEvent
extends CapabilityNegotiationResponseEventBase {
    private final List<CapabilityState> acknowledgedCapabilities;

    public CapabilitiesAcknowledgedEvent(@NonNull Client client, @NonNull ServerMessage sourceMessage, boolean negotiating, @NonNull List<CapabilityState> acknowledgedCapabilities) {
        super(client, sourceMessage, negotiating);
        Sanity.nullCheck(acknowledgedCapabilities, "Capabilities list cannot be null");
        this.acknowledgedCapabilities = Collections.unmodifiableList(acknowledgedCapabilities);
    }

    public @NonNull List<CapabilityState> getAcknowledgedCapabilities() {
        return this.acknowledgedCapabilities;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("acknowledgedCapabilities", this.acknowledgedCapabilities);
    }
}

