/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.exception;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import org.checkerframework.checker.nullness.qual.NonNull;

public class KittehServerMessageException
extends RuntimeException {
    private final List<ServerMessage> messages;

    public KittehServerMessageException(ServerMessage message, String problem) {
        this(Collections.singletonList(message), problem);
    }

    public KittehServerMessageException(List<ServerMessage> messages, String problem) {
        super("Trouble processing message: " + problem + ". Messages: " + System.lineSeparator() + messages.stream().map(ServerMessage::getMessage).collect(Collectors.joining(System.lineSeparator())));
        this.messages = Collections.unmodifiableList(new ArrayList<ServerMessage>(messages));
    }

    public @NonNull List<ServerMessage> getServerMessages() {
        return this.messages;
    }
}

