/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.auth;

import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.auth.AbstractAuthProtocol;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.StringUtil;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractAccountPassProtocol
extends AbstractAuthProtocol {
    private final String accountName;
    private final String password;

    protected AbstractAccountPassProtocol(@NonNull Client client, @Nullable String accountName, @NonNull String password) {
        super(client);
        this.accountName = accountName;
        this.password = Sanity.safeMessageCheck(password, "Password");
    }

    protected @Nullable String getAccountName() {
        return this.accountName;
    }

    protected @NonNull String getPassword() {
        return this.password;
    }

    @Override
    protected void toString(ToStringer stringer) {
        stringer.add("account", this.getAccountName());
        stringer.add("password", StringUtil.filterPassword(this.password));
    }
}

