/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.auth;

import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateNoticeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.auth.AbstractAccountPassProtocol;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.auth.element.EventListening;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.NumericFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Format;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NickServ
extends AbstractAccountPassProtocol
implements EventListening {
    private final String serviceName;

    public static @NonNull Builder builder(@NonNull Client client) {
        return new Builder(client);
    }

    protected NickServ(@NonNull Client client, @NonNull String serviceName, @Nullable String accountName, @NonNull String password) {
        super(client, accountName, password);
        this.serviceName = Sanity.safeMessageCheck(serviceName, "Service name");
    }

    @Override
    protected @NonNull String getAuthentication() {
        String accountName = this.getAccountName();
        return "PRIVMSG " + this.serviceName + " :IDENTIFY " + (accountName == null ? "" : accountName + ' ') + this.getPassword();
    }

    @Override
    public @NonNull Object getEventListener() {
        return this;
    }

    @NumericFilter(value=4)
    @Handler
    public void listenVersion(ClientReceiveNumericEvent event) {
        this.startAuthentication();
    }

    @Handler
    public void listenSuccess(PrivateNoticeEvent event) {
        if (((User)event.getActor()).getNick().equals(this.serviceName) && event.getMessage().startsWith("You are now identified")) {
            int first = event.getMessage().indexOf(Format.BOLD.toString()) + 1;
            String string = event.getMessage().substring(first, event.getMessage().indexOf(Format.BOLD.toString(), first));
        }
    }

    public static class Builder {
        private final Client client;
        private String serviceName = "NickServ";
        private @Nullable String account;
        private @Nullable String password;

        protected Builder(@NonNull Client client) {
            this.client = Sanity.nullCheck(client, "Client");
        }

        public @NonNull Builder serviceName(@Nullable String serviceName) {
            this.serviceName = Sanity.safeMessageCheck(serviceName, "Service name");
            return this;
        }

        public @NonNull Builder account(@Nullable String account) {
            this.account = Sanity.safeMessageCheck(account, "Account");
            return this;
        }

        public @NonNull Builder password(@Nullable String password) {
            this.password = Sanity.safeMessageCheck(password, "Password");
            return this;
        }

        public @NonNull NickServ build() {
            Sanity.truthiness(this.password != null, "Password must be set");
            return new NickServ(this.client, this.serviceName, this.account, this.password);
        }
    }
}

