/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sending;

import java.util.function.Function;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sending.QueueProcessingThreadSender;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SingleDelaySender
extends QueueProcessingThreadSender {
    public static final int DEFAULT_MESSAGE_DELAY = 1200;
    private int delay;
    private long last = System.currentTimeMillis();

    public static Function<Client.WithManagement, SingleDelaySender> getSupplier(int delay) {
        return client -> new SingleDelaySender((Client)client, "SingleDelay " + delay, delay);
    }

    public SingleDelaySender(@NonNull Client client, @NonNull String name, int delay) {
        super(client, name);
        this.delay = delay;
    }

    @Override
    protected boolean checkReady(@NonNull String message) {
        long now;
        long remaining;
        int currentDelay = this.delay;
        if (currentDelay == 0) {
            return true;
        }
        do {
            if ((remaining = (long)currentDelay - ((now = System.currentTimeMillis()) - this.last)) <= 0L) continue;
            try {
                Thread.sleep(remaining);
            }
            catch (InterruptedException e) {
                this.interrupt();
                return false;
            }
        } while (remaining > 0L);
        this.last = now;
        return true;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }
}

