/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch;

import java.util.function.Function;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sending.QueueProcessingThreadSender;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TwitchDelaySender
extends QueueProcessingThreadSender {
    public static final int MOD_OP_PER_THIRTY_SECONDS = 100;
    public static final int NON_MOD_OP_PER_THIRTY_SECONDS = 20;
    private int currentIndex = 0;
    private final long[] timestamps;

    public static Function<Client.WithManagement, TwitchDelaySender> getSupplier() {
        return TwitchDelaySender.getSupplier(false);
    }

    public static Function<Client.WithManagement, TwitchDelaySender> getSupplier(boolean modOrOpOnly) {
        return client -> new TwitchDelaySender((Client)client, "TwitchDelay " + (modOrOpOnly ? "Only Mod/Op" : "Standard"), modOrOpOnly ? 100 : 20);
    }

    public TwitchDelaySender(@NonNull Client client, @NonNull String name, int perThirtySeconds) {
        super(client, name);
        this.timestamps = new long[perThirtySeconds];
    }

    @Override
    protected boolean checkReady(@NonNull String message) {
        long now;
        long remaining;
        do {
            if ((remaining = 30000L - ((now = System.currentTimeMillis()) - this.timestamps[this.currentIndex])) <= 0L) continue;
            try {
                Thread.sleep(remaining);
            }
            catch (InterruptedException e) {
                this.interrupt();
                return false;
            }
        } while (remaining > 0L);
        this.timestamps[this.currentIndex++] = now;
        if (this.currentIndex >= this.timestamps.length) {
            this.currentIndex = 0;
        }
        return true;
    }
}

