/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.MessageTagManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.TriFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Badges
extends MessageTagManager.DefaultMessageTag {
    public static final String NAME = "badges";
    public static final TriFunction<Client, String, String, Badges> FUNCTION = (client, name, value) -> new Badges((String)name, (String)value);
    private final List<Badge> badges;

    private Badges(@NonNull String name, @Nullable String value) {
        super(name, value);
        if (value == null) {
            this.badges = Collections.emptyList();
        } else {
            String[] badgesSplit;
            ArrayList<Badge> badges = new ArrayList<Badge>();
            for (String badgeInfo : badgesSplit = value.split(",")) {
                String[] split = badgeInfo.split("/");
                String version = split.length > 1 ? split[1] : "";
                badges.add(new Badge(split[0], version));
            }
            this.badges = Collections.unmodifiableList(badges);
        }
    }

    public @NonNull List<Badge> getBadges() {
        return this.badges;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add(NAME, this.badges);
    }

    public class Badge {
        private final String name;
        private final String version;

        private Badge(@NonNull String name, String version) {
            this.name = name;
            this.version = version;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @NonNull String getVersion() {
            return this.version;
        }

        public @NonNull String toString() {
            return new ToStringer(this).add("name", this.name).add("version", this.version).toString();
        }
    }

    public static final class KnownNames {
        public static final String ADMIN = "admin";
        public static final String BITS = "bits";
        public static final String BROADCASTER = "broadcaster";
        public static final String GLOBAL_MOD = "global_mod";
        public static final String MODERATOR = "moderator";
        public static final String SUBSCRIBER = "subscriber";
        public static final String STAFF = "staff";
        public static final String TURBO = "turbo";

        private KnownNames() {
        }
    }
}

