/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.CaseMapping;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Pair;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CIKeyMap<Value>
implements Map<String, Value> {
    private final Client client;
    private CaseMapping lastCaseMapping;
    private final Map<String, Pair<String, Value>> map = new ConcurrentHashMap<String, Pair<String, Value>>();

    public CIKeyMap(@NonNull Client client) {
        this.client = Sanity.nullCheck(client, "Client");
    }

    protected final synchronized @NonNull String toLowerCase(@NonNull String input) {
        CaseMapping caseMapping = this.client.getServerInfo().getCaseMapping();
        if (caseMapping != this.lastCaseMapping) {
            Set<Map.Entry<String, Value>> entrySet = this.entrySet();
            this.lastCaseMapping = caseMapping;
            this.map.clear();
            entrySet.forEach((? super T entry) -> this.put((String)entry.getKey(), entry.getValue()));
        }
        return caseMapping.toLowerCase(input);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return key instanceof String && this.map.containsKey(this.toLowerCase((String)key));
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        for (Pair<String, Value> pair : this.map.values()) {
            if (!(value == null ? pair.getRight() == null : value.equals(pair.getRight()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable Value get(@Nullable Object key) {
        if (key instanceof String) {
            Pair<String, Value> pair = this.map.get(this.toLowerCase((String)key));
            return pair == null ? null : (Value)pair.getRight();
        }
        return null;
    }

    @Override
    public @Nullable Value put(@NonNull String key, @Nullable Value value) {
        Sanity.nullCheck(key, "Key");
        Pair<String, Value> pair = this.map.put(this.toLowerCase(key), new Pair<String, Value>(key, value));
        return pair == null ? null : (Value)pair.getRight();
    }

    @Override
    public @Nullable Value remove(@Nullable Object key) {
        if (key instanceof String) {
            Pair<String, Value> pair = this.map.remove(this.toLowerCase((String)key));
            return pair == null ? null : (Value)pair.getRight();
        }
        return null;
    }

    @Override
    public void putAll(@NonNull Map<? extends String, ? extends Value> m) {
        Sanity.nullCheck(m, "Map");
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public @NonNull Set<String> keySet() {
        return this.map.values().stream().map(Pair::getLeft).collect(Collectors.toSet());
    }

    @Override
    public @NonNull Collection<Value> values() {
        return this.map.values().stream().map(Pair::getRight).collect(Collectors.toList());
    }

    @Override
    public @NonNull Set<Map.Entry<String, Value>> entrySet() {
        return this.map.values().stream().map(pair -> new AbstractMap.SimpleImmutableEntry(pair.getLeft(), pair.getRight())).collect(Collectors.toSet());
    }

    public @NonNull String toString() {
        return new ToStringer(this).add("client", this.client).add("map", this.map.values().stream().collect(Collectors.toMap(Pair::getLeft, Pair::getRight))).toString();
    }
}

