/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class QueueProcessingThread<Type>
extends Thread {
    private final Queue<Type> queue = new ConcurrentLinkedQueue<Type>();

    protected QueueProcessingThread(@NonNull String name) {
        this.setName(name);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block5: while (!this.isInterrupted()) {
            Queue<Type> queue = this.queue;
            synchronized (queue) {
                while (this.queue.isEmpty()) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException e) {
                        break block5;
                    }
                }
            }
            this.processElement(this.queue.poll());
        }
        this.interrupt();
        this.cleanup(this.queue);
    }

    protected void cleanup(@NonNull Queue<Type> remainingQueue) {
    }

    protected abstract void processElement(@NonNull Type var1);

    public boolean contains(@NonNull Type item) {
        return this.queue.contains(Sanity.nullCheck(item, "Item"));
    }

    public @NonNull Queue<Type> getQueue() {
        return new ArrayDeque<Type>(this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(@NonNull Type item) {
        Sanity.nullCheck(item, "Item");
        Queue<Type> queue = this.queue;
        synchronized (queue) {
            this.queue.add(item);
            this.queue.notify();
        }
    }
}

