/*
 * Decompiled with CFR 0.152.
 */
package josephcsible.oreberries.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import net.minecraft.init.Items;

public class OreberriesJson {
    public static boolean needsWrite = false;

    public static JsonObject getDefaults() {
        Gson gson = new Gson();
        JsonObject root = new JsonObject();
        JsonObject iron = new JsonObject();
        iron.addProperty("color", "#FFC7A3");
        iron.addProperty("tooltip", "Sweet Irony");
        iron.addProperty("smeltingResult", Items.field_191525_da.getRegistryName().toString());
        root.add("Iron", (JsonElement)iron);
        JsonObject gold = new JsonObject();
        gold.addProperty("color", "#FFCC33");
        gold.addProperty("tooltip", "Pure Luster");
        gold.addProperty("smeltingResult", Items.field_151074_bl.getRegistryName().toString());
        gold.addProperty("rarity", (Number)9);
        gold.addProperty("maxHeight", (Number)32);
        gold.addProperty("sizeChance", (Number)6);
        root.add("Gold", (JsonElement)gold);
        JsonObject copper = new JsonObject();
        copper.addProperty("color", "#FF8833");
        copper.addProperty("tooltip", "Tastes like metal");
        JsonObject copperNugget = new JsonObject();
        copperNugget.addProperty("color", "#FF6600");
        copper.add("smeltingResult", (JsonElement)copperNugget);
        copper.addProperty("rarity", (Number)4);
        copper.addProperty("density", (Number)2);
        copper.addProperty("minHeight", (Number)20);
        copper.addProperty("maxHeight", (Number)60);
        root.add("Copper", (JsonElement)copper);
        JsonObject tin = new JsonObject();
        tin.addProperty("color", "#BB4422");
        tin.addProperty("tooltip", "Tin Man");
        JsonObject tinNugget = new JsonObject();
        tinNugget.addProperty("color", "#FFBA80");
        tin.add("smeltingResult", (JsonElement)tinNugget);
        tin.addProperty("rarity", (Number)4);
        tin.addProperty("density", (Number)2);
        tin.addProperty("maxHeight", (Number)40);
        root.add("Tin", (JsonElement)tin);
        JsonObject aluminum = new JsonObject();
        aluminum.addProperty("color", "#EEFFFF");
        aluminum.addProperty("tooltip", "White Chocolate");
        aluminum.add("oredictNames", gson.toJsonTree((Object)new String[]{"nuggetAluminum", "nuggetAluminium"}));
        JsonObject aluminumNugget = new JsonObject();
        aluminumNugget.add("ingotNames", gson.toJsonTree((Object)new String[]{"ingotAluminum", "ingotAluminium"}));
        aluminum.add("smeltingResult", (JsonElement)aluminumNugget);
        aluminum.addProperty("rarity", (Number)3);
        aluminum.addProperty("density", (Number)2);
        aluminum.addProperty("maxHeight", (Number)60);
        aluminum.addProperty("sizeChance", (Number)14);
        root.add("Aluminum", (JsonElement)aluminum);
        JsonObject essence = new JsonObject();
        essence.addProperty("bushName", "Essence Berry Bush");
        essence.addProperty("berryName", "Concentrated Essence Berry");
        essence.addProperty("tooltip", "Tastes like Creeper");
        essence.add("oredictNames", (JsonElement)new JsonArray());
        essence.add("smeltingResult", (JsonElement)JsonNull.INSTANCE);
        essence.addProperty("special", "essence");
        essence.addProperty("growsInLight", Boolean.valueOf(true));
        essence.addProperty("tradeable", Boolean.valueOf(false));
        essence.addProperty("preferredHeight", (Number)48);
        essence.addProperty("maxHeight", (Number)32);
        essence.addProperty("sizeChance", (Number)8);
        root.add("Essence", (JsonElement)essence);
        return root;
    }

    public static JsonObject read(File file) {
        JsonObject rootElem;
        JsonParser parser = new JsonParser();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            rootElem = (JsonObject)parser.parse((Reader)reader);
        }
        catch (FileNotFoundException e) {
            rootElem = OreberriesJson.getDefaults();
            needsWrite = true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return rootElem;
    }

    public static void write(File file, JsonElement json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            gson.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        needsWrite = false;
    }
}

