/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.contenttweaker.modules.chickens;

import com.google.common.collect.Lists;
import com.setycz.chickens.handler.SpawnType;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import com.teamacronymcoders.contenttweaker.api.ctobjects.color.CTColor;
import com.teamacronymcoders.contenttweaker.modules.chickens.ChickenRepresentation;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ModOnly(value="chickens")
@ZenClass(value="mods.contenttweaker.ChickenFactory")
public class ChickenFactory {
    public static final List<ChickenRepresentation> CHICKEN_REPRESENTATIONS = Lists.newArrayList();

    @ZenMethod
    public static ChickenRepresentation createChicken(String name, CTColor color, IItemStack iItemStack) {
        return new ChickenRepresentation(name, color, iItemStack);
    }

    public static void registerChickens() {
        for (ChickenRepresentation chickenRepresentation : CHICKEN_REPRESENTATIONS) {
            ChickensRegistryItem parentOneItem = chickenRepresentation.parentOne != null ? ChickensRegistry.getByResourceLocation((ResourceLocation)chickenRepresentation.parentOne.getInternal()) : null;
            ChickensRegistryItem parentTwoItem = chickenRepresentation.parentTwo != null ? ChickensRegistry.getByResourceLocation((ResourceLocation)chickenRepresentation.parentTwo.getInternal()) : null;
            ChickensRegistryItem item = new ChickensRegistryItem(new ResourceLocation("contenttweaker", chickenRepresentation.name), chickenRepresentation.name, chickenRepresentation.textureLocation.getInternal(), CraftTweakerMC.getItemStack((IItemStack)chickenRepresentation.layItem), chickenRepresentation.backgroundColor.getIntColor(), chickenRepresentation.foregroundColor.getIntColor(), parentOneItem, parentTwoItem);
            if (chickenRepresentation.dropItem != null) {
                item.setDropItem(CraftTweakerMC.getItemStack((IItemStack)chickenRepresentation.dropItem));
            }
            if (chickenRepresentation.spawnType != null) {
                SpawnType actualSpawnType = null;
                for (SpawnType spawnTypeEnum : SpawnType.values()) {
                    if (!spawnTypeEnum.toString().toLowerCase().equals(chickenRepresentation.spawnType.toLowerCase())) continue;
                    actualSpawnType = spawnTypeEnum;
                }
                if (actualSpawnType != null) {
                    item.setSpawnType(actualSpawnType);
                } else {
                    CraftTweakerAPI.logError((String)("Failed to find SpawnType for String: " + chickenRepresentation.spawnType));
                }
            }
            item.setLayCoefficient(chickenRepresentation.layCoefficient);
            ChickensRegistry.register((ChickensRegistryItem)item);
        }
    }
}

