/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.contenttweaker.modules.vanilla.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamacronymcoders.base.blocks.BlockBase;
import com.teamacronymcoders.base.blocks.IHasBlockColor;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.items.IHasItemColor;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import com.teamacronymcoders.contenttweaker.api.ctobjects.blockpos.MCBlockPos;
import com.teamacronymcoders.contenttweaker.api.ctobjects.blockstate.MCBlockState;
import com.teamacronymcoders.contenttweaker.api.ctobjects.color.CTColor;
import com.teamacronymcoders.contenttweaker.api.ctobjects.itemlist.CTItemList;
import com.teamacronymcoders.contenttweaker.api.ctobjects.resourcelocation.CTResourceLocation;
import com.teamacronymcoders.contenttweaker.api.ctobjects.world.MCWorld;
import com.teamacronymcoders.contenttweaker.api.utils.CTUtils;
import com.teamacronymcoders.contenttweaker.modules.vanilla.blocks.BlockRepresentation;
import com.teamacronymcoders.contenttweaker.modules.vanilla.functions.IBlockAction;
import com.teamacronymcoders.contenttweaker.modules.vanilla.functions.IBlockColorSupplier;
import com.teamacronymcoders.contenttweaker.modules.vanilla.tileentity.TileEntityContent;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.world.MCBlockAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockContent
extends BlockBase
implements IHasBlockColor,
IHasItemColor {
    private BlockRepresentation blockRepresentation;
    private EnumBlockRenderType enumBlockRenderType;
    private CreativeTabs creativeTab;
    private BlockRenderLayer blockRenderLayer;
    private AxisAlignedBB blockShape;

    public BlockContent(BlockRepresentation blockRepresentation) {
        super(blockRepresentation.getBlockMaterial().getInternal(), blockRepresentation.getUnlocalizedName());
        this.blockRepresentation = blockRepresentation;
        this.setFields();
    }

    public void setFields() {
        Object creativeTab;
        this.func_149663_c(this.blockRepresentation.getUnlocalizedName());
        if (this.blockRepresentation.getCreativeTab() != null && (creativeTab = this.blockRepresentation.getCreativeTab().getInternal()) instanceof CreativeTabs) {
            this.func_149647_a((CreativeTabs)this.blockRepresentation.getCreativeTab().getInternal());
        }
        this.func_149713_g(this.blockRepresentation.getLightOpacity());
        this.func_149715_a(this.blockRepresentation.getLightValue());
        this.func_149711_c(this.blockRepresentation.getBlockHardness());
        this.func_149752_b(this.blockRepresentation.getBlockResistance());
        this.setHarvestLevel(this.blockRepresentation.getToolClass(), this.blockRepresentation.getToolLevel());
        this.func_149672_a((SoundType)this.blockRepresentation.getBlockSoundType().getInternal());
        this.enumBlockRenderType = CTUtils.getEnum(this.blockRepresentation.getEnumBlockRenderType(), EnumBlockRenderType.class);
        this.blockRenderLayer = CTUtils.getEnum(this.blockRepresentation.getBlockLayer(), BlockRenderLayer.class);
        this.blockShape = this.blockRepresentation.getAxisAlignedBB().getInternal();
        if (this.blockRepresentation.getOnRandomTick() != null) {
            this.func_149675_a(true);
        }
        this.field_149787_q = this.blockRepresentation.isFullBlock();
        this.field_149785_s = this.blockRepresentation.isTranslucent();
    }

    @ParametersAreNonnullByDefault
    public boolean isSideSolid(IBlockState baseState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.blockRepresentation.isFullBlock();
    }

    @Nonnull
    public CreativeTabs func_149708_J() {
        return this.creativeTab;
    }

    @Nonnull
    public Block func_149647_a(@Nonnull CreativeTabs creativeTab) {
        this.creativeTab = creativeTab;
        return this;
    }

    public float getEnchantPowerBonus(@Nonnull World world, @Nonnull BlockPos pos) {
        return this.blockRepresentation.getEnchantPowerBonus();
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return this.enumBlockRenderType;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return this.blockRenderLayer;
    }

    public void func_176213_c(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.activateBlockAction(this.blockRepresentation.getOnBlockPlace(), world, pos, state);
        if (this.blockRepresentation.hasGravity()) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        this.activateBlockAction(this.blockRepresentation.getOnBlockBreak(), world, pos, state);
        super.func_180663_b(world, pos, state);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (this.blockRepresentation.isWitherProof() && (entity instanceof EntityWither || entity instanceof EntityWitherSkull)) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity entity, Explosion explosion) {
        if (this.blockRepresentation.isWitherProof() && (entity instanceof EntityWither || entity instanceof EntityWitherSkull)) {
            return 2000.0f;
        }
        return super.getExplosionResistance(world, pos, entity, explosion);
    }

    public float getSlipperiness(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity entity) {
        return this.blockRepresentation.getSlipperiness();
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.blockShape;
    }

    @ParametersAreNonnullByDefault
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        this.activateBlockAction(this.blockRepresentation.getOnRandomTick(), world, pos, state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.activateBlockAction(this.blockRepresentation.getOnUpdateTick(), world, pos, state);
        if (this.blockRepresentation.hasGravity() && !world.field_72995_K && (world.func_175623_d(pos.func_177977_b()) || BlockFalling.func_185759_i((IBlockState)world.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0 && world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
            world.func_72838_d((Entity)new EntityFallingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos)));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.blockRepresentation.hasGravity()) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        } else {
            super.func_189540_a(state, world, pos, blockIn, fromPos);
        }
    }

    public int func_149738_a(World world) {
        return this.blockRepresentation.hasGravity() ? 2 : super.func_149738_a(world);
    }

    public void activateBlockAction(IBlockAction blockAction, World world, BlockPos blockPos, IBlockState blockState) {
        if (blockAction != null) {
            blockAction.onBlockAction(new MCWorld(world), new MCBlockPos(blockPos), new MCBlockState(blockState));
        }
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState state) {
        return this.blockRepresentation.getMobilityFlag().getInternal();
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return this.blockRepresentation.isPassable();
    }

    public boolean func_176200_f(IBlockAccess world, @Nonnull BlockPos pos) {
        return this.blockRepresentation.isReplaceable();
    }

    @ParametersAreNonnullByDefault
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (this.blockRepresentation.isPassable()) {
            BlockContent.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185506_k);
        } else {
            BlockContent.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185890_d((IBlockAccess)world, pos));
        }
    }

    public boolean func_189872_a(IBlockState state, Entity entity) {
        return this.blockRepresentation.canEntitySpawn();
    }

    public boolean func_149662_c(IBlockState state) {
        return this.field_149787_q;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.field_149787_q;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.field_149787_q;
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        if (this.blockRepresentation.getDropHandler() != null) {
            MCWorld blockAccess = world instanceof World ? new MCWorld((World)world) : new MCBlockAccess(world);
            this.blockRepresentation.getDropHandler().handleDrops(new CTItemList(drops), (crafttweaker.api.world.IBlockAccess)blockAccess, new MCBlockPos(pos), new MCBlockState(state), fortune);
        }
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return this.blockRepresentation.beaconBase;
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.blockRepresentation.tileEntityRepresentation != null;
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.blockRepresentation.tileEntityRepresentation != null ? new TileEntityContent(this.blockRepresentation.tileEntityRepresentation) : null;
    }

    public List<IGeneratedModel> getGeneratedModels() {
        ArrayList models = Lists.newArrayList();
        this.getResourceLocations(Lists.newArrayList()).forEach(resourceLocation -> {
            TemplateFile templateFile = TemplateManager.getTemplateFile((String)"colored_block");
            HashMap replacements = Maps.newHashMap();
            replacements.put("texture", Optional.ofNullable(this.blockRepresentation.getTextureLocation()).map(CTResourceLocation::getInternal).map(ResourceLocation::toString).orElseGet(() -> new ResourceLocation(resourceLocation.func_110624_b(), "blocks/" + resourceLocation.func_110623_a()).toString()));
            templateFile.replaceContents((Map)replacements);
            models.add(new GeneratedModel(resourceLocation.func_110623_a(), ModelType.BLOCKSTATE, templateFile.getFileContents()));
        });
        return models;
    }

    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
        IBlockColorSupplier blockColorSupplier = this.blockRepresentation.getBlockColorSupplier();
        if (blockColorSupplier == null) {
            return -1;
        }
        MCWorld blockAccess = null;
        if (world instanceof World) {
            blockAccess = new MCWorld((World)world);
        } else if (world != null) {
            blockAccess = new MCBlockAccess(world);
        }
        MCBlockPos blockPos = pos == null ? null : new MCBlockPos(pos);
        CTColor color = blockColorSupplier.getColor(new MCBlockState(state), (crafttweaker.api.world.IBlockAccess)blockAccess, blockPos, tintIndex);
        return color == null ? -1 : color.getIntColor();
    }

    public int getColorFromItemstack(@Nonnull ItemStack stack, int tintIndex) {
        return Optional.ofNullable(this.blockRepresentation.getItemColorSupplier()).map(supplier -> supplier.getColor((IItemStack)new MCItemStack(stack), tintIndex)).map(CTColor::getIntColor).orElse(-1);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        return this.blockRepresentation.canSilkHarvest;
    }
}

