/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.addons.AddonForge;
import io.github.drmanganese.topaddons.addons.AddonIndustrialCraft2;
import io.github.drmanganese.topaddons.addons.crossmod.AdvGensXIC2;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.reference.Colors;
import java.awt.Color;
import java.text.DecimalFormat;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.config.Config;
import net.bdew.generators.config.Tuning;
import net.bdew.generators.controllers.exchanger.TileExchangerController;
import net.bdew.generators.controllers.steam.TileSteamTurbineController;
import net.bdew.generators.controllers.syngas.TileSyngasController;
import net.bdew.generators.controllers.turbine.TileTurbineController;
import net.bdew.generators.modules.forgeOutput.BlockForgeOutput$;
import net.bdew.generators.modules.rfOutput.BlockRfOutput$;
import net.bdew.generators.modules.turbine.BlockTurbine;
import net.bdew.lib.multiblock.block.BlockOutput;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTankInfo;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;

@TOPAddon(dependency="advgenerators")
public class AddonAdvancedGenerators
extends AddonBlank {
    @Override
    public void addFluidColors() {
        Colors.FLUID_NAME_COLOR_MAP.put("syngas", new Color(73, 94, 15).hashCode());
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        FluidTankInfo fuel;
        BlockOutput blockOutput;
        Iterator it;
        boolean euOutput;
        boolean rfOutput;
        TileTurbineController controller;
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof TileTurbineController) {
            controller = (TileTurbineController)tile;
            rfOutput = false;
            euOutput = false;
            it = controller.getModuleBlocks(ClassTag$.MODULE$.apply(BlockOutput.class)).valuesIterator();
            while (it.hasNext()) {
                blockOutput = (BlockOutput)it.next();
                if (blockOutput instanceof BlockRfOutput$ || blockOutput instanceof BlockForgeOutput$) {
                    rfOutput = true;
                }
                euOutput = TOPAddons.ic2Loaded && AdvGensXIC2.isEuOutput(blockOutput);
            }
            if (euOutput && !rfOutput) {
                AddonIndustrialCraft2.euBar(probeInfo, (int)(controller.power().stored() * Tuning.getSection((String)"Power").getFloat("EU_MJ_Ratio")), (int)(controller.power().capacity() * Tuning.getSection((String)"Power").getFloat("EU_MJ_Ratio")));
                AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons:generating*}", (int)(controller.outputAverage().average() * (double)Tuning.getSection((String)"Power").getFloat("EU_MJ_Ratio")) + "/" + (int)(((Float)controller.maxMJPerTick().value()).floatValue() * Tuning.getSection((String)"Power").getFloat("EU_MJ_Ratio")) + " EU/t");
            } else {
                if (Config.getRealConfig().getRFMode() == 1) {
                    probeInfo.progress((int)controller.power().stored(), (int)controller.power().capacity(), probeInfo.defaultProgressStyle().suffix("RF").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(Config.rfFormat));
                } else {
                    probeInfo.text(TextStyleClass.PROGRESS + "RF: " + ElementProgress.format((long)((int)controller.power().stored()), (NumberFormat)Config.rfFormat, (String)"RF"));
                }
                AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons:generating*}", (int)(controller.outputAverage().average() * (double)Tuning.getSection((String)"Power").getFloat("RF_MJ_Ratio")) + "/" + (int)(((Float)controller.maxMJPerTick().value()).floatValue() * Tuning.getSection((String)"Power").getFloat("RF_MJ_Ratio")) + " RF/t");
            }
            AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons.advgenerators:turbines*}", String.valueOf(controller.getModuleBlocks(ClassTag$.MODULE$.apply(BlockTurbine.class)).size()));
            fuel = controller.fuel().getInfo();
            AddonForge.addTankElement(probeInfo, "Fuel", fuel, mode, player);
            AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons:generating*}", new DecimalFormat("#.##").format(controller.fuelPerTickAverage().average()) + "/" + new DecimalFormat("#.##").format(controller.fuelPerTick().value()) + " mB/t");
        }
        if (tile instanceof TileSteamTurbineController) {
            controller = (TileSteamTurbineController)tile;
            rfOutput = false;
            euOutput = false;
            it = controller.getModuleBlocks(ClassTag$.MODULE$.apply(BlockOutput.class)).valuesIterator();
            while (it.hasNext()) {
                blockOutput = (BlockOutput)it.next();
                if (blockOutput instanceof BlockRfOutput$ || blockOutput instanceof BlockForgeOutput$) {
                    rfOutput = true;
                }
                euOutput = TOPAddons.ic2Loaded && AdvGensXIC2.isEuOutput(blockOutput);
            }
            if (euOutput && !rfOutput) {
                AddonIndustrialCraft2.euBar(probeInfo, (int)(controller.power().stored() * Tuning.getSection((String)"Power").getFloat("EU_MJ_Ratio")), (int)(controller.power().capacity() * Tuning.getSection((String)"Power").getFloat("EU_MJ_Ratio")));
                AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons:generating*}", (int)(controller.outputAverage().average() * (double)Tuning.getSection((String)"Power").getFloat("EU_MJ_Ratio")) + "/" + (int)((Double)controller.maxMJPerTick().value() * (double)Tuning.getSection((String)"Power").getFloat("EU_MJ_Ratio")) + " EU/t");
            } else {
                if (Config.getRealConfig().getRFMode() == 1) {
                    probeInfo.progress((int)controller.power().stored(), (int)controller.power().capacity(), probeInfo.defaultProgressStyle().suffix("RF").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(Config.rfFormat));
                } else {
                    probeInfo.text(TextStyleClass.PROGRESS + "RF: " + ElementProgress.format((long)((int)controller.power().stored()), (NumberFormat)Config.rfFormat, (String)"RF"));
                }
                AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons:generating*}", (int)(controller.outputAverage().average() * (double)Tuning.getSection((String)"Power").getFloat("RF_MJ_Ratio")) + "/" + (int)((Double)controller.maxMJPerTick().value() * (double)Tuning.getSection((String)"Power").getFloat("RF_MJ_Ratio")) + " RF/t");
            }
            AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons.advgenerators:turbines*}", String.valueOf(controller.getModuleBlocks(ClassTag$.MODULE$.apply(BlockTurbine.class)).size()));
            fuel = controller.steam().getInfo();
            AddonForge.addTankElement(probeInfo, "Fuel", fuel, mode, player);
            AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons:consumption*}", new DecimalFormat("#.##").format(controller.steamAverage().average()) + " mB/t");
            AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons.advgenerators:speed*}", new DecimalFormat("#").format(controller.speed().value()) + " RPM");
        }
        if (tile instanceof TileSyngasController) {
            controller = (TileSyngasController)tile;
            AddonForge.addTankElement(probeInfo, "Water Tank", controller.waterTank().getInfo(), mode, player);
            AddonForge.addTankElement(probeInfo, "Syngas Tank", controller.syngasTank().getInfo(), mode, player);
            IProbeInfo hori = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(2));
            IProbeInfo labels = hori.vertical(probeInfo.defaultLayoutStyle().spacing(4));
            IProbeInfo bars = hori.vertical();
            double deltaHeat = controller.avgHeatDelta().average();
            labels.text(TextStyleClass.LABEL + "{*topaddons.advgenerators:heat*}:");
            bars.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(2)).progress((int)Math.round((Double)controller.heat().value()), (int)controller.cfg().maxHeat(), probeInfo.defaultProgressStyle().filledColor(-2741474).alternateFilledColor(-2741474).suffix("/" + (int)controller.cfg().maxHeat() + " HU").width(63)).text((deltaHeat > 0.0 ? TextFormatting.GREEN : (deltaHeat < 0.0 ? TextFormatting.RED : TextFormatting.RESET)) + new DecimalFormat("#.##").format(deltaHeat) + " HU/t");
            labels.text(TextStyleClass.LABEL + "{*topaddons.advgenerators:carbon*}:");
            bars.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(2)).progress((int)Math.round(100.0 * (Double)controller.carbonBuffer().value() / (double)controller.cfg().internalTankCapacity()), 100, probeInfo.defaultProgressStyle().filledColor(-14540254).alternateFilledColor(-14540254).suffix("%").width(63)).text(new DecimalFormat("#.##").format(controller.avgCarbonUsed().average()) + " C/t");
            if (mode == ProbeMode.EXTENDED) {
                hori = probeInfo.horizontal(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-14540254)));
                for (ItemStack itemStack : controller.inventory().inv()) {
                    if (itemStack.func_190926_b()) continue;
                    hori.item(itemStack);
                }
            }
            labels.text(TextStyleClass.LABEL + "{*topaddons.advgenerators:steam*}:");
            bars.progress((int)Math.round(100.0 * (Double)controller.steamBuffer().value() / (double)controller.cfg().internalTankCapacity()), 100, probeInfo.defaultProgressStyle().filledColor(-2236963).alternateFilledColor(-2236963).suffix("%").width(63));
            AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons.advgenerators:production*}", new DecimalFormat("#.##").format(controller.avgSyngasProduced().average()) + " mB/t");
        }
        if (tile instanceof TileExchangerController) {
            controller = (TileExchangerController)tile;
            double deltaHeat = controller.heatLoss().average();
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(2)).text(TextStyleClass.LABEL + "{*topaddons.advgenerators:heat*}:").progress((int)Math.round((Double)controller.heat().value()), (int)controller.cfg().maxHeat(), probeInfo.defaultProgressStyle().filledColor(-2741474).alternateFilledColor(-2741474).suffix("/" + (int)controller.cfg().maxHeat() + " HU").width(70)).text(new DecimalFormat("-#.##").format(deltaHeat) + " HU/t");
            AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons.advgenerators:max_heat_transfer*}", new DecimalFormat("#.##").format(controller.maxHeatTransfer().value()) + " HU");
            AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons.advgenerators:fluid_consumption*}", new DecimalFormat("#.##").format(controller.inputRate().average()) + " mB/t");
            AddonAdvancedGenerators.textPrefixed(probeInfo, "{*topaddons.advgenerators:fluid_production*}", new DecimalFormat("#.##").format(controller.outputRate().average()) + " mB/t");
        }
        if (TOPAddons.ic2Loaded) {
            AdvGensXIC2.euOutputInfo(probeInfo, tile);
        }
    }
}

