/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import binnie.genetics.item.GeneticLiquid;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.addons.subaddons.binniesmods.SubAddonBotany;
import io.github.drmanganese.topaddons.addons.subaddons.binniesmods.SubAddonGenetics;
import io.github.drmanganese.topaddons.addons.subaddons.binniesmods.SubAddonTrees;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.elements.binnies.ElementFlowerColor;
import io.github.drmanganese.topaddons.reference.Colors;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

@TOPAddon(dependency="binniecore", fancyName="Binnie's Mods")
public class AddonBinniesMods
extends AddonBlank {
    private final Set<AddonBlank> SUB_ADDONS = new HashSet<AddonBlank>();

    public AddonBinniesMods() {
        if (Loader.isModLoaded((String)"botany")) {
            this.SUB_ADDONS.add(new SubAddonBotany());
        }
        if (Loader.isModLoaded((String)"genetics")) {
            this.SUB_ADDONS.add(new SubAddonGenetics());
        }
        if (Loader.isModLoaded((String)"extratrees")) {
            this.SUB_ADDONS.add(new SubAddonTrees());
        }
    }

    @Override
    public void addFluidColors() {
        for (GeneticLiquid geneticLiquid : GeneticLiquid.values()) {
            Colors.FLUID_NAME_COLOR_MAP.put(geneticLiquid.getType().getIdentifier(), geneticLiquid.getType().getContainerColor() + -16777216);
        }
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        for (AddonBlank subAddon : this.SUB_ADDONS) {
            subAddon.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    @Override
    public List<IBlockDisplayOverride> getBlockDisplayOverrides() {
        ArrayList<IBlockDisplayOverride> list = new ArrayList<IBlockDisplayOverride>();
        this.SUB_ADDONS.stream().map(AddonBlank::getBlockDisplayOverrides).forEach(list::addAll);
        return list;
    }

    @Override
    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        for (AddonBlank subAddon : this.SUB_ADDONS) {
            subAddon.getProbeConfig(config, player, world, blockState, data);
        }
    }

    @Override
    public void registerElements() {
        this.registerElement("flowerColor", ElementFlowerColor::new);
    }
}

