/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.eggmachine;

import com.gendeathrow.hatchery.block.TileUpgradable;
import com.gendeathrow.hatchery.block.eggmachine.EggMachineBlock;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.storage.EnergyStorageRF;
import com.gendeathrow.hatchery.storage.InventoryStroageModifiable;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;

public class EggMachineTileEntity
extends TileUpgradable
implements ITickable {
    public int EggInSlot = 0;
    public int PlasticInSlot = 1;
    public int PrizeEggSlot = 0;
    protected InventoryStroageModifiable inputInventory = new InventoryStroageModifiable("inputItems", 2){

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            if (slot == EggMachineTileEntity.this.EggInSlot && stack.func_77973_b() instanceof ItemEgg) {
                return true;
            }
            return slot == EggMachineTileEntity.this.PlasticInSlot && stack.func_77973_b() == ModItems.plastic;
        }
    };
    protected InventoryStroageModifiable outputInventory = new InventoryStroageModifiable("outputItems", 1){

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            return false;
        }
    };
    protected EnergyStorageRF energy = new EnergyStorageRF(20000){

        @Override
        public boolean canExtract() {
            return false;
        }
    }.setMaxReceive(100);
    protected int internalEggStorage = 0;
    protected int internalPlasticStorage = 0;
    private int eggToPrizeSize = 24;
    public int eggTime = 0;
    public int maxEggTime = 200;
    float zeroedFacing;
    float currentFacing;
    float prevAnimationTicks;
    float animationTicks;
    boolean firstRun = true;

    public EggMachineTileEntity() {
        super(2);
    }

    public void updateClient() {
        if (this.firstRun) {
            this.firstRun = false;
            EnumFacing facing = EggMachineBlock.getFacing(this.field_145850_b.func_180495_p(this.field_174879_c));
            this.animationTicks = this.zeroedFacing = facing.func_185119_l();
        }
        this.prevAnimationTicks = this.animationTicks;
        if (this.animationTicks < 360.0f) {
            this.animationTicks += 5.0f;
        }
        if (this.animationTicks >= 360.0f) {
            this.animationTicks -= 360.0f;
            this.prevAnimationTicks -= 360.0f;
        }
    }

    public void func_73660_a() {
        boolean hasRoomForEgg;
        if (this.field_145850_b.field_72995_K) {
            this.updateClient();
        }
        ItemStack eggIn = this.inputInventory.getStackInSlot(this.EggInSlot);
        ItemStack plasticIn = this.inputInventory.getStackInSlot(this.PlasticInSlot);
        if (!eggIn.func_190926_b() && eggIn.func_77973_b() instanceof ItemEgg) {
            this.internalEggStorage += eggIn.func_190916_E();
            this.inputInventory.setStackInSlot(this.EggInSlot, ItemStack.field_190927_a);
        }
        if (!plasticIn.func_190926_b() && plasticIn.func_77973_b() == ModItems.plastic) {
            this.internalPlasticStorage += plasticIn.func_190916_E();
            this.inputInventory.setStackInSlot(this.PlasticInSlot, ItemStack.field_190927_a);
        }
        if (this.eggTime <= 0 && this.canMakePrizeEgg()) {
            this.eggTime = this.maxEggTime;
            this.internalEggStorage -= this.eggToPrizeSize;
            this.internalPlasticStorage -= 2;
            this.func_70296_d();
        }
        boolean hasTimeLeft = this.eggTime > 0;
        ItemStack prizeSlot = this.outputInventory.getStackInSlot(this.PrizeEggSlot);
        boolean bl = prizeSlot.func_190926_b() ? true : (hasRoomForEgg = prizeSlot.func_190916_E() < prizeSlot.func_77976_d());
        if (!this.field_145850_b.field_72995_K && hasTimeLeft && this.energy.getEnergyStored() >= 40 && hasRoomForEgg) {
            --this.eggTime;
            this.energy.extractEnergy(40, false);
            if (this.eggTime <= 0) {
                this.createPrizeEgg();
                this.func_70296_d();
            }
        }
    }

    private boolean canMakePrizeEgg() {
        return this.eggToPrizeSize <= this.internalEggStorage && this.internalPlasticStorage >= 2;
    }

    private void createPrizeEgg() {
        ItemStack itemstack = new ItemStack(ModItems.prizeEgg);
        ItemStack eggStack = this.outputInventory.getStackInSlot(this.PrizeEggSlot);
        if (eggStack.func_190926_b()) {
            this.outputInventory.setStackInSlot(this.PrizeEggSlot, itemstack);
        } else if (eggStack.func_77973_b() == ModItems.prizeEgg && eggStack.func_190916_E() < eggStack.func_77976_d()) {
            eggStack.func_190917_f(1);
        }
    }

    @Override
    public boolean canUseUpgrade(ItemStack item) {
        return item.func_77973_b() == ModItems.rfUpgradeTier || item.func_77973_b() == ModItems.speedUpgradeTier || item.func_77973_b() == ModItems.rfCapacityUpgradeTier1;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputInventory.readFromNBT(compound);
        this.outputInventory.readFromNBT(compound);
        this.energy.readFromNBT(compound);
        this.internalEggStorage = compound.func_74762_e("EggStorage");
        this.internalPlasticStorage = compound.func_74762_e("PlasticStorage");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.inputInventory.writeToNBT(compound);
        this.outputInventory.writeToNBT(compound);
        this.energy.writeToNBT(compound);
        compound.func_74768_a("EggStorage", this.internalEggStorage);
        compound.func_74768_a("PlasticStorage", this.internalPlasticStorage);
        return compound;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN) {
            return (T)((Object)this.outputInventory);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inputInventory);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.energy.getEnergyStored();
            }
            case 1: {
                return this.internalEggStorage;
            }
            case 2: {
                return this.internalPlasticStorage;
            }
            case 3: {
                return this.eggTime;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.energy.setEnergyStored(value);
                break;
            }
            case 1: {
                this.internalEggStorage = value;
                break;
            }
            case 2: {
                this.internalPlasticStorage = value;
                break;
            }
            case 3: {
                this.eggTime = value;
            }
        }
    }

    public int getFieldCount() {
        return 4;
    }
}

