/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.fertilizermixer;

import com.gendeathrow.hatchery.block.BasicHatcheryContainer;
import com.gendeathrow.hatchery.block.fertilizermixer.FertilizerMixerTileEntity;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModFluids;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.inventory.SlotFluidContainer;
import com.gendeathrow.hatchery.network.HatcheryWindowPacket;
import com.gendeathrow.hatchery.storage.InventoryStroageModifiable;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerFertlizerMixer
extends BasicHatcheryContainer {
    private final IItemHandler inputInventory;
    private final IItemHandler outputInventory;
    private final InventoryStroageModifiable upgrades;
    private final ItemStack[] manure;
    private final FertilizerMixerTileEntity tileEntity;
    private int waterTank;
    private int fertilizerTank;

    public ContainerFertlizerMixer(InventoryPlayer playerInventory, FertilizerMixerTileEntity fertilizerInventory) {
        this.inputInventory = (IItemHandler)fertilizerInventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        this.outputInventory = (IItemHandler)fertilizerInventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        this.tileEntity = fertilizerInventory;
        this.manure = null;
        this.upgrades = fertilizerInventory.getUpgradeStorage();
        this.addInventories(new IItemHandler[]{this.inputInventory, this.upgrades, this.outputInventory});
        this.waterTank = fertilizerInventory.getWaterTank().getFluidAmount();
        this.fertilizerTank = fertilizerInventory.getFertilizerTank().getFluidAmount();
        this.func_75146_a((Slot)new SlotItemHandler(this.inputInventory, 0, 17, 16){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                return stack.func_77973_b() == ModItems.manure || stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.manureBlock);
            }
        });
        this.func_75146_a((Slot)new SlotFluidContainer(this.inputInventory, 1, 72, 16, FluidRegistry.WATER));
        this.func_75146_a((Slot)new SlotItemHandler(this.inputInventory, 2, 104, 16){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.DOWN);
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.upgrades, 0, 8, 52){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                boolean value = super.func_75214_a(stack);
                if (value) {
                    value = ContainerFertlizerMixer.this.tileEntity.canUseUpgrade(stack);
                }
                return value;
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.upgrades, 1, 31, 52){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                boolean value = super.func_75214_a(stack);
                if (value) {
                    value = ContainerFertlizerMixer.this.tileEntity.canUseUpgrade(stack);
                }
                return value;
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler(this.outputInventory, 0, 72, 52){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                return false;
            }
        });
        this.func_75146_a((Slot)new SlotFluidContainer(this.outputInventory, 1, 104, 52, ModFluids.liquidfertilizer));
        this.bindPlayerInventory(playerInventory);
    }

    @Override
    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        this.tileEntity.setField(id, value);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            listener.func_71112_a((Container)this, 4, this.tileEntity.getField(4));
            listener.func_71112_a((Container)this, 5, this.tileEntity.getField(5));
            listener.func_71112_a((Container)this, 0, this.tileEntity.getField(0));
            listener.func_71112_a((Container)this, 1, this.tileEntity.getField(1));
            HatcheryWindowPacket.sendProgressBarUpdate(listener, this, 6, this.tileEntity.getField(6));
            HatcheryWindowPacket.sendProgressBarUpdate(listener, this, 3, this.tileEntity.getField(3));
        }
        this.waterTank = this.tileEntity.getField(0);
        this.fertilizerTank = this.tileEntity.getField(1);
    }
}

