/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.nest;

import com.gendeathrow.hatchery.Hatchery;
import com.gendeathrow.hatchery.block.nest.EggNestTileEntity;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.theoneprobe.TOPInfoProvider;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EggNestBlock
extends Block
implements ITileEntityProvider,
TOPInfoProvider {
    public static final PropertyBool hasEgg = PropertyBool.func_177716_a((String)"hasegg");
    protected static final AxisAlignedBB noEgg_AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.15, 0.8125);
    protected static final AxisAlignedBB withEgg_AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.25, 0.8125);
    protected static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{noEgg_AABB, withEgg_AABB};
    protected String name = "nest";

    public EggNestBlock() {
        super(Material.field_151584_j);
        this.func_149663_c("nest");
        this.func_149647_a(Hatchery.hatcheryTabs);
        this.func_149711_c(0.2f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)hasEgg, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack stack;
        if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof EggNestTileEntity && !(stack = ((EggNestTileEntity)worldIn.func_175625_s(pos)).getEgg()).func_190926_b()) {
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.nest);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOXES[(Boolean)state.func_177229_b((IProperty)hasEgg) != false ? 1 : 0];
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack(ModBlocks.nest, 1, 0));
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        EggNestTileEntity te = (EggNestTileEntity)worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K) {
            if (EggNestBlock.doesHaveEgg(state)) {
                ItemStack egg = te.removeEgg();
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), egg));
                EggNestBlock.removeEgg(worldIn, state, pos);
                return true;
            }
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemEgg) {
                te.insertEgg(heldItem);
                EggNestBlock.addEgg(worldIn, state, pos);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                return true;
            }
        }
        return true;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public static boolean doesHaveEgg(IBlockState state) {
        if (state.func_177230_c() != ModBlocks.nest) {
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)hasEgg);
    }

    public static void setEggState(World worldIn, IBlockState state, BlockPos pos, boolean egg) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)hasEgg, (Comparable)Boolean.valueOf(egg)));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public static void addEgg(World worldIn, IBlockState state, BlockPos pos) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)hasEgg, (Comparable)Boolean.valueOf(true)));
    }

    public static void removeEgg(World worldIn, IBlockState state, BlockPos pos) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)hasEgg, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new EggNestTileEntity();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{hasEgg});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 1) {
            return this.func_176223_P().func_177226_a((IProperty)hasEgg, (Comparable)Boolean.valueOf(true));
        }
        return this.func_176223_P().func_177226_a((IProperty)hasEgg, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)hasEgg)).booleanValue()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof EggNestTileEntity) {
            EggNestTileEntity hte = (EggNestTileEntity)te;
            if (hte.getEgg() != null) {
                float percentage = hte.getPercentage();
                probeInfo.text(TextFormatting.YELLOW + "Hatching: " + TextFormatting.GREEN + percentage + "%");
                probeInfo.text(TextFormatting.YELLOW + hte.getEgg().func_82833_r());
            } else {
                probeInfo.text(TextFormatting.RED + "Not Hatching");
            }
        }
    }
}

