/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.shredder;

import com.gendeathrow.hatchery.block.BasicHatcheryContainer;
import com.gendeathrow.hatchery.block.shredder.ShredderTileEntity;
import com.gendeathrow.hatchery.network.HatcheryWindowPacket;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerShredder
extends BasicHatcheryContainer {
    private final IItemHandler inputInventory;
    private final IItemHandler outputInventory;
    private final IItemHandler upgrades;
    private final ShredderTileEntity shredder;

    public ContainerShredder(InventoryPlayer playerInventory, ShredderTileEntity tile, EntityPlayer player) {
        this.inputInventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
        this.outputInventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        this.upgrades = tile.getUpgradeStorage();
        this.addInventories(this.inputInventory, this.upgrades, this.outputInventory);
        this.shredder = tile;
        this.func_75146_a((Slot)new SlotItemHandler(this.inputInventory, 0, 65, 16));
        this.func_75146_a((Slot)new SlotItemHandler(this.upgrades, 0, 121, 54){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                boolean value = super.func_75214_a(stack);
                if (value) {
                    value = ContainerShredder.this.shredder.canUseUpgrade(stack);
                }
                return value;
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler(this.upgrades, 1, 141, 54){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                boolean value = super.func_75214_a(stack);
                if (value) {
                    value = ContainerShredder.this.shredder.canUseUpgrade(stack);
                }
                return value;
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler(this.outputInventory, 0, 55, 54){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                return false;
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler(this.outputInventory, 1, 76, 54){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                return false;
            }
        });
        this.bindPlayerInventory(playerInventory);
    }

    public void func_75132_a(IContainerListener listener) {
        if (this.field_75149_d.contains(listener)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.field_75149_d.add(listener);
        listener.func_71110_a((Container)this, this.func_75138_a());
        this.func_75142_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        this.shredder.setField(id, value);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            HatcheryWindowPacket.sendProgressBarUpdate(listener, this, 3, this.shredder.getField(3));
            HatcheryWindowPacket.sendProgressBarUpdate(listener, this, 0, this.shredder.getField(0));
            listener.func_71112_a((Container)this, 1, this.shredder.getField(1));
            listener.func_71112_a((Container)this, 2, this.shredder.getField(2));
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }
}

