/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.core.jei.generator;

import com.gendeathrow.hatchery.core.init.ModFluids;
import com.gendeathrow.hatchery.core.jei.generator.GeneratorRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class GeneratorCategory
extends BlankRecipeCategory<GeneratorRecipeWrapper> {
    public static final String UID = "hatchery.generator.recipe";
    private final String title = I18n.func_135052_a((String)"jei.gui.generator_recipes", (Object[])new Object[0]);
    private final IDrawableStatic background;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated rf;
    private final IDrawableAnimated poop;
    private final IDrawableStatic icon;

    public GeneratorCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("hatchery", "textures/gui/generator_jei.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 91, 78);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, 94, 0, 15, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.TOP, false);
        IDrawableStatic poopDrawable = guiHelper.createDrawable(location, 110, 0, 13, 58);
        this.poop = guiHelper.createAnimatedDrawable(poopDrawable, 200, IDrawableAnimated.StartDirection.TOP, true);
        IDrawableStatic rfDrawable = guiHelper.createDrawable(location, 123, 0, 15, 58);
        this.rf = guiHelper.createAnimatedDrawable(rfDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.icon = guiHelper.createDrawable(location, 91, 17, 16, 16);
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 60, 26);
        this.rf.draw(minecraft, 5, 6);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUid() {
        return UID;
    }

    public void setRecipe(IRecipeLayout recipeLayout, GeneratorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 60, 8);
        guiFluidStacks.init(1, true, 42, 6, 12, 57, 20000, true, (IDrawable)this.poop);
        guiItemStacks.set(ingredients);
        guiFluidStacks.set(1, new FluidStack(ModFluids.liquidfertilizer, 0));
    }

    public String getModName() {
        return "Hatchery";
    }
}

