/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.entities.ai;

import com.gendeathrow.hatchery.core.Settings;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.item.HatcheryEgg;
import com.gendeathrow.hatchery.util.ItemStackEntityNBTHelper;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class AutoBreeding
extends EntityAIBase {
    protected final EntityAnimal theAnimal;
    protected World theWorld;
    protected EntityAnimal targetMate;
    protected int spawnBabyDelay;
    protected double moveSpeed;

    public AutoBreeding(EntityAnimal animal, double speedIn) {
        this.theAnimal = animal;
        this.theWorld = animal.field_70170_p;
        this.moveSpeed = speedIn;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.theAnimal.func_110167_bD() && this.theAnimal.func_110166_bE() != null && this.theAnimal.func_110166_bE() instanceof EntityAnimal && this.theAnimal.func_70878_b((EntityAnimal)this.theAnimal.func_110166_bE())) {
            this.targetMate = (EntityAnimal)this.theAnimal.func_110166_bE();
            return this.targetMate != null;
        }
        return false;
    }

    public boolean continueExecuting() {
        return this.targetMate.func_70089_S() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.theAnimal.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.theAnimal.func_70646_bf());
        this.theAnimal.func_70661_as().func_75497_a((Entity)this.targetMate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay < 60 || this.theAnimal.func_70068_e((Entity)this.targetMate) < 9.0) {
            // empty if block
        }
    }

    private void spawnEgg() {
        EntityAgeable entityageable = this.theAnimal.func_90011_a((EntityAgeable)this.targetMate);
        if (entityageable != null) {
            EntityPlayerMP entityplayer = this.theAnimal.func_191993_do();
            if (entityplayer == null && this.targetMate.func_191993_do() != null) {
                entityplayer = this.targetMate.func_191993_do();
            }
            if (entityplayer != null) {
                entityplayer.func_71029_a(StatList.field_151186_x);
            }
            this.theAnimal.func_70873_a(6000);
            this.targetMate.func_70873_a(6000);
            this.theAnimal.func_70875_t();
            this.targetMate.func_70875_t();
            entityageable.func_70873_a(-24000);
            entityageable.func_70012_b(this.theAnimal.field_70165_t, this.theAnimal.field_70163_u, this.theAnimal.field_70161_v, 0.0f, 0.0f);
            EntityAgeable entity = entityageable;
            if (Settings.IS_EGG_BREEDING) {
                ItemStack egg = new ItemStack(ModItems.hatcheryEgg, 1, 0);
                ItemStackEntityNBTHelper.addEntitytoItemStack(egg, (EntityLiving)entityageable);
                egg.func_151001_c(entityageable.func_145748_c_().func_150254_d() + " Egg");
                HatcheryEgg.setColor(egg, (Entity)entityageable);
                entity = new EntityItem(this.theWorld, this.theAnimal.field_70165_t, this.theAnimal.field_70163_u, this.theAnimal.field_70161_v, egg);
            }
            this.theWorld.func_72838_d((Entity)entity);
            Random random = this.theAnimal.func_70681_au();
            for (int i = 0; i < 7; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextDouble() * (double)this.theAnimal.field_70130_N * 2.0 - (double)this.theAnimal.field_70130_N;
                double d4 = 0.5 + random.nextDouble() * (double)this.theAnimal.field_70131_O;
                double d5 = random.nextDouble() * (double)this.theAnimal.field_70130_N * 2.0 - (double)this.theAnimal.field_70130_N;
                this.theWorld.func_175688_a(EnumParticleTypes.HEART, this.theAnimal.field_70165_t + d3, this.theAnimal.field_70163_u + d4, this.theAnimal.field_70161_v + d5, d0, d1, d2, new int[0]);
            }
            if (this.theWorld.func_82736_K().func_82766_b("doMobLoot")) {
                this.theWorld.func_72838_d((Entity)new EntityXPOrb(this.theWorld, this.theAnimal.field_70165_t, this.theAnimal.field_70163_u, this.theAnimal.field_70161_v, random.nextInt(7) + 1));
            }
        }
    }
}

