/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class JsonConfig {
    boolean hasChanged = false;
    private File configFile;
    private JsonObject json;
    private Gson gson;

    public JsonConfig(File file) {
        this.configFile = file;
        this.gson = new Gson();
        this.json = new JsonObject();
    }

    public void Save() {
        this.WriteFile();
        this.hasChanged = false;
    }

    public void Load() {
        try {
            this.SetupFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.json = this.ReadFile();
    }

    public JsonObject getFullJson() {
        return this.json;
    }

    public void setFullJson(JsonObject newobject) {
        this.json = newobject;
        this.hasChanged = true;
    }

    public JsonObject getCategory(String categoryProperty) {
        JsonObject object = new JsonObject();
        if (this.json.has(categoryProperty)) {
            object = this.json.getAsJsonObject(categoryProperty);
        } else {
            this.json.add(categoryProperty, (JsonElement)object);
            this.setHasChanged(true);
        }
        return object;
    }

    public boolean getBoolean(String categoryProperty, String property, boolean value) {
        JsonObject object = this.getCategory(categoryProperty);
        if (object.has(property)) {
            value = object.get(property).getAsBoolean();
        } else {
            object.addProperty(property, Boolean.valueOf(value));
            this.setHasChanged(true);
        }
        return value;
    }

    public String getString(String categoryProperty, String property, String value) {
        JsonObject object = this.getCategory(categoryProperty);
        if (object.has(property)) {
            value = object.get(property).getAsString();
        } else {
            object.addProperty(property, value);
            this.setHasChanged(true);
        }
        return value;
    }

    public float getFloat(String categoryProperty, String property, float value, float min, float max) {
        JsonObject object = this.getCategory(categoryProperty);
        if (object.has(property)) {
            value = object.get(property).getAsFloat();
        } else {
            object.addProperty(property, (Number)Float.valueOf(value));
            this.setHasChanged(true);
        }
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    protected void setHasChanged(boolean val) {
        this.hasChanged = val;
    }

    private void SetupFile() throws IOException {
        if (!this.configFile.exists()) {
            this.hasChanged = true;
            this.configFile.getParentFile().mkdirs();
            this.configFile.createNewFile();
        }
    }

    protected JsonObject ReadFile() {
        JsonObject obj = new JsonObject();
        try {
            FileReader fr = new FileReader(this.configFile);
            JsonObject jsonobject = (JsonObject)this.gson.fromJson((Reader)fr, JsonObject.class);
            fr.close();
            return jsonobject != null ? jsonobject : obj;
        }
        catch (Exception e) {
            throw new RuntimeException("Error " + e.getCause() + " loading file: " + this.configFile.getPath());
        }
    }

    protected void WriteFile() {
        try {
            FileWriter fw = new FileWriter(this.configFile);
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.json, (Appendable)fw);
            fw.flush();
            fw.close();
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }
}

