/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModLogger;
import com.gitlab.cdagaming.craftpresence.handler.FileHandler;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.gitlab.cdagaming.craftpresence.handler.TranslationHandler;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.realms.RealmsSharedConstants;

public class Constants {
    public static final String NAME = "CraftPresence";
    public static final String majorVersion = "1";
    public static final String minorVersion = "5";
    public static final String revisionVersion = "5";
    public static final String VERSION_ID = "v1.5.5";
    public static final String MODID = "craftpresence";
    public static final String GUI_FACTORY = "com.gitlab.cdagaming.craftpresence.config.ConfigGUIFactoryDS";
    public static final String MCVersion = RealmsSharedConstants.VERSION_STRING;
    public static final String BRAND = ClientBrandRetriever.getClientModName();
    public static final String configDir = CraftPresence.SYSTEM.USER_DIR + File.separator + "config";
    public static final String modsDir = CraftPresence.SYSTEM.USER_DIR + File.separator + "mods";
    public static final String USERNAME = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    public static final String UPDATE_JSON = "https://gitlab.com/CDAGaming/VersionLibrary/raw/master/CraftPresence/update.json";
    public static final String FINGERPRINT = "eca02c6a597321ad22340897683951ba5c76720a";
    public static final ModLogger LOG = new ModLogger("craftpresence");
    public static final ClassLoader CLASS_LOADER = Thread.currentThread().getContextClassLoader();
    public static final TranslationHandler TRANSLATOR = new TranslationHandler("craftpresence", false);
    public static final boolean IS_DEV = Launch.blackboard != null && !Launch.blackboard.isEmpty() && Launch.blackboard.containsKey("fml.deobfuscatedEnvironment") && (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false;
    public static boolean forceBlockTooltipRendering = false;

    static void loadDLL(boolean Update) {
        boolean UpdateStatus = Update;
        ArrayList x64 = Lists.newArrayList((Object[])new String[]{"amd64", "x86_64"});
        boolean is64Bit = x64.contains(CraftPresence.SYSTEM.OS_ARCH);
        String fileName = CraftPresence.SYSTEM.IS_WINDOWS ? "discord-rpc.dll" : (CraftPresence.SYSTEM.IS_LINUX ? "libdiscord-rpc.so" : (CraftPresence.SYSTEM.IS_MAC ? "libdiscord-rpc.dylib" : ""));
        String url = "https://gitlab.com/CDAGaming/VersionLibrary/raw/master/CraftPresence/resources/DLL/" + (CraftPresence.SYSTEM.IS_WINDOWS ? (is64Bit ? "win32-x86-64" : "win32-x86") : (CraftPresence.SYSTEM.IS_LINUX ? "linux-x86-64" : (CraftPresence.SYSTEM.IS_MAC ? "darwin" : ""))) + "/" + fileName;
        File file = new File(MODID + File.separator + fileName);
        boolean bl = UpdateStatus = UpdateStatus || !file.exists();
        if (UpdateStatus) {
            FileHandler.downloadFile(url, file);
        }
        FileHandler.loadFileAsDLL(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCharData(boolean Update) {
        LOG.info(TRANSLATOR.translate(true, "craftpresence.logger.info.chardata.init", new Object[0]), new Object[0]);
        String fileName = "chardata.properties";
        String charDataPath = "/assets/craftpresence/chardata.properties";
        File charDataDir = new File(MODID + File.separator + "chardata.properties");
        boolean UpdateStatus = Update || !charDataDir.exists();
        boolean errored = false;
        InputStream inputData = null;
        InputStreamReader inputStream = null;
        OutputStream outputData = null;
        BufferedReader reader = null;
        if (UpdateStatus) {
            LOG.info(TRANSLATOR.translate(true, "craftpresence.logger.info.download.init", "chardata.properties", charDataDir.getAbsolutePath(), "/assets/craftpresence/chardata.properties"), new Object[0]);
            inputData = StringHandler.getResourceAsStream(Constants.class, "/assets/craftpresence/chardata.properties");
            if (inputData != null) {
                try {
                    outputData = new FileOutputStream(charDataDir);
                    byte[] transferBuffer = new byte[inputData.available()];
                    int readBuffer = inputData.read(transferBuffer);
                    while (readBuffer != -1) {
                        outputData.write(transferBuffer, 0, readBuffer);
                        readBuffer = inputData.read(transferBuffer);
                    }
                    LOG.info(TRANSLATOR.translate(true, "craftpresence.logger.info.download.loaded", "chardata.properties", charDataDir.getAbsolutePath(), "/assets/craftpresence/chardata.properties"), new Object[0]);
                }
                catch (Exception ex) {
                    errored = true;
                }
            } else {
                errored = true;
            }
        }
        if (!errored) {
            try {
                String currentString;
                inputData = new FileInputStream(charDataDir);
                inputStream = new InputStreamReader(inputData, Charset.forName("UTF-8"));
                reader = new BufferedReader(inputStream);
                while ((currentString = reader.readLine()) != null) {
                    int i;
                    String[] localWidths;
                    if ((currentString = currentString.trim()).startsWith("=") || !currentString.contains("=")) continue;
                    String[] splitString = currentString.split("=", 2);
                    if (splitString[0].equalsIgnoreCase("charWidth")) {
                        localWidths = splitString[1].replaceAll("\\[", "").replaceAll("]", "").split(", ");
                        for (i = 0; i < localWidths.length && i <= 256; ++i) {
                            StringHandler.MC_CHAR_WIDTH[i] = Integer.parseInt(localWidths[i].trim());
                        }
                        continue;
                    }
                    if (!splitString[0].equalsIgnoreCase("glyphWidth")) continue;
                    localWidths = splitString[1].replaceAll("\\[", "").replaceAll("]", "").split(", ");
                    for (i = 0; i < localWidths.length && i <= 65536; ++i) {
                        StringHandler.MC_GLYPH_WIDTH[i] = Byte.parseByte(localWidths[i].trim());
                    }
                }
                if (Arrays.equals(StringHandler.MC_CHAR_WIDTH, new int[256]) || Arrays.equals(StringHandler.MC_GLYPH_WIDTH, new byte[65536])) {
                    errored = true;
                }
            }
            catch (Exception ex) {
                Constants.loadCharData(true);
            }
        }
        try {
            if (reader != null) {
                reader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (inputData != null) {
                inputData.close();
            }
            if (outputData != null) {
                outputData.close();
            }
        }
        catch (Exception ex) {
            LOG.error(TRANSLATOR.translate(true, "craftpresence.logger.error.dataclose", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
        finally {
            if (errored) {
                LOG.error(TRANSLATOR.translate(true, "craftpresence.logger.error.chardata", new Object[0]), new Object[0]);
                forceBlockTooltipRendering = true;
            } else {
                LOG.info(TRANSLATOR.translate(true, "craftpresence.logger.info.chardata.loaded", new Object[0]), new Object[0]);
                forceBlockTooltipRendering = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToCharData() {
        ArrayList textData = Lists.newArrayList();
        FileInputStream inputData = null;
        InputStreamReader inputStream = null;
        OutputStream outputData = null;
        OutputStreamWriter outputStream = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        File charDataDir = new File(MODID + File.separator + "chardata.properties");
        if (charDataDir.exists()) {
            try {
                String currentString;
                inputData = new FileInputStream(charDataDir);
                inputStream = new InputStreamReader((InputStream)inputData, Charset.forName("UTF-8"));
                br = new BufferedReader(inputStream);
                while (!StringHandler.isNullOrEmpty(currentString = br.readLine())) {
                    if (!currentString.contains("=")) continue;
                    if (currentString.toLowerCase().startsWith("charwidth")) {
                        textData.add("charWidth=" + Arrays.toString(StringHandler.MC_CHAR_WIDTH));
                        continue;
                    }
                    if (!currentString.toLowerCase().startsWith("glyphwidth")) continue;
                    textData.add("glyphWidth=" + Arrays.toString(StringHandler.MC_GLYPH_WIDTH));
                }
                outputData = new FileOutputStream(charDataDir);
                outputStream = new OutputStreamWriter(outputData, Charset.forName("UTF-8"));
                bw = new BufferedWriter(outputStream);
                if (!textData.isEmpty()) {
                    for (String lineInput : textData) {
                        bw.write(lineInput);
                        bw.newLine();
                    }
                }
                Constants.loadCharData(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (bw != null) {
                        bw.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (inputData != null) {
                        ((InputStream)inputData).close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (outputData != null) {
                        outputData.close();
                    }
                }
                catch (Exception ex) {
                    LOG.error(TRANSLATOR.translate(true, "craftpresence.logger.error.dataclose", new Object[0]), new Object[0]);
                    ex.printStackTrace();
                }
            }
        } else {
            Constants.loadCharData(true);
        }
    }
}

