/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence;

import com.gitlab.cdagaming.craftpresence.Constants;
import com.gitlab.cdagaming.craftpresence.config.ConfigHandler;
import com.gitlab.cdagaming.craftpresence.handler.CommandHandler;
import com.gitlab.cdagaming.craftpresence.handler.KeyHandler;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.gitlab.cdagaming.craftpresence.handler.SystemHandler;
import com.gitlab.cdagaming.craftpresence.handler.discord.DiscordHandler;
import com.gitlab.cdagaming.craftpresence.handler.discord.rpc.DiscordRPC;
import com.gitlab.cdagaming.craftpresence.handler.entity.EntityHandler;
import com.gitlab.cdagaming.craftpresence.handler.gui.GUIHandler;
import com.gitlab.cdagaming.craftpresence.handler.server.ServerHandler;
import com.gitlab.cdagaming.craftpresence.handler.world.BiomeHandler;
import com.gitlab.cdagaming.craftpresence.handler.world.DimensionHandler;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;

@Mod(modid="craftpresence", name="CraftPresence", version="v1.5.5", clientSideOnly=true, guiFactory="com.gitlab.cdagaming.craftpresence.config.ConfigGUIFactoryDS", canBeDeactivated=true, updateJSON="https://gitlab.com/CDAGaming/VersionLibrary/raw/master/CraftPresence/update.json", certificateFingerprint="eca02c6a597321ad22340897683951ba5c76720a", acceptedMinecraftVersions="*")
public class CraftPresence {
    public static boolean packFound = false;
    public static boolean awaitingReply = false;
    public static boolean closing = false;
    public static Minecraft instance = Minecraft.func_71410_x();
    public static EntityPlayer player = CraftPresence.instance.field_71439_g;
    public static ConfigHandler CONFIG;
    public static SystemHandler SYSTEM;
    public static KeyHandler KEYBINDINGS;
    public static DiscordHandler CLIENT;
    public static ServerHandler SERVER;
    public static BiomeHandler BIOMES;
    public static DimensionHandler DIMENSIONS;
    public static EntityHandler ENTITIES;
    public static GUIHandler GUIS;
    public static Timer timerObj;
    private boolean initialized = false;

    public CraftPresence() {
        this.scheduleTick();
    }

    private void init() {
        if (!Constants.IS_DEV) {
            Constants.LOG.warn(Constants.TRANSLATOR.translate("craftpresence.logger.warning.fingerprintviolation", new Object[0]), new Object[0]);
        } else {
            Constants.LOG.warn(Constants.TRANSLATOR.translate("craftpresence.logger.warning.debugmode", new Object[0]), new Object[0]);
        }
        SYSTEM = new SystemHandler();
        CONFIG = new ConfigHandler(Constants.configDir + File.separator + "craftpresence" + ".properties");
        CONFIG.initialize();
        File CP_DIR = new File("craftpresence");
        Constants.loadDLL(!CP_DIR.exists() || CP_DIR.listFiles() == null);
        Constants.loadCharData(!CP_DIR.exists() || CP_DIR.listFiles() == null);
        CommandHandler.init();
        try {
            CraftPresence.CLIENT.CLIENT_ID = CraftPresence.CONFIG.clientID;
            CLIENT.setup();
            CLIENT.init();
            CLIENT.updateTimestamp();
        }
        catch (Exception ex) {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.load", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
        finally {
            this.initialized = true;
        }
    }

    private void scheduleTick() {
        if (!closing) {
            timerObj.schedule(new TimerTask(){

                @Override
                public void run() {
                    CraftPresence.this.clientTick();
                }
            }, 50L);
        }
    }

    private void clientTick() {
        if (this.initialized) {
            instance = Minecraft.func_71410_x();
            player = CraftPresence.instance.field_71439_g;
            CommandHandler.reloadData(false);
            if (CraftPresence.CONFIG.showCurrentDimension && CraftPresence.DIMENSIONS.DIMENSION_NAMES.isEmpty()) {
                DIMENSIONS.getDimensions();
            }
            if (CraftPresence.CONFIG.showCurrentBiome && CraftPresence.BIOMES.BIOME_NAMES.isEmpty()) {
                BIOMES.getBiomes();
            }
            if (CraftPresence.CONFIG.enablePERGUI && CraftPresence.GUIS.GUI_NAMES.isEmpty()) {
                GUIS.getGUIs();
            }
            if (CraftPresence.CONFIG.enablePERItem && CraftPresence.ENTITIES.ENTITY_NAMES.isEmpty()) {
                ENTITIES.getEntities();
            }
            if (CraftPresence.CONFIG.showGameState && CraftPresence.SERVER.knownAddresses.isEmpty()) {
                SERVER.getServerAddresses();
            }
            if (!CraftPresence.CONFIG.hasChanged) {
                if (!(CommandHandler.isOnMainMenuPresence().booleanValue() || player != null || CraftPresence.DIMENSIONS.isInUse || CraftPresence.BIOMES.isInUse || CraftPresence.ENTITIES.isInUse || CraftPresence.SERVER.isInUse)) {
                    CommandHandler.setMainMenuPresence();
                }
                if (awaitingReply && CraftPresence.SYSTEM.TIMER == 0) {
                    StringHandler.sendMessageToPlayer((Entity)player, Constants.TRANSLATOR.translate("craftpresence.command.request.ignored", CraftPresence.CLIENT.REQUESTER_USER.username));
                    DiscordRPC.INSTANCE.Discord_Respond(CraftPresence.CLIENT.REQUESTER_USER.userId, 2);
                    awaitingReply = false;
                    CraftPresence.CLIENT.STATUS = "ready";
                } else if (!awaitingReply && CraftPresence.CLIENT.REQUESTER_USER != null) {
                    CraftPresence.CLIENT.REQUESTER_USER = null;
                    CraftPresence.CLIENT.STATUS = "ready";
                }
            }
        } else if (!closing) {
            this.init();
        }
        this.scheduleTick();
    }

    static {
        SYSTEM = new SystemHandler();
        KEYBINDINGS = new KeyHandler();
        CLIENT = new DiscordHandler();
        SERVER = new ServerHandler();
        BIOMES = new BiomeHandler();
        DIMENSIONS = new DimensionHandler();
        ENTITIES = new EntityHandler();
        GUIS = new GUIHandler();
        timerObj = new Timer(CraftPresence.class.getSimpleName());
    }
}

