/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config;

import com.gitlab.cdagaming.craftpresence.Constants;
import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;

public class ConfigHandler {
    public String NAME_detectCurseManifest;
    public String NAME_detectMultiMCManifest;
    public String NAME_detectMCUpdaterInstance;
    public String NAME_detectTechnicPack;
    public String NAME_showTime;
    public String NAME_showCurrentBiome;
    public String NAME_showCurrentDimension;
    public String NAME_showGameState;
    public String NAME_clientID;
    public String NAME_defaultIcon;
    public String NAME_enableJoinRequest;
    public String NAME_biomeMessages;
    public String NAME_defaultDimensionIcon;
    public String NAME_dimensionMessages;
    public String NAME_defaultServerIcon;
    public String NAME_defaultServerName;
    public String NAME_defaultServerMOTD;
    public String NAME_serverMessages;
    public String NAME_mainmenuMSG;
    public String NAME_lanMSG;
    public String NAME_singleplayerMSG;
    public String NAME_packPlaceholderMSG;
    public String NAME_playerPlaceholderMSG;
    public String NAME_playerAmountPlaceholderMSG;
    public String NAME_gameTimePlaceholderMSG;
    public String NAME_modsPlaceholderMSG;
    public String NAME_vivecraftMessage;
    public String NAME_enableCommands;
    public String NAME_enablePERGUI;
    public String NAME_enablePERItem;
    public String NAME_overwriteServerIcon;
    public String NAME_renderTooltips;
    public String NAME_splitCharacter;
    public String NAME_guiMessages;
    public String NAME_itemMessages;
    public String NAME_tooltipBGColor;
    public String NAME_tooltipBorderColor;
    public String NAME_guiBGColor;
    public String NAME_languageID;
    public String NAME_stripTranslationColors;
    public String NAME_configKeycode;
    public boolean detectCurseManifest;
    public boolean detectMultiMCManifest;
    public boolean detectMCUpdaterInstance;
    public boolean detectTechnicPack;
    public boolean showTime;
    public boolean showCurrentBiome;
    public boolean showCurrentDimension;
    public boolean showGameState;
    public boolean enableJoinRequest;
    public String clientID;
    public String defaultIcon;
    public String[] biomeMessages;
    public String defaultDimensionIcon;
    public String[] dimensionMessages;
    public String defaultServerIcon;
    public String defaultServerName;
    public String defaultServerMOTD;
    public String[] serverMessages;
    public String mainmenuMSG;
    public String lanMSG;
    public String singleplayerMSG;
    public String packPlaceholderMSG;
    public String playerPlaceholderMSG;
    public String playerAmountPlaceholderMSG;
    public String gameTimePlaceholderMSG;
    public String modsPlaceholderMSG;
    public String vivecraftMessage;
    public boolean enableCommands;
    public boolean enablePERGUI;
    public boolean enablePERItem;
    public boolean overwriteServerIcon;
    public boolean renderTooltips;
    public String splitCharacter;
    public String[] guiMessages;
    public String[] itemMessages;
    public String tooltipBGColor;
    public String tooltipBorderColor;
    public String guiBGColor;
    public String languageID;
    public String configKeyCode;
    public boolean stripTranslationColors;
    public boolean hasChanged = false;
    public boolean hasClientPropertiesChanged = false;
    public String queuedSplitCharacter;
    public File configFile;
    public File parentDir;
    public Properties properties = new Properties();
    private Map<String, String> configPropertyMappings = Maps.newHashMap();
    private String fileName;
    private boolean verified = false;
    private boolean initialized = false;
    private boolean isConfigNew = false;

    public ConfigHandler(String fileName) {
        this.fileName = fileName;
    }

    public void setupInitialValues() {
        this.NAME_detectCurseManifest = Constants.TRANSLATOR.translate(true, "gui.config.name.general.detectcursemanifest", new Object[0]).replaceAll(" ", "_");
        this.NAME_detectMultiMCManifest = Constants.TRANSLATOR.translate(true, "gui.config.name.general.detectmultimcmanifest", new Object[0]).replaceAll(" ", "_");
        this.NAME_detectMCUpdaterInstance = Constants.TRANSLATOR.translate(true, "gui.config.name.general.detectmcupdaterinstance", new Object[0]).replaceAll(" ", "_");
        this.NAME_detectTechnicPack = Constants.TRANSLATOR.translate(true, "gui.config.name.general.detecttechnicpack", new Object[0]).replaceAll(" ", "_");
        this.NAME_showTime = Constants.TRANSLATOR.translate(true, "gui.config.name.general.showtime", new Object[0]).replaceAll(" ", "_");
        this.NAME_showCurrentBiome = Constants.TRANSLATOR.translate(true, "gui.config.name.general.showbiome", new Object[0]).replaceAll(" ", "_");
        this.NAME_showCurrentDimension = Constants.TRANSLATOR.translate(true, "gui.config.name.general.showdimension", new Object[0]).replaceAll(" ", "_");
        this.NAME_showGameState = Constants.TRANSLATOR.translate(true, "gui.config.name.general.showstate", new Object[0]).replaceAll(" ", "_");
        this.NAME_clientID = Constants.TRANSLATOR.translate(true, "gui.config.name.general.clientid", new Object[0]).replaceAll(" ", "_");
        this.NAME_defaultIcon = Constants.TRANSLATOR.translate(true, "gui.config.name.general.defaulticon", new Object[0]).replaceAll(" ", "_");
        this.NAME_enableJoinRequest = Constants.TRANSLATOR.translate(true, "gui.config.name.general.enablejoinrequest", new Object[0]).replaceAll(" ", "_");
        this.detectCurseManifest = true;
        this.detectMultiMCManifest = true;
        this.detectMCUpdaterInstance = true;
        this.detectTechnicPack = true;
        this.showTime = true;
        this.showCurrentBiome = false;
        this.showCurrentDimension = true;
        this.showGameState = true;
        this.clientID = "450485984333660181";
        this.defaultIcon = "grass";
        this.enableJoinRequest = false;
        this.NAME_biomeMessages = Constants.TRANSLATOR.translate(true, "gui.config.name.biomemessages.biomemessages", new Object[0]).replaceAll(" ", "_");
        this.biomeMessages = new String[]{"default;Playing in &biome&"};
        this.NAME_defaultDimensionIcon = Constants.TRANSLATOR.translate(true, "gui.config.name.dimensionmessages.dimensionicon", new Object[0]).replaceAll(" ", "_");
        this.NAME_dimensionMessages = Constants.TRANSLATOR.translate(true, "gui.config.name.dimensionmessages.dimensionmessages", new Object[0]).replaceAll(" ", "_");
        this.defaultDimensionIcon = "unknown";
        this.dimensionMessages = new String[]{"default" + (!StringHandler.isNullOrEmpty(this.splitCharacter) ? this.splitCharacter : ";") + "In The &dimension&"};
        this.NAME_defaultServerIcon = Constants.TRANSLATOR.translate(true, "gui.config.name.servermessages.servericon", new Object[0]).replaceAll(" ", "_");
        this.NAME_defaultServerName = Constants.TRANSLATOR.translate(true, "gui.config.name.servermessages.servername", new Object[0]).replaceAll(" ", "_");
        this.NAME_defaultServerMOTD = Constants.TRANSLATOR.translate(true, "gui.config.name.servermessages.servermotd", new Object[0]).replaceAll(" ", "_");
        this.NAME_serverMessages = Constants.TRANSLATOR.translate(true, "gui.config.name.servermessages.servermessages", new Object[0]).replaceAll(" ", "_");
        this.defaultServerIcon = "default";
        this.defaultServerName = Constants.TRANSLATOR.translate(true, "craftpresence.defaults.servermessages.servername", new Object[0]);
        this.defaultServerMOTD = Constants.TRANSLATOR.translate(true, "craftpresence.defaults.servermessages.servermotd", new Object[0]);
        this.serverMessages = new String[]{"default;Playing on &motd&"};
        this.NAME_mainmenuMSG = Constants.TRANSLATOR.translate(true, "gui.config.name.statusmessages.mainmenumsg", new Object[0]).replaceAll(" ", "_");
        this.NAME_lanMSG = Constants.TRANSLATOR.translate(true, "gui.config.name.statusmessages.lanmsg", new Object[0]).replaceAll(" ", "_");
        this.NAME_singleplayerMSG = Constants.TRANSLATOR.translate(true, "gui.config.name.statusmessages.singleplayermsg", new Object[0]).replaceAll(" ", "_");
        this.NAME_packPlaceholderMSG = Constants.TRANSLATOR.translate(true, "gui.config.name.statusmessages.placeholder.packmsg", new Object[0]).replaceAll(" ", "_");
        this.NAME_playerPlaceholderMSG = Constants.TRANSLATOR.translate(true, "gui.config.name.statusmessages.placeholder.playermsg", new Object[0]).replaceAll(" ", "_");
        this.NAME_playerAmountPlaceholderMSG = Constants.TRANSLATOR.translate(true, "gui.config.name.statusmessages.placeholder.playeramountmsg", new Object[0]).replaceAll(" ", "_");
        this.NAME_gameTimePlaceholderMSG = Constants.TRANSLATOR.translate(true, "gui.config.name.statusmessages.placeholder.gametimemsg", new Object[0]).replaceAll(" ", "_");
        this.NAME_modsPlaceholderMSG = Constants.TRANSLATOR.translate(true, "gui.config.name.statusmessages.placeholder.modsmsg", new Object[0]).replaceAll(" ", "_");
        this.NAME_vivecraftMessage = Constants.TRANSLATOR.translate(true, "gui.config.name.statusmessages.special.vivecraftmsg", new Object[0]).replaceAll(" ", "_");
        this.mainmenuMSG = Constants.TRANSLATOR.translate(true, "craftpresence.defaults.state.mainmenu", new Object[0]);
        this.lanMSG = Constants.TRANSLATOR.translate(true, "craftpresence.defaults.state.lan", new Object[0]);
        this.singleplayerMSG = Constants.TRANSLATOR.translate(true, "craftpresence.defaults.state.singleplayer", new Object[0]);
        this.packPlaceholderMSG = Constants.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.pack", new Object[0]);
        this.playerPlaceholderMSG = Constants.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.ign", new Object[0]);
        this.playerAmountPlaceholderMSG = Constants.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.players", new Object[0]);
        this.gameTimePlaceholderMSG = Constants.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.time", new Object[0]);
        this.modsPlaceholderMSG = Constants.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.mods", new Object[0]);
        this.vivecraftMessage = Constants.TRANSLATOR.translate(true, "craftpresence.defaults.special.vivecraft", new Object[0]);
        this.NAME_enableCommands = Constants.TRANSLATOR.translate(true, "gui.config.name.advanced.enablecommands", new Object[0]).replaceAll(" ", "_");
        this.NAME_enablePERGUI = Constants.TRANSLATOR.translate(true, "gui.config.name.advanced.enablepergui", new Object[0]).replaceAll(" ", "_");
        this.NAME_enablePERItem = Constants.TRANSLATOR.translate(true, "gui.config.name.advanced.enableperitem", new Object[0]).replaceAll(" ", "_");
        this.NAME_overwriteServerIcon = Constants.TRANSLATOR.translate(true, "gui.config.name.advanced.overwriteservericon", new Object[0]).replaceAll(" ", "_");
        this.NAME_renderTooltips = Constants.TRANSLATOR.translate(true, "gui.config.name.advanced.rendertooltips", new Object[0]).replaceAll(" ", "_");
        this.NAME_splitCharacter = Constants.TRANSLATOR.translate(true, "gui.config.name.advanced.splitcharacter", new Object[0]).replaceAll(" ", "_");
        this.NAME_guiMessages = Constants.TRANSLATOR.translate(true, "gui.config.name.advanced.guimessages", new Object[0]).replaceAll(" ", "_");
        this.NAME_itemMessages = Constants.TRANSLATOR.translate(true, "gui.config.name.advanced.itemmessages", new Object[0]).replaceAll(" ", "_");
        this.enableCommands = true;
        this.enablePERGUI = false;
        this.enablePERItem = false;
        this.overwriteServerIcon = false;
        this.renderTooltips = true;
        this.splitCharacter = ";";
        this.guiMessages = new String[]{"default;In &gui&"};
        this.itemMessages = new String[]{"default;Holding &main&"};
        this.NAME_tooltipBGColor = Constants.TRANSLATOR.translate(true, "gui.config.name.accessibility.tooltipbgcolor", new Object[0]).replaceAll(" ", "_");
        this.NAME_tooltipBorderColor = Constants.TRANSLATOR.translate(true, "gui.config.name.accessibility.tooltipbordercolor", new Object[0]).replaceAll(" ", "_");
        this.NAME_guiBGColor = Constants.TRANSLATOR.translate(true, "gui.config.name.accessibility.guibgcolor", new Object[0]).replaceAll(" ", "_");
        this.NAME_languageID = Constants.TRANSLATOR.translate(true, "gui.config.name.accessibility.languageid", new Object[0]).replaceAll(" ", "_");
        this.NAME_stripTranslationColors = Constants.TRANSLATOR.translate(true, "gui.config.name.accessibility.striptranslationcolors", new Object[0]).replaceAll(" ", "_");
        this.NAME_configKeycode = Constants.TRANSLATOR.translate(true, "key.craftpresence.config_keybind", new Object[0]).replaceAll(" ", "_");
        this.tooltipBGColor = "-267386864";
        this.tooltipBorderColor = "1347420415";
        this.guiBGColor = "minecraft" + this.splitCharacter + "textures/gui/options_background.png";
        this.languageID = "en_US";
        this.stripTranslationColors = false;
        this.configKeyCode = Integer.toString(29);
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.getName().contains("NAME_")) continue;
            try {
                field.setAccessible(true);
                this.configPropertyMappings.put(field.getName(), field.get(this).toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.initialized = true;
    }

    public void initialize() {
        try {
            this.configFile = new File(this.fileName);
            this.parentDir = this.configFile.getParentFile();
            this.isConfigNew = !this.parentDir.exists() && this.parentDir.mkdirs() || !this.configFile.exists() && this.configFile.createNewFile();
            this.setupInitialValues();
        }
        catch (Exception ex) {
            Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.save", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
        finally {
            if (this.initialized) {
                if (this.isConfigNew) {
                    this.updateConfig();
                }
                this.read(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void read(boolean skipLogging) {
        InputStreamReader configReader = null;
        FileInputStream inputStream = null;
        this.verified = false;
        inputStream = new FileInputStream(this.configFile);
        configReader = new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8"));
        this.properties.load(configReader);
        try {
            this.detectCurseManifest = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_detectCurseManifest)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_detectCurseManifest)) : this.detectCurseManifest;
            this.detectMultiMCManifest = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_detectMultiMCManifest)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_detectMultiMCManifest)) : this.detectMultiMCManifest;
            this.detectMCUpdaterInstance = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_detectMCUpdaterInstance)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_detectMCUpdaterInstance)) : this.detectMCUpdaterInstance;
            this.detectTechnicPack = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_detectTechnicPack)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_detectTechnicPack)) : this.detectTechnicPack;
            this.showTime = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_showTime)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_showTime)) : this.showTime;
            this.showCurrentBiome = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_showCurrentBiome)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_showCurrentBiome)) : this.showCurrentBiome;
            this.showCurrentDimension = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_showCurrentDimension)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_showCurrentDimension)) : this.showCurrentDimension;
            this.showGameState = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_showGameState)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_showGameState)) : this.showGameState;
            this.clientID = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_clientID)) ? this.properties.getProperty(this.NAME_clientID) : this.clientID;
            this.defaultIcon = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultIcon)) ? this.properties.getProperty(this.NAME_defaultIcon) : this.defaultIcon;
            this.enableJoinRequest = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_enableJoinRequest)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_enableJoinRequest)) : this.enableJoinRequest;
            this.biomeMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_biomeMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_biomeMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.biomeMessages;
            this.defaultDimensionIcon = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultDimensionIcon)) ? this.properties.getProperty(this.NAME_defaultDimensionIcon) : this.defaultDimensionIcon;
            this.dimensionMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_dimensionMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_dimensionMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.dimensionMessages;
            this.defaultServerIcon = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultServerIcon)) ? this.properties.getProperty(this.NAME_defaultServerIcon) : this.defaultServerIcon;
            this.defaultServerName = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultServerName)) ? this.properties.getProperty(this.NAME_defaultServerName) : this.defaultServerName;
            this.defaultServerMOTD = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultServerMOTD)) ? this.properties.getProperty(this.NAME_defaultServerMOTD) : this.defaultServerMOTD;
            this.serverMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_serverMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_serverMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.serverMessages;
            this.mainmenuMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_mainmenuMSG)) ? this.properties.getProperty(this.NAME_mainmenuMSG) : this.mainmenuMSG;
            this.lanMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_lanMSG)) ? this.properties.getProperty(this.NAME_lanMSG) : this.lanMSG;
            this.singleplayerMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_singleplayerMSG)) ? this.properties.getProperty(this.NAME_singleplayerMSG) : this.singleplayerMSG;
            this.packPlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_packPlaceholderMSG)) ? this.properties.getProperty(this.NAME_packPlaceholderMSG) : this.packPlaceholderMSG;
            this.playerPlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_playerPlaceholderMSG)) ? this.properties.getProperty(this.NAME_playerPlaceholderMSG) : this.playerPlaceholderMSG;
            this.playerAmountPlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_playerAmountPlaceholderMSG)) ? this.properties.getProperty(this.NAME_playerAmountPlaceholderMSG) : this.playerAmountPlaceholderMSG;
            this.gameTimePlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_gameTimePlaceholderMSG)) ? this.properties.getProperty(this.NAME_gameTimePlaceholderMSG) : this.gameTimePlaceholderMSG;
            this.modsPlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_modsPlaceholderMSG)) ? this.properties.getProperty(this.NAME_modsPlaceholderMSG) : this.modsPlaceholderMSG;
            this.vivecraftMessage = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_vivecraftMessage)) ? this.properties.getProperty(this.NAME_vivecraftMessage) : this.vivecraftMessage;
            this.enableCommands = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_enableCommands)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_enableCommands)) : this.enableCommands;
            this.enablePERGUI = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_enablePERGUI)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_enablePERGUI)) : this.enablePERGUI;
            this.enablePERItem = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_enablePERItem)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_enablePERItem)) : this.enablePERItem;
            this.overwriteServerIcon = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_overwriteServerIcon)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_overwriteServerIcon)) : this.overwriteServerIcon;
            this.renderTooltips = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_renderTooltips)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_renderTooltips)) : this.renderTooltips;
            this.splitCharacter = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_splitCharacter)) ? this.properties.getProperty(this.NAME_splitCharacter) : this.splitCharacter;
            this.guiMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_guiMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_guiMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.guiMessages;
            this.itemMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_itemMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_itemMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.itemMessages;
            this.tooltipBGColor = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_tooltipBGColor)) ? this.properties.getProperty(this.NAME_tooltipBGColor) : this.tooltipBGColor;
            this.tooltipBorderColor = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_tooltipBorderColor)) ? this.properties.getProperty(this.NAME_tooltipBorderColor) : this.tooltipBorderColor;
            this.guiBGColor = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_guiBGColor)) ? this.properties.getProperty(this.NAME_guiBGColor) : this.guiBGColor;
            this.languageID = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_languageID)) ? this.properties.getProperty(this.NAME_languageID) : this.languageID;
            this.stripTranslationColors = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_stripTranslationColors)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_stripTranslationColors)) : this.stripTranslationColors;
            this.configKeyCode = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_configKeycode)) ? this.properties.getProperty(this.NAME_configKeycode) : this.configKeyCode;
        }
        catch (NullPointerException ex) {
            this.verifyConfig();
        }
        finally {
            if (!this.verified) {
                this.verifyConfig();
            }
            if (!skipLogging) {
                Constants.LOG.info(Constants.TRANSLATOR.translate(true, "craftpresence.logger.info.config.save", new Object[0]), new Object[0]);
            }
        }
        catch (Exception ex) {
            try {
                Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.save", new Object[0]), new Object[0]);
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                try {
                    this.detectCurseManifest = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_detectCurseManifest)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_detectCurseManifest)) : this.detectCurseManifest;
                    this.detectMultiMCManifest = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_detectMultiMCManifest)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_detectMultiMCManifest)) : this.detectMultiMCManifest;
                    this.detectMCUpdaterInstance = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_detectMCUpdaterInstance)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_detectMCUpdaterInstance)) : this.detectMCUpdaterInstance;
                    this.detectTechnicPack = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_detectTechnicPack)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_detectTechnicPack)) : this.detectTechnicPack;
                    this.showTime = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_showTime)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_showTime)) : this.showTime;
                    this.showCurrentBiome = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_showCurrentBiome)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_showCurrentBiome)) : this.showCurrentBiome;
                    this.showCurrentDimension = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_showCurrentDimension)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_showCurrentDimension)) : this.showCurrentDimension;
                    this.showGameState = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_showGameState)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_showGameState)) : this.showGameState;
                    this.clientID = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_clientID)) ? this.properties.getProperty(this.NAME_clientID) : this.clientID;
                    this.defaultIcon = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultIcon)) ? this.properties.getProperty(this.NAME_defaultIcon) : this.defaultIcon;
                    this.enableJoinRequest = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_enableJoinRequest)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_enableJoinRequest)) : this.enableJoinRequest;
                    this.biomeMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_biomeMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_biomeMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.biomeMessages;
                    this.defaultDimensionIcon = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultDimensionIcon)) ? this.properties.getProperty(this.NAME_defaultDimensionIcon) : this.defaultDimensionIcon;
                    this.dimensionMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_dimensionMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_dimensionMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.dimensionMessages;
                    this.defaultServerIcon = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultServerIcon)) ? this.properties.getProperty(this.NAME_defaultServerIcon) : this.defaultServerIcon;
                    this.defaultServerName = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultServerName)) ? this.properties.getProperty(this.NAME_defaultServerName) : this.defaultServerName;
                    this.defaultServerMOTD = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultServerMOTD)) ? this.properties.getProperty(this.NAME_defaultServerMOTD) : this.defaultServerMOTD;
                    this.serverMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_serverMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_serverMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.serverMessages;
                    this.mainmenuMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_mainmenuMSG)) ? this.properties.getProperty(this.NAME_mainmenuMSG) : this.mainmenuMSG;
                    this.lanMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_lanMSG)) ? this.properties.getProperty(this.NAME_lanMSG) : this.lanMSG;
                    this.singleplayerMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_singleplayerMSG)) ? this.properties.getProperty(this.NAME_singleplayerMSG) : this.singleplayerMSG;
                    this.packPlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_packPlaceholderMSG)) ? this.properties.getProperty(this.NAME_packPlaceholderMSG) : this.packPlaceholderMSG;
                    this.playerPlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_playerPlaceholderMSG)) ? this.properties.getProperty(this.NAME_playerPlaceholderMSG) : this.playerPlaceholderMSG;
                    this.playerAmountPlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_playerAmountPlaceholderMSG)) ? this.properties.getProperty(this.NAME_playerAmountPlaceholderMSG) : this.playerAmountPlaceholderMSG;
                    this.gameTimePlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_gameTimePlaceholderMSG)) ? this.properties.getProperty(this.NAME_gameTimePlaceholderMSG) : this.gameTimePlaceholderMSG;
                    this.modsPlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_modsPlaceholderMSG)) ? this.properties.getProperty(this.NAME_modsPlaceholderMSG) : this.modsPlaceholderMSG;
                    this.vivecraftMessage = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_vivecraftMessage)) ? this.properties.getProperty(this.NAME_vivecraftMessage) : this.vivecraftMessage;
                    this.enableCommands = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_enableCommands)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_enableCommands)) : this.enableCommands;
                    this.enablePERGUI = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_enablePERGUI)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_enablePERGUI)) : this.enablePERGUI;
                    this.enablePERItem = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_enablePERItem)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_enablePERItem)) : this.enablePERItem;
                    this.overwriteServerIcon = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_overwriteServerIcon)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_overwriteServerIcon)) : this.overwriteServerIcon;
                    this.renderTooltips = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_renderTooltips)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_renderTooltips)) : this.renderTooltips;
                    this.splitCharacter = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_splitCharacter)) ? this.properties.getProperty(this.NAME_splitCharacter) : this.splitCharacter;
                    this.guiMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_guiMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_guiMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.guiMessages;
                    this.itemMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_itemMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_itemMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.itemMessages;
                    this.tooltipBGColor = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_tooltipBGColor)) ? this.properties.getProperty(this.NAME_tooltipBGColor) : this.tooltipBGColor;
                    this.tooltipBorderColor = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_tooltipBorderColor)) ? this.properties.getProperty(this.NAME_tooltipBorderColor) : this.tooltipBorderColor;
                    this.guiBGColor = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_guiBGColor)) ? this.properties.getProperty(this.NAME_guiBGColor) : this.guiBGColor;
                    this.languageID = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_languageID)) ? this.properties.getProperty(this.NAME_languageID) : this.languageID;
                    this.stripTranslationColors = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_stripTranslationColors)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_stripTranslationColors)) : this.stripTranslationColors;
                    this.configKeyCode = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_configKeycode)) ? this.properties.getProperty(this.NAME_configKeycode) : this.configKeyCode;
                }
                catch (NullPointerException ex2) {
                    this.verifyConfig();
                }
                finally {
                    if (!this.verified) {
                        this.verifyConfig();
                    }
                    if (!skipLogging) {
                        Constants.LOG.info(Constants.TRANSLATOR.translate(true, "craftpresence.logger.info.config.save", new Object[0]), new Object[0]);
                    }
                }
                throw throwable;
            }
            try {
                this.detectCurseManifest = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_detectCurseManifest)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_detectCurseManifest)) : this.detectCurseManifest;
                this.detectMultiMCManifest = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_detectMultiMCManifest)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_detectMultiMCManifest)) : this.detectMultiMCManifest;
                this.detectMCUpdaterInstance = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_detectMCUpdaterInstance)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_detectMCUpdaterInstance)) : this.detectMCUpdaterInstance;
                this.detectTechnicPack = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_detectTechnicPack)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_detectTechnicPack)) : this.detectTechnicPack;
                this.showTime = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_showTime)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_showTime)) : this.showTime;
                this.showCurrentBiome = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_showCurrentBiome)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_showCurrentBiome)) : this.showCurrentBiome;
                this.showCurrentDimension = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_showCurrentDimension)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_showCurrentDimension)) : this.showCurrentDimension;
                this.showGameState = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_showGameState)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_showGameState)) : this.showGameState;
                this.clientID = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_clientID)) ? this.properties.getProperty(this.NAME_clientID) : this.clientID;
                this.defaultIcon = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultIcon)) ? this.properties.getProperty(this.NAME_defaultIcon) : this.defaultIcon;
                this.enableJoinRequest = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_enableJoinRequest)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_enableJoinRequest)) : this.enableJoinRequest;
                this.biomeMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_biomeMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_biomeMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.biomeMessages;
                this.defaultDimensionIcon = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultDimensionIcon)) ? this.properties.getProperty(this.NAME_defaultDimensionIcon) : this.defaultDimensionIcon;
                this.dimensionMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_dimensionMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_dimensionMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.dimensionMessages;
                this.defaultServerIcon = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultServerIcon)) ? this.properties.getProperty(this.NAME_defaultServerIcon) : this.defaultServerIcon;
                this.defaultServerName = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultServerName)) ? this.properties.getProperty(this.NAME_defaultServerName) : this.defaultServerName;
                this.defaultServerMOTD = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_defaultServerMOTD)) ? this.properties.getProperty(this.NAME_defaultServerMOTD) : this.defaultServerMOTD;
                this.serverMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_serverMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_serverMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.serverMessages;
                this.mainmenuMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_mainmenuMSG)) ? this.properties.getProperty(this.NAME_mainmenuMSG) : this.mainmenuMSG;
                this.lanMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_lanMSG)) ? this.properties.getProperty(this.NAME_lanMSG) : this.lanMSG;
                this.singleplayerMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_singleplayerMSG)) ? this.properties.getProperty(this.NAME_singleplayerMSG) : this.singleplayerMSG;
                this.packPlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_packPlaceholderMSG)) ? this.properties.getProperty(this.NAME_packPlaceholderMSG) : this.packPlaceholderMSG;
                this.playerPlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_playerPlaceholderMSG)) ? this.properties.getProperty(this.NAME_playerPlaceholderMSG) : this.playerPlaceholderMSG;
                this.playerAmountPlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_playerAmountPlaceholderMSG)) ? this.properties.getProperty(this.NAME_playerAmountPlaceholderMSG) : this.playerAmountPlaceholderMSG;
                this.gameTimePlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_gameTimePlaceholderMSG)) ? this.properties.getProperty(this.NAME_gameTimePlaceholderMSG) : this.gameTimePlaceholderMSG;
                this.modsPlaceholderMSG = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_modsPlaceholderMSG)) ? this.properties.getProperty(this.NAME_modsPlaceholderMSG) : this.modsPlaceholderMSG;
                this.vivecraftMessage = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_vivecraftMessage)) ? this.properties.getProperty(this.NAME_vivecraftMessage) : this.vivecraftMessage;
                this.enableCommands = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_enableCommands)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_enableCommands)) : this.enableCommands;
                this.enablePERGUI = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_enablePERGUI)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_enablePERGUI)) : this.enablePERGUI;
                this.enablePERItem = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_enablePERItem)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_enablePERItem)) : this.enablePERItem;
                this.overwriteServerIcon = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_overwriteServerIcon)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_overwriteServerIcon)) : this.overwriteServerIcon;
                this.renderTooltips = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_renderTooltips)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_renderTooltips)) : this.renderTooltips;
                this.splitCharacter = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_splitCharacter)) ? this.properties.getProperty(this.NAME_splitCharacter) : this.splitCharacter;
                this.guiMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_guiMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_guiMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.guiMessages;
                this.itemMessages = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_itemMessages).replaceAll("\\[", "").replaceAll("]", "")) ? this.properties.getProperty(this.NAME_itemMessages).replaceAll("\\[", "").replaceAll("]", "").split(", ") : this.itemMessages;
                this.tooltipBGColor = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_tooltipBGColor)) ? this.properties.getProperty(this.NAME_tooltipBGColor) : this.tooltipBGColor;
                this.tooltipBorderColor = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_tooltipBorderColor)) ? this.properties.getProperty(this.NAME_tooltipBorderColor) : this.tooltipBorderColor;
                this.guiBGColor = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_guiBGColor)) ? this.properties.getProperty(this.NAME_guiBGColor) : this.guiBGColor;
                this.languageID = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_languageID)) ? this.properties.getProperty(this.NAME_languageID) : this.languageID;
                this.stripTranslationColors = StringHandler.isValidBoolean(this.properties.getProperty(this.NAME_stripTranslationColors)) ? Boolean.parseBoolean(this.properties.getProperty(this.NAME_stripTranslationColors)) : this.stripTranslationColors;
                this.configKeyCode = !StringHandler.isNullOrEmpty(this.properties.getProperty(this.NAME_configKeycode)) ? this.properties.getProperty(this.NAME_configKeycode) : this.configKeyCode;
            }
            catch (NullPointerException ex3) {
                this.verifyConfig();
            }
            finally {
                if (!this.verified) {
                    this.verifyConfig();
                }
                if (!skipLogging) {
                    Constants.LOG.info(Constants.TRANSLATOR.translate(true, "craftpresence.logger.info.config.save", new Object[0]), new Object[0]);
                }
            }
        }
        try {
            if (configReader != null) {
                ((Reader)configReader).close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception ex) {
            Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.dataclose", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
    }

    public void updateConfig() {
        this.properties.setProperty(this.NAME_detectCurseManifest, Boolean.toString(this.detectCurseManifest));
        this.properties.setProperty(this.NAME_detectMultiMCManifest, Boolean.toString(this.detectMultiMCManifest));
        this.properties.setProperty(this.NAME_detectMCUpdaterInstance, Boolean.toString(this.detectMCUpdaterInstance));
        this.properties.setProperty(this.NAME_detectTechnicPack, Boolean.toString(this.detectTechnicPack));
        this.properties.setProperty(this.NAME_showTime, Boolean.toString(this.showTime));
        this.properties.setProperty(this.NAME_showCurrentBiome, Boolean.toString(this.showCurrentBiome));
        this.properties.setProperty(this.NAME_showCurrentDimension, Boolean.toString(this.showCurrentDimension));
        this.properties.setProperty(this.NAME_showGameState, Boolean.toString(this.showGameState));
        this.properties.setProperty(this.NAME_clientID, this.clientID);
        this.properties.setProperty(this.NAME_defaultIcon, this.defaultIcon);
        this.properties.setProperty(this.NAME_enableJoinRequest, Boolean.toString(this.enableJoinRequest));
        this.properties.setProperty(this.NAME_biomeMessages, Arrays.toString(this.biomeMessages));
        this.properties.setProperty(this.NAME_defaultDimensionIcon, this.defaultDimensionIcon);
        this.properties.setProperty(this.NAME_dimensionMessages, Arrays.toString(this.dimensionMessages));
        this.properties.setProperty(this.NAME_defaultServerIcon, this.defaultServerIcon);
        this.properties.setProperty(this.NAME_defaultServerName, this.defaultServerName);
        this.properties.setProperty(this.NAME_defaultServerMOTD, this.defaultServerMOTD);
        this.properties.setProperty(this.NAME_serverMessages, Arrays.toString(this.serverMessages));
        this.properties.setProperty(this.NAME_mainmenuMSG, this.mainmenuMSG);
        this.properties.setProperty(this.NAME_lanMSG, this.lanMSG);
        this.properties.setProperty(this.NAME_singleplayerMSG, this.singleplayerMSG);
        this.properties.setProperty(this.NAME_packPlaceholderMSG, this.packPlaceholderMSG);
        this.properties.setProperty(this.NAME_playerPlaceholderMSG, this.playerPlaceholderMSG);
        this.properties.setProperty(this.NAME_playerAmountPlaceholderMSG, this.playerAmountPlaceholderMSG);
        this.properties.setProperty(this.NAME_gameTimePlaceholderMSG, this.gameTimePlaceholderMSG);
        this.properties.setProperty(this.NAME_modsPlaceholderMSG, this.modsPlaceholderMSG);
        this.properties.setProperty(this.NAME_vivecraftMessage, this.vivecraftMessage);
        this.properties.setProperty(this.NAME_enableCommands, Boolean.toString(this.enableCommands));
        this.properties.setProperty(this.NAME_enablePERGUI, Boolean.toString(this.enablePERGUI));
        this.properties.setProperty(this.NAME_enablePERItem, Boolean.toString(this.enablePERItem));
        this.properties.setProperty(this.NAME_overwriteServerIcon, Boolean.toString(this.overwriteServerIcon));
        this.properties.setProperty(this.NAME_renderTooltips, Boolean.toString(this.renderTooltips));
        this.properties.setProperty(this.NAME_splitCharacter, this.splitCharacter);
        this.properties.setProperty(this.NAME_guiMessages, Arrays.toString(this.guiMessages));
        this.properties.setProperty(this.NAME_itemMessages, Arrays.toString(this.itemMessages));
        this.properties.setProperty(this.NAME_tooltipBGColor, this.tooltipBGColor);
        this.properties.setProperty(this.NAME_tooltipBorderColor, this.tooltipBorderColor);
        this.properties.setProperty(this.NAME_guiBGColor, this.guiBGColor);
        this.properties.setProperty(this.NAME_languageID, this.languageID);
        this.properties.setProperty(this.NAME_stripTranslationColors, Boolean.toString(this.stripTranslationColors));
        this.properties.setProperty(this.NAME_configKeycode, this.configKeyCode);
        if (this.showCurrentBiome && this.showGameState) {
            Constants.LOG.warn(Constants.TRANSLATOR.translate(true, "craftpresence.logger.warning.config.conflict.biomestate", new Object[0]), new Object[0]);
            this.showCurrentBiome = false;
            this.properties.setProperty(this.NAME_showCurrentBiome, "false");
        }
        if (this.enablePERGUI && this.showGameState) {
            Constants.LOG.warn(Constants.TRANSLATOR.translate(true, "craftpresence.logger.warning.config.conflict.pergui", new Object[0]), new Object[0]);
            this.enablePERGUI = false;
            this.properties.setProperty(this.NAME_enablePERGUI, "false");
        }
        this.save();
    }

    private void verifyConfig() {
        boolean needsFullUpdate = false;
        for (Map.Entry<String, String> configEntrySet : this.configPropertyMappings.entrySet()) {
            if (this.properties.stringPropertyNames().contains(configEntrySet.getValue())) continue;
            Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.emptyprop", configEntrySet.getValue()), new Object[0]);
            Field configPropertyValue = null;
            try {
                configPropertyValue = this.getClass().getDeclaredField(configEntrySet.getKey().replace("NAME_", ""));
            }
            catch (Exception ex) {
                for (Field declaredField : this.getClass().getDeclaredFields()) {
                    if (declaredField == null || !declaredField.getName().toLowerCase().equalsIgnoreCase(configEntrySet.getKey().replace("NAME_", "").toLowerCase())) continue;
                    configPropertyValue = declaredField;
                    break;
                }
            }
            try {
                if (configPropertyValue == null) continue;
                configPropertyValue.setAccessible(true);
                this.properties.setProperty(configEntrySet.getValue(), configPropertyValue.get(this).toString());
                this.save();
                needsFullUpdate = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (String property : this.properties.stringPropertyNames()) {
            boolean defaultFound;
            if (!this.configPropertyMappings.values().contains(property)) {
                Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.invalidprop", property), new Object[0]);
                this.properties.remove(property);
                this.save();
                continue;
            }
            if (property.equals(this.NAME_clientID) && (this.properties.getProperty(property).length() != 18 || !StringHandler.isValidLong(this.properties.getProperty(property)))) {
                Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.invalidprop", property), new Object[0]);
                this.clientID = "450485984333660181";
                this.properties.setProperty(property, this.clientID);
                this.save();
            }
            if (property.equals(this.NAME_configKeycode) && !StringHandler.isValidInteger(this.properties.getProperty(property))) {
                Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.invalidprop", property), new Object[0]);
                this.configKeyCode = Integer.toString(29);
                this.properties.setProperty(property, this.configKeyCode);
                this.save();
            }
            if (property.equals(this.NAME_splitCharacter) && (this.properties.getProperty(property).length() != 1 || this.properties.getProperty(property).matches(".*[a-z].*") || this.properties.getProperty(property).matches(".*[A-Z].*"))) {
                Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.invalidprop", property), new Object[0]);
                this.queuedSplitCharacter = ";";
            }
            if (property.equals(this.NAME_enableJoinRequest) && this.properties.getProperty(property).equals("false") && (!StringHandler.isNullOrEmpty(CraftPresence.CLIENT.PARTY_ID) || !StringHandler.isNullOrEmpty(CraftPresence.CLIENT.JOIN_SECRET) || CraftPresence.SYSTEM.TIMER != 0 || CraftPresence.awaitingReply || CraftPresence.CLIENT.PARTY_SIZE != 0 || CraftPresence.CLIENT.PARTY_MAX != 0 || CraftPresence.CLIENT.REQUESTER_USER != null)) {
                CraftPresence.awaitingReply = false;
                CraftPresence.CLIENT.REQUESTER_USER = null;
                CraftPresence.CLIENT.JOIN_SECRET = null;
                CraftPresence.CLIENT.PARTY_ID = null;
                CraftPresence.CLIENT.PARTY_SIZE = 0;
                CraftPresence.CLIENT.PARTY_MAX = 0;
                CraftPresence.SYSTEM.TIMER = 0;
                CraftPresence.CLIENT.updatePresence(CraftPresence.CLIENT.buildRichPresence());
            }
            if (property.equals(this.NAME_biomeMessages) && this.biomeMessages != null) {
                boolean bl = defaultFound = !StringHandler.isNullOrEmpty(StringHandler.getConfigPart(this.biomeMessages, "default", 0, 1, this.splitCharacter, null));
                if (!defaultFound) {
                    Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.defaultmissing", property), new Object[0]);
                    this.biomeMessages = StringHandler.addToArray(this.biomeMessages, this.biomeMessages.length, "default" + this.splitCharacter + "Playing in &biome&");
                    this.properties.setProperty(property, Arrays.toString(this.biomeMessages));
                    this.save();
                }
            }
            if (property.equals(this.NAME_dimensionMessages) && this.dimensionMessages != null) {
                boolean bl = defaultFound = !StringHandler.isNullOrEmpty(StringHandler.getConfigPart(this.dimensionMessages, "default", 0, 1, this.splitCharacter, null));
                if (!defaultFound) {
                    Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.defaultmissing", property), new Object[0]);
                    this.dimensionMessages = StringHandler.addToArray(this.dimensionMessages, this.dimensionMessages.length, "default" + this.splitCharacter + "In The &dimension&");
                    this.properties.setProperty(property, Arrays.toString(this.dimensionMessages));
                    this.save();
                }
            }
            if (property.equals(this.NAME_serverMessages) && this.serverMessages != null) {
                boolean bl = defaultFound = !StringHandler.isNullOrEmpty(StringHandler.getConfigPart(this.serverMessages, "default", 0, 1, this.splitCharacter, null));
                if (!defaultFound) {
                    Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.defaultmissing", property), new Object[0]);
                    this.serverMessages = StringHandler.addToArray(this.serverMessages, this.serverMessages.length, "default" + this.splitCharacter + "Playing on &motd&");
                    this.properties.setProperty(property, Arrays.toString(this.serverMessages));
                    this.save();
                }
            }
            if (property.equals(this.NAME_guiMessages) && this.guiMessages != null) {
                boolean bl = defaultFound = !StringHandler.isNullOrEmpty(StringHandler.getConfigPart(this.guiMessages, "default", 0, 1, this.splitCharacter, null));
                if (!defaultFound) {
                    Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.defaultmissing", property), new Object[0]);
                    this.guiMessages = StringHandler.addToArray(this.guiMessages, this.guiMessages.length, "default" + this.splitCharacter + "In &gui&");
                    this.properties.setProperty(property, Arrays.toString(this.guiMessages));
                    this.save();
                }
            }
            if (!property.equals(this.NAME_itemMessages) || this.itemMessages == null || (defaultFound = !StringHandler.isNullOrEmpty(StringHandler.getConfigPart(this.itemMessages, "default", 0, 1, this.splitCharacter, null)))) continue;
            Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.defaultmissing", property), new Object[0]);
            this.itemMessages = StringHandler.addToArray(this.itemMessages, this.itemMessages.length, "default" + this.splitCharacter + "Holding &main&");
            this.properties.setProperty(property, Arrays.toString(this.itemMessages));
            this.save();
        }
        if (!this.properties.stringPropertyNames().isEmpty() && !StringHandler.isNullOrEmpty(this.queuedSplitCharacter)) {
            for (String propertyName : this.configPropertyMappings.values()) {
                if (!this.properties.stringPropertyNames().contains(propertyName) || !this.properties.getProperty(propertyName).contains(this.splitCharacter)) continue;
                this.properties.setProperty(propertyName, this.properties.getProperty(propertyName).replace(this.splitCharacter, this.queuedSplitCharacter));
                this.save();
            }
            needsFullUpdate = true;
            this.queuedSplitCharacter = null;
        }
        if (needsFullUpdate) {
            this.setupInitialValues();
            this.verified = false;
            if (!this.properties.stringPropertyNames().isEmpty()) {
                this.read(true);
            }
            this.updateConfig();
        } else {
            this.verified = true;
        }
    }

    public void save() {
        OutputStreamWriter configWriter = null;
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.configFile);
            configWriter = new OutputStreamWriter((OutputStream)outputStream, Charset.forName("UTF-8"));
            this.properties.store(configWriter, null);
        }
        catch (Exception ex) {
            Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.config.save", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
        try {
            if (configWriter != null) {
                ((Writer)configWriter).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception ex) {
            Constants.LOG.error(Constants.TRANSLATOR.translate(true, "craftpresence.logger.error.dataclose", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
    }
}

