/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.Constants;
import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.gitlab.cdagaming.craftpresence.handler.gui.controls.GUIExtendedButton;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.input.Keyboard;

public class ConfigGUI_CharacterEditor
extends GuiScreen {
    private final GuiScreen parentScreen;
    private GUIExtendedButton backButton;
    private GUIExtendedButton saveButton;
    private GUIExtendedButton syncAllButton;
    private GUIExtendedButton syncSingleButton;
    private GUIExtendedButton resetCharsButton;
    private GuiTextField charInput;
    private GuiTextField charWidth;
    private String lastScannedString;
    private char lastScannedChar;
    private int[] originalCharArray = (int[])StringHandler.MC_CHAR_WIDTH.clone();
    private byte[] originalGlyphArray = (byte[])StringHandler.MC_GLYPH_WIDTH.clone();

    ConfigGUI_CharacterEditor(GuiScreen parentScreen) {
        this.field_146297_k = CraftPresence.instance;
        this.parentScreen = parentScreen;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.charInput = new GuiTextField(100, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 3, CraftPresence.GUIS.getButtonY(1), 180, 20);
        this.charWidth = new GuiTextField(110, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 3, CraftPresence.GUIS.getButtonY(2), 180, 20);
        this.charInput.func_146203_f(1);
        this.charWidth.func_146203_f(2);
        this.resetCharsButton = new GUIExtendedButton(200, this.field_146294_l / 2 - 90, this.field_146295_m - 30, 180, 20, Constants.TRANSLATOR.translate("gui.config.buttonMessage.reset", new Object[0]));
        this.syncAllButton = new GUIExtendedButton(300, this.field_146294_l / 2 - 90, this.resetCharsButton.field_146129_i - 25, 180, 20, Constants.TRANSLATOR.translate("gui.config.buttonMessage.sync.all", new Object[0]));
        this.syncSingleButton = new GUIExtendedButton(400, this.field_146294_l / 2 - 90, this.syncAllButton.field_146129_i - 25, 180, 20, Constants.TRANSLATOR.translate("gui.config.buttonMessage.sync.single", this.charInput.func_146179_b()));
        this.backButton = new GUIExtendedButton(700, 5, this.field_146295_m - 30, 100, 20, Constants.TRANSLATOR.translate("gui.config.buttonMessage.back", new Object[0]));
        this.saveButton = new GUIExtendedButton(800, this.field_146294_l - 105, this.field_146295_m - 30, 100, 20, Constants.TRANSLATOR.translate("gui.config.buttonMessage.save", new Object[0]));
        this.field_146292_n.add(this.resetCharsButton);
        this.field_146292_n.add(this.syncAllButton);
        this.field_146292_n.add(this.syncSingleButton);
        this.field_146292_n.add(this.backButton);
        this.field_146292_n.add(this.saveButton);
        super.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        CraftPresence.GUIS.drawBackground(this.field_146294_l, this.field_146295_m);
        this.checkValues();
        String mainTitle = Constants.TRANSLATOR.translate("gui.config.title.editor.character", new Object[0]);
        String charInputTitle = Constants.TRANSLATOR.translate("gui.config.editorMessage.charinput", new Object[0]);
        String charWidthTitle = Constants.TRANSLATOR.translate("gui.config.editorMessage.charwidth", new Object[0]);
        List<String> notice = StringHandler.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.character.notice", new Object[0]));
        if (notice != null && !notice.isEmpty()) {
            for (int i = 0; i < notice.size(); ++i) {
                String string = notice.get(i);
                this.func_73731_b(this.field_146297_k.field_71466_p, string, this.field_146294_l / 2 - StringHandler.getStringWidth(string) / 2, this.field_146295_m / 2 + i * 10, 0xFFFFFF);
            }
        }
        this.func_73731_b(this.field_146297_k.field_71466_p, mainTitle, this.field_146294_l / 2 - StringHandler.getStringWidth(mainTitle) / 2, 15, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, charInputTitle, this.field_146294_l / 2 - 130, CraftPresence.GUIS.getButtonY(1) + 5, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, charWidthTitle, this.field_146294_l / 2 - 130, CraftPresence.GUIS.getButtonY(2) + 10, 0xFFFFFF);
        this.charInput.func_146194_f();
        this.charWidth.func_146194_f();
        if (StringHandler.isNullOrEmpty(this.charInput.func_146179_b())) {
            this.charWidth.func_146180_a("");
            this.charWidth.func_146184_c(false);
            this.syncSingleButton.field_146124_l = false;
        }
        if (!this.charInput.func_146179_b().equals(this.lastScannedString)) {
            this.lastScannedString = this.charInput.func_146179_b();
            if (!StringHandler.isNullOrEmpty(this.lastScannedString)) {
                this.lastScannedChar = this.lastScannedString.charAt(0);
                this.charWidth.func_146180_a(Integer.toString(StringHandler.getStringWidth(this.lastScannedString)));
                this.charWidth.func_146184_c(true);
                this.syncSingleButton.field_146124_l = true;
            } else {
                this.lastScannedChar = '\u0000';
            }
        }
        this.syncSingleButton.field_146126_j = Constants.TRANSLATOR.translate("gui.config.buttonMessage.sync.single", this.charInput.func_146179_b());
        this.saveButton.field_146124_l = this.syncSingleButton.field_146124_l;
        this.saveButton.field_146125_m = this.syncSingleButton.field_146125_m = this.syncSingleButton.field_146124_l;
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.backButton.field_146127_k) {
            this.field_146297_k.func_147108_a(this.parentScreen);
        } else if (button.field_146127_k == this.saveButton.field_146127_k && StringHandler.isValidInteger(this.charWidth.func_146179_b())) {
            int characterWidth = Integer.parseInt(this.charWidth.func_146179_b());
            if (this.lastScannedChar > '\u0000' && this.lastScannedChar <= StringHandler.MC_CHAR_WIDTH.length && !Constants.TRANSLATOR.isUnicode) {
                StringHandler.MC_CHAR_WIDTH[this.lastScannedChar] = characterWidth;
            } else if (StringHandler.MC_GLYPH_WIDTH[this.lastScannedChar] != 0) {
                StringHandler.MC_GLYPH_WIDTH[this.lastScannedChar & 0xFF] = (byte)characterWidth;
            }
        } else if (button.field_146127_k == this.syncAllButton.field_146127_k) {
            for (int currentCharIndex = 0; currentCharIndex < StringHandler.MC_CHAR_WIDTH.length - 1; ++currentCharIndex) {
                char characterObj = (char)currentCharIndex;
                StringHandler.MC_CHAR_WIDTH[currentCharIndex] = this.field_146297_k.field_71466_p.func_78256_a(Character.toString(characterObj));
            }
            for (int currentGlyphIndex = 0; currentGlyphIndex < StringHandler.MC_GLYPH_WIDTH.length - 1; ++currentGlyphIndex) {
                char glyphObj = (char)(currentGlyphIndex & 0xFF);
                StringHandler.MC_GLYPH_WIDTH[currentGlyphIndex] = (byte)this.field_146297_k.field_71466_p.func_78256_a(Character.toString(glyphObj));
            }
        } else if (button.field_146127_k == this.syncSingleButton.field_146127_k) {
            if (this.lastScannedChar > '\u0000' && this.lastScannedChar < StringHandler.MC_CHAR_WIDTH.length && !Constants.TRANSLATOR.isUnicode) {
                StringHandler.MC_CHAR_WIDTH[this.lastScannedChar] = this.field_146297_k.field_71466_p.func_78256_a(Character.toString(this.lastScannedChar));
            } else if (StringHandler.MC_GLYPH_WIDTH[this.lastScannedChar] != 0) {
                StringHandler.MC_GLYPH_WIDTH[this.lastScannedChar & 0xFF] = (byte)this.field_146297_k.field_71466_p.func_78256_a(Character.toString(this.lastScannedChar));
            }
        } else if (button.field_146127_k == this.resetCharsButton.field_146127_k) {
            Constants.loadCharData(true);
        }
    }

    private void checkValues() {
        if (!Arrays.equals(this.originalCharArray, StringHandler.MC_CHAR_WIDTH) || !Arrays.equals(this.originalGlyphArray, StringHandler.MC_GLYPH_WIDTH)) {
            Constants.writeToCharData();
            this.originalCharArray = (int[])StringHandler.MC_CHAR_WIDTH.clone();
            this.originalGlyphArray = (byte[])StringHandler.MC_GLYPH_WIDTH.clone();
            this.lastScannedString = null;
            this.lastScannedChar = '\u0000';
            this.charInput.func_146180_a("");
            this.charWidth.func_146180_a("");
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.parentScreen);
        }
        this.charInput.func_146201_a(typedChar, keyCode);
        this.charWidth.func_146201_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.charInput.func_146192_a(mouseX, mouseY, mouseButton);
        this.charWidth.func_146192_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
        this.charInput.func_146178_a();
        this.charWidth.func_146178_a();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }
}

