/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.Constants;
import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.gitlab.cdagaming.craftpresence.handler.gui.controls.GUIExtendedButton;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class ConfigGUI_ColorEditor
extends GuiScreen {
    private final GuiScreen parentScreen;
    private int pageNumber;
    private GUIExtendedButton proceedButton;
    private GUIExtendedButton nextPageButton;
    private GUIExtendedButton previousPageButton;
    private String configValueName;
    private String currentNormalHexValue;
    private String currentConvertedHexValue;
    private String startingHexValue;
    private int currentRed;
    private int currentGreen;
    private int currentBlue;
    private int currentAlpha;
    private GuiTextField hexText;
    private GuiTextField redText;
    private GuiTextField greenText;
    private GuiTextField blueText;
    private GuiTextField alphaText;
    private String currentNormalMCTexturePath;
    private String currentConvertedMCTexturePath;
    private String startingMCTexturePath;
    private GuiTextField mcTextureText;
    private ResourceLocation currentMCTexture;

    ConfigGUI_ColorEditor(GuiScreen parentScreen, String configValueName) {
        this.field_146297_k = CraftPresence.instance;
        this.pageNumber = 0;
        this.parentScreen = parentScreen;
        this.configValueName = configValueName;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.hexText = new GuiTextField(100, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 3, CraftPresence.GUIS.getButtonY(1) + 15, 180, 20);
        this.redText = new GuiTextField(110, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 3, CraftPresence.GUIS.getButtonY(3), 180, 20);
        this.greenText = new GuiTextField(120, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 3, CraftPresence.GUIS.getButtonY(4), 180, 20);
        this.blueText = new GuiTextField(130, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 3, CraftPresence.GUIS.getButtonY(5), 180, 20);
        this.alphaText = new GuiTextField(140, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 3, CraftPresence.GUIS.getButtonY(6), 180, 20);
        this.mcTextureText = new GuiTextField(150, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 3, CraftPresence.GUIS.getButtonY(1) + 15, 180, 20);
        this.mcTextureText.func_146203_f(512);
        this.proceedButton = new GUIExtendedButton(700, 10, this.field_146295_m - 30, 80, 20, Constants.TRANSLATOR.translate("gui.config.buttonMessage.back", new Object[0]));
        this.previousPageButton = new GUIExtendedButton(800, this.proceedButton.field_146128_h + this.proceedButton.getWidth() + 3, this.field_146295_m - 30, 20, 20, "<");
        this.nextPageButton = new GUIExtendedButton(900, this.previousPageButton.field_146128_h + this.previousPageButton.getWidth() + 3, this.field_146295_m - 30, 20, 20, ">");
        this.field_146292_n.add(this.previousPageButton);
        this.field_146292_n.add(this.nextPageButton);
        this.field_146292_n.add(this.proceedButton);
        this.initValues();
        this.syncValues();
        super.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        CraftPresence.GUIS.drawBackground(this.field_146294_l, this.field_146295_m);
        String mainTitle = Constants.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = Constants.TRANSLATOR.translate("gui.config.title.editor.color", this.configValueName.replaceAll("_", " "));
        String previewTitle = Constants.TRANSLATOR.translate("gui.config.editorMessage.preview", new Object[0]);
        String noticeTitle = Constants.TRANSLATOR.translate("gui.config.editorMessage.refresh", new Object[0]);
        this.func_73731_b(this.field_146297_k.field_71466_p, mainTitle, this.field_146294_l / 2 - StringHandler.getStringWidth(mainTitle) / 2, 10, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, subTitle, this.field_146294_l / 2 - StringHandler.getStringWidth(subTitle) / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, previewTitle, this.field_146294_l - 90, this.field_146295_m - 25, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, noticeTitle, this.field_146294_l / 2 - 90, CraftPresence.GUIS.getButtonY(1) - 5, 0xFFFFFF);
        if (this.pageNumber == 0) {
            String hexCodeTitle = Constants.TRANSLATOR.translate("gui.config.editorMessage.hexcode", new Object[0]);
            String redTitle = Constants.TRANSLATOR.translate("gui.config.editorMessage.redcolorvalue", new Object[0]);
            String greenTitle = Constants.TRANSLATOR.translate("gui.config.editorMessage.greencolorvalue", new Object[0]);
            String blueTitle = Constants.TRANSLATOR.translate("gui.config.editorMessage.bluecolorvalue", new Object[0]);
            String alphaTitle = Constants.TRANSLATOR.translate("gui.config.editorMessage.alphacolorvalue", new Object[0]);
            this.func_73731_b(this.field_146297_k.field_71466_p, hexCodeTitle, this.field_146294_l / 2 - 130, CraftPresence.GUIS.getButtonY(1) + 20, 0xFFFFFF);
            this.func_73731_b(this.field_146297_k.field_71466_p, redTitle, this.field_146294_l / 2 - 130, CraftPresence.GUIS.getButtonY(3) + 5, 0xFFFFFF);
            this.func_73731_b(this.field_146297_k.field_71466_p, greenTitle, this.field_146294_l / 2 - 130, CraftPresence.GUIS.getButtonY(4) + 5, 0xFFFFFF);
            this.func_73731_b(this.field_146297_k.field_71466_p, blueTitle, this.field_146294_l / 2 - 130, CraftPresence.GUIS.getButtonY(5) + 5, 0xFFFFFF);
            this.func_73731_b(this.field_146297_k.field_71466_p, alphaTitle, this.field_146294_l / 2 - 130, CraftPresence.GUIS.getButtonY(6) + 5, 0xFFFFFF);
            this.hexText.func_146194_f();
            this.redText.func_146194_f();
            this.greenText.func_146194_f();
            this.blueText.func_146194_f();
            this.alphaText.func_146194_f();
            this.proceedButton.field_146124_l = !StringHandler.isNullOrEmpty(this.hexText.func_146179_b());
            CraftPresence.GUIS.drawGradientRect(300.0f, this.field_146294_l - 45, this.field_146295_m - 45, this.field_146294_l - 1, this.field_146295_m - 2, this.currentConvertedHexValue, this.currentConvertedHexValue);
        }
        if (this.pageNumber == 1) {
            String mcTextureTitle = Constants.TRANSLATOR.translate("gui.config.editorMessage.texturepath", new Object[0]);
            this.func_73731_b(this.field_146297_k.field_71466_p, mcTextureTitle, this.field_146294_l / 2 - 130, CraftPresence.GUIS.getButtonY(1) + 20, 0xFFFFFF);
            this.mcTextureText.func_146194_f();
            this.proceedButton.field_146124_l = !StringHandler.isNullOrEmpty(this.mcTextureText.func_146179_b());
            CraftPresence.GUIS.drawTextureRect(0.0, this.field_146294_l - 45, this.field_146295_m - 45, 44.0, 43.0, 0.0, this.currentMCTexture);
        }
        this.previousPageButton.field_146124_l = this.pageNumber != 0;
        this.nextPageButton.field_146124_l = this.pageNumber != 1;
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.previousPageButton.field_146127_k && this.pageNumber != 0) {
            --this.pageNumber;
            this.initValues();
            this.syncValues();
        }
        if (button.field_146127_k == this.nextPageButton.field_146127_k && this.pageNumber != 1) {
            ++this.pageNumber;
            this.initValues();
            this.syncValues();
        }
        if (button.field_146127_k == this.proceedButton.field_146127_k) {
            this.syncValues();
            if (!StringHandler.isNullOrEmpty(this.configValueName)) {
                if (this.pageNumber == 0) {
                    if (this.configValueName.equals(CraftPresence.CONFIG.NAME_tooltipBGColor) && !this.currentNormalHexValue.equals(CraftPresence.CONFIG.tooltipBGColor)) {
                        CraftPresence.CONFIG.hasChanged = true;
                        CraftPresence.CONFIG.tooltipBGColor = this.currentNormalHexValue;
                    } else if (this.configValueName.equals(CraftPresence.CONFIG.NAME_tooltipBorderColor) && !this.currentNormalHexValue.equals(CraftPresence.CONFIG.tooltipBorderColor)) {
                        CraftPresence.CONFIG.hasChanged = true;
                        CraftPresence.CONFIG.tooltipBorderColor = this.currentNormalHexValue;
                    } else if (this.configValueName.equals(CraftPresence.CONFIG.NAME_guiBGColor) && !this.currentNormalHexValue.equals(CraftPresence.CONFIG.guiBGColor)) {
                        CraftPresence.CONFIG.hasChanged = true;
                        CraftPresence.CONFIG.guiBGColor = this.currentNormalHexValue;
                    }
                }
                if (this.pageNumber == 1) {
                    if (this.configValueName.equals(CraftPresence.CONFIG.NAME_tooltipBGColor) && !this.currentNormalMCTexturePath.equals(CraftPresence.CONFIG.tooltipBGColor.replace(CraftPresence.CONFIG.splitCharacter, ":"))) {
                        CraftPresence.CONFIG.hasChanged = true;
                        CraftPresence.CONFIG.tooltipBGColor = this.currentNormalMCTexturePath.replace(":", CraftPresence.CONFIG.splitCharacter);
                    } else if (this.configValueName.equals(CraftPresence.CONFIG.NAME_tooltipBorderColor) && !this.currentNormalMCTexturePath.equals(CraftPresence.CONFIG.tooltipBorderColor.replace(CraftPresence.CONFIG.splitCharacter, ":"))) {
                        CraftPresence.CONFIG.hasChanged = true;
                        CraftPresence.CONFIG.tooltipBorderColor = this.currentNormalMCTexturePath.replace(":", CraftPresence.CONFIG.splitCharacter);
                    } else if (this.configValueName.equals(CraftPresence.CONFIG.NAME_guiBGColor) && !this.currentNormalMCTexturePath.equals(CraftPresence.CONFIG.guiBGColor.replace(CraftPresence.CONFIG.splitCharacter, ":"))) {
                        CraftPresence.CONFIG.hasChanged = true;
                        CraftPresence.CONFIG.guiBGColor = this.currentNormalMCTexturePath.replace(":", CraftPresence.CONFIG.splitCharacter);
                    }
                }
            }
            this.field_146297_k.func_147108_a(this.parentScreen);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.parentScreen);
        }
        if (keyCode == 203 && this.pageNumber != 0) {
            --this.pageNumber;
            this.initValues();
            this.syncValues();
        }
        if (keyCode == 205 && this.pageNumber != 1) {
            ++this.pageNumber;
            this.initValues();
            this.syncValues();
        }
        if (this.pageNumber == 0) {
            this.hexText.func_146201_a(typedChar, keyCode);
            this.redText.func_146201_a(typedChar, keyCode);
            this.greenText.func_146201_a(typedChar, keyCode);
            this.blueText.func_146201_a(typedChar, keyCode);
            this.alphaText.func_146201_a(typedChar, keyCode);
        }
        if (this.pageNumber == 1) {
            this.mcTextureText.func_146201_a(typedChar, keyCode);
        }
        if (keyCode == 156 || keyCode == 28) {
            this.syncValues();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.pageNumber == 0) {
            this.hexText.func_146192_a(mouseX, mouseY, mouseButton);
            this.redText.func_146192_a(mouseX, mouseY, mouseButton);
            this.greenText.func_146192_a(mouseX, mouseY, mouseButton);
            this.blueText.func_146192_a(mouseX, mouseY, mouseButton);
            this.alphaText.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.pageNumber == 1) {
            this.mcTextureText.func_146192_a(mouseX, mouseY, mouseButton);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
        if (this.pageNumber == 0) {
            this.hexText.func_146178_a();
            this.redText.func_146178_a();
            this.greenText.func_146178_a();
            this.blueText.func_146178_a();
            this.alphaText.func_146178_a();
        }
        if (this.pageNumber == 1) {
            this.mcTextureText.func_146178_a();
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void initValues() {
        if (!StringHandler.isNullOrEmpty(this.configValueName)) {
            if (this.configValueName.equals(CraftPresence.CONFIG.NAME_tooltipBGColor)) {
                if (StringHandler.isValidColorCode(CraftPresence.CONFIG.tooltipBGColor)) {
                    this.startingHexValue = CraftPresence.CONFIG.tooltipBGColor;
                } else if (!StringHandler.isNullOrEmpty(CraftPresence.CONFIG.tooltipBGColor)) {
                    this.startingMCTexturePath = CraftPresence.CONFIG.tooltipBGColor;
                }
            } else if (this.configValueName.equals(CraftPresence.CONFIG.NAME_tooltipBorderColor)) {
                if (StringHandler.isValidColorCode(CraftPresence.CONFIG.tooltipBorderColor)) {
                    this.startingHexValue = CraftPresence.CONFIG.tooltipBorderColor;
                } else if (!StringHandler.isNullOrEmpty(CraftPresence.CONFIG.tooltipBGColor)) {
                    this.startingMCTexturePath = CraftPresence.CONFIG.tooltipBorderColor;
                }
            } else if (this.configValueName.equals(CraftPresence.CONFIG.NAME_guiBGColor)) {
                if (StringHandler.isValidColorCode(CraftPresence.CONFIG.guiBGColor)) {
                    this.startingHexValue = CraftPresence.CONFIG.guiBGColor;
                } else if (!StringHandler.isNullOrEmpty(CraftPresence.CONFIG.guiBGColor)) {
                    this.startingMCTexturePath = CraftPresence.CONFIG.guiBGColor;
                }
            }
            if (StringHandler.isNullOrEmpty(this.hexText.func_146179_b()) && !StringHandler.isNullOrEmpty(this.startingHexValue)) {
                this.hexText.func_146180_a(this.startingHexValue);
                this.currentNormalHexValue = null;
                this.currentConvertedHexValue = null;
                this.currentNormalHexValue = null;
                this.currentConvertedMCTexturePath = null;
                this.currentMCTexture = new ResourceLocation("");
                this.pageNumber = 0;
            } else if (StringHandler.isNullOrEmpty(this.mcTextureText.func_146179_b()) && !StringHandler.isNullOrEmpty(this.startingMCTexturePath)) {
                this.mcTextureText.func_146180_a(this.startingMCTexturePath);
                this.currentNormalHexValue = null;
                this.currentConvertedHexValue = null;
                this.currentNormalHexValue = null;
                this.currentConvertedMCTexturePath = null;
                this.currentMCTexture = new ResourceLocation("");
                this.pageNumber = 1;
            }
        }
    }

    private void syncValues() {
        if (this.pageNumber == 0) {
            Integer localValue = null;
            if (!StringHandler.isNullOrEmpty(this.hexText.func_146179_b())) {
                if (this.hexText.func_146179_b().startsWith("#") || this.hexText.func_146179_b().length() == 6) {
                    localValue = StringHandler.getColorFromHex(this.hexText.func_146179_b()).getRGB();
                } else if (this.hexText.func_146179_b().startsWith("0x")) {
                    Color localColor = new Color(Long.decode(this.hexText.func_146179_b()).intValue(), true);
                    localValue = localColor.getRGB();
                } else if (StringHandler.isValidInteger(this.hexText.func_146179_b())) {
                    localValue = Integer.decode(this.hexText.func_146179_b());
                }
                if (localValue != null) {
                    this.currentAlpha = localValue >> 24 & 0xFF;
                    this.currentRed = localValue >> 16 & 0xFF;
                    this.currentGreen = localValue >> 8 & 0xFF;
                    this.currentBlue = localValue & 0xFF;
                    this.alphaText.func_146180_a(Integer.toString(this.currentAlpha));
                    this.redText.func_146180_a(Integer.toString(this.currentRed));
                    this.greenText.func_146180_a(Integer.toString(this.currentGreen));
                    this.blueText.func_146180_a(Integer.toString(this.currentBlue));
                    this.currentNormalHexValue = this.hexText.func_146179_b();
                    this.currentConvertedHexValue = Integer.toString(localValue);
                }
            } else if (!StringHandler.isNullOrEmpty(this.redText.func_146179_b()) && !StringHandler.isNullOrEmpty(this.greenText.func_146179_b()) && !StringHandler.isNullOrEmpty(this.blueText.func_146179_b()) && !StringHandler.isNullOrEmpty(this.alphaText.func_146179_b()) && StringHandler.isValidInteger(this.redText.func_146179_b()) && StringHandler.isValidInteger(this.greenText.func_146179_b()) && StringHandler.isValidInteger(this.blueText.func_146179_b()) && StringHandler.isValidInteger(this.alphaText.func_146179_b()) && Integer.parseInt(this.redText.func_146179_b()) <= 255 && Integer.parseInt(this.greenText.func_146179_b()) <= 255 && Integer.parseInt(this.blueText.func_146179_b()) <= 255 && Integer.parseInt(this.alphaText.func_146179_b()) <= 255) {
                Color localColor = new Color(Integer.parseInt(this.redText.func_146179_b()), Integer.parseInt(this.greenText.func_146179_b()), Integer.parseInt(this.blueText.func_146179_b()), Integer.parseInt(this.alphaText.func_146179_b()));
                this.currentNormalHexValue = StringHandler.getHexFromColor(localColor);
                this.hexText.func_146180_a(this.currentNormalHexValue);
                this.currentConvertedHexValue = Long.toString(Long.decode(this.currentNormalHexValue).intValue());
            }
        }
        if (this.pageNumber == 1) {
            if (!StringHandler.isNullOrEmpty(this.mcTextureText.func_146179_b())) {
                if (this.mcTextureText.func_146179_b().contains(CraftPresence.CONFIG.splitCharacter)) {
                    this.mcTextureText.func_146180_a(this.mcTextureText.func_146179_b().replace(CraftPresence.CONFIG.splitCharacter, ":"));
                }
                this.currentNormalMCTexturePath = this.mcTextureText.func_146179_b().contains(":") && !this.mcTextureText.func_146179_b().startsWith(":") ? this.mcTextureText.func_146179_b() : (this.mcTextureText.func_146179_b().startsWith(":") ? this.mcTextureText.func_146179_b().substring(1) : "minecraft:" + this.mcTextureText.func_146179_b());
                this.currentConvertedMCTexturePath = this.currentNormalMCTexturePath;
                if (this.currentConvertedMCTexturePath.contains(":")) {
                    String[] splitInput = this.currentConvertedMCTexturePath.split(":", 2);
                    this.currentMCTexture = new ResourceLocation(splitInput[0], splitInput[1]);
                } else {
                    this.currentMCTexture = new ResourceLocation(this.currentConvertedMCTexturePath);
                }
            } else {
                this.currentMCTexture = new ResourceLocation("");
            }
        }
    }
}

