/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.handler;

import com.gitlab.cdagaming.craftpresence.Constants;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class StringHandler {
    private static final char COLOR_CHAR = '\u00a7';
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static final Pattern BRACKET_PATTERN = Pattern.compile("\\([^0-9]*\\d+[^0-9]*\\)");
    public static int[] MC_CHAR_WIDTH = new int[256];
    public static byte[] MC_GLYPH_WIDTH = new byte[65536];

    public static Color getColorFromHex(String hexColor) {
        try {
            if (hexColor.length() == 7 && !StringHandler.isNullOrEmpty(hexColor.substring(1))) {
                int r = Integer.valueOf(hexColor.substring(1, 3), 16);
                int g = Integer.valueOf(hexColor.substring(3, 5), 16);
                int b = Integer.valueOf(hexColor.substring(5, 7), 16);
                return new Color(r, g, b);
            }
            if (hexColor.length() == 6 && !hexColor.startsWith("#")) {
                int r = Integer.valueOf(hexColor.substring(0, 2), 16);
                int g = Integer.valueOf(hexColor.substring(2, 4), 16);
                int b = Integer.valueOf(hexColor.substring(4, 6), 16);
                return new Color(r, g, b);
            }
            return Color.white;
        }
        catch (Exception ex) {
            return Color.white;
        }
    }

    public static String getHexFromColor(Color color) {
        return "0x" + StringHandler.toSafeHexValue(color.getAlpha()) + StringHandler.toSafeHexValue(color.getRed()) + StringHandler.toSafeHexValue(color.getGreen()) + StringHandler.toSafeHexValue(color.getBlue());
    }

    private static String toSafeHexValue(int number) {
        StringBuilder builder = new StringBuilder(Integer.toHexString(number & 0xFF));
        while (builder.length() < 2) {
            builder.append("0");
        }
        return builder.toString().toUpperCase();
    }

    public static boolean isNullOrEmpty(String entry) {
        return entry == null || entry.isEmpty() || entry.equalsIgnoreCase("null");
    }

    public static boolean isValidBoolean(String entry) {
        return !StringHandler.isNullOrEmpty(entry) && (entry.equalsIgnoreCase("true") || entry.equalsIgnoreCase("false"));
    }

    public static boolean isValidColorCode(String entry) {
        return !StringHandler.isNullOrEmpty(entry) && (entry.startsWith("#") || entry.length() == 6 || entry.startsWith("0x") || StringHandler.isValidInteger(entry));
    }

    public static boolean isValidInteger(String entry) {
        if (!StringHandler.isNullOrEmpty(entry)) {
            try {
                Integer.parseInt(entry);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public static boolean isValidLong(String entry) {
        if (!StringHandler.isNullOrEmpty(entry)) {
            try {
                Long.parseLong(entry);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public static String formatIP(String input, boolean returnPort) {
        if (!StringHandler.isNullOrEmpty(input)) {
            String[] formatted = input.split(":", 2);
            return !returnPort ? (StringHandler.elementExists(formatted, 0) ? formatted[0] : "127.0.0.1") : (StringHandler.elementExists(formatted, 1) ? formatted[1] : "25565");
        }
        return !returnPort ? "127.0.0.1" : "25565";
    }

    public static String formatPackIcon(String original) {
        String formattedKey = original;
        if (StringHandler.isNullOrEmpty(formattedKey)) {
            return formattedKey;
        }
        if (formattedKey.contains("\\s")) {
            formattedKey = formattedKey.replaceAll("\\s+", "");
        }
        if (formattedKey.contains("'")) {
            formattedKey = formattedKey.replaceAll("'", "");
        }
        if (formattedKey.contains(".")) {
            formattedKey = formattedKey.replaceAll("\\.", "_");
        }
        if (BRACKET_PATTERN.matcher(formattedKey).find()) {
            formattedKey = BRACKET_PATTERN.matcher(formattedKey).replaceAll("");
        }
        if (STRIP_COLOR_PATTERN.matcher(formattedKey).find()) {
            formattedKey = STRIP_COLOR_PATTERN.matcher(formattedKey).replaceAll("");
        }
        return formattedKey.toLowerCase();
    }

    public static String[] adjustArraySize(String[] theArray, int adjustBy, int operationID) {
        int i = theArray.length;
        int n = i + adjustBy;
        if (operationID == 0) {
            n = i + adjustBy;
        }
        if (operationID == 1) {
            n = i - adjustBy;
        }
        String[] newArray = new String[n];
        System.arraycopy(theArray, 0, newArray, 0, theArray.length);
        return newArray;
    }

    public static String[] addToArray(String[] array, int index, String message) {
        if (array.length <= index) {
            int extendNum = index - array.length;
            String[] newArray = StringHandler.adjustArraySize(array, extendNum + 1, 0);
            newArray[index] = message;
            return newArray;
        }
        array[index] = message;
        return array;
    }

    public static String[] removeFromArray(String[] originalArray, String searchTerm, int searchIndex, String splitCharacter) {
        int indexNumber = 0;
        LinkedList formatted = Lists.newLinkedList(Arrays.asList(originalArray));
        if (!StringHandler.isNullOrEmpty(((Object)formatted).toString())) {
            for (String part : formatted) {
                String[] splitPart = part.split(splitCharacter);
                if (!StringHandler.isNullOrEmpty(splitPart[searchIndex]) && splitPart[searchIndex].equalsIgnoreCase(searchTerm)) {
                    formatted.remove(indexNumber);
                    break;
                }
                ++indexNumber;
            }
        }
        return formatted.toArray(new String[0]);
    }

    public static String getConfigPart(String[] original, String searchTerm, int searchIndex, int resultIndex, String splitCharacter, String alternativeMSG) {
        String formattedKey = "";
        boolean matched = false;
        for (String part : original) {
            String[] splitPart = part.split(splitCharacter);
            if (!splitPart[searchIndex].equalsIgnoreCase(searchTerm) || !StringHandler.elementExists(splitPart, resultIndex)) continue;
            formattedKey = splitPart[resultIndex];
            matched = true;
            break;
        }
        return !matched && !StringHandler.isNullOrEmpty(alternativeMSG) ? alternativeMSG : formattedKey;
    }

    public static String[] setConfigPart(String[] original, String searchTerm, int searchIndex, int resultIndex, String splitCharacter, String newMessage) {
        int indexNumber = -1;
        boolean replacing = false;
        Object[] formatted = original;
        String searchKey = searchTerm;
        if (searchKey.contains(" ")) {
            searchKey = searchKey.replaceAll("\\s+", "");
        }
        if (!StringHandler.isNullOrEmpty(Arrays.toString(formatted))) {
            for (Object part : formatted) {
                ++indexNumber;
                String[] splitPart = ((String)part).split(splitCharacter);
                if (!splitPart[searchIndex].equalsIgnoreCase(searchKey)) continue;
                replacing = true;
                if (StringHandler.elementExists(splitPart, resultIndex)) {
                    String formattedText = ((String)part).replace(splitPart[resultIndex], newMessage);
                    formatted[indexNumber] = formattedText;
                    break;
                }
                formatted[indexNumber] = (String)part + splitCharacter + newMessage;
                break;
            }
            if (!replacing) {
                formatted = StringHandler.addToArray(original, indexNumber + 1, searchKey + splitCharacter + newMessage);
            }
        }
        return formatted;
    }

    public static String formatWord(String original) {
        String formattedKey = original;
        if (StringHandler.isNullOrEmpty(formattedKey)) {
            return formattedKey;
        }
        if (formattedKey.contains("_")) {
            formattedKey = formattedKey.replaceAll("_", " ");
        }
        if (formattedKey.contains("-")) {
            formattedKey = formattedKey.replaceAll("-", " ");
        }
        if (formattedKey.contains(" ")) {
            formattedKey = formattedKey.replaceAll("\\s+", " ");
        }
        if (BRACKET_PATTERN.matcher(formattedKey).find()) {
            formattedKey = BRACKET_PATTERN.matcher(formattedKey).replaceAll("");
        }
        if (STRIP_COLOR_PATTERN.matcher(formattedKey).find()) {
            formattedKey = STRIP_COLOR_PATTERN.matcher(formattedKey).replaceAll("");
        }
        return StringHandler.removeRepeatWords(StringHandler.capitalizeWord(formattedKey)).trim();
    }

    public static String removeRepeatWords(String original) {
        String[] wordList;
        if (StringHandler.isNullOrEmpty(original)) {
            return original;
        }
        String lastWord = "";
        StringBuilder finalString = new StringBuilder();
        for (String word : wordList = original.split(" ")) {
            if (!StringHandler.isNullOrEmpty(lastWord) && word.equals(lastWord)) continue;
            finalString.append(word).append(" ");
            lastWord = word;
        }
        return finalString.toString().trim();
    }

    public static String formatDimensionName(String dimName, boolean formatToID) {
        StringBuilder formattedKey = new StringBuilder(dimName);
        if (StringHandler.isNullOrEmpty(formattedKey.toString())) {
            return formattedKey.toString();
        }
        if (formattedKey.toString().contains("WorldProvider")) {
            formattedKey = new StringBuilder(formattedKey.toString().replace("WorldProvider", ""));
        }
        if (formattedKey.toString().contains(" ")) {
            formattedKey = new StringBuilder(formattedKey.toString().replaceAll("\\s+", " "));
        }
        if (formattedKey.toString().contains(":")) {
            formattedKey = new StringBuilder(formattedKey.toString().split(":", 2)[1]);
        }
        if (formattedKey.toString().contains("{") || formattedKey.toString().contains("}")) {
            formattedKey = new StringBuilder(formattedKey.toString().replaceAll("[{}]", ""));
        }
        if (formattedKey.toString().equalsIgnoreCase("surface")) {
            return "overworld";
        }
        if (formattedKey.toString().equalsIgnoreCase("hell") || formattedKey.toString().equalsIgnoreCase("nether")) {
            return "the_nether";
        }
        if (formattedKey.toString().equalsIgnoreCase("end") || formattedKey.toString().equalsIgnoreCase("sky")) {
            return "the_end";
        }
        if (formatToID) {
            return formattedKey.toString().trim().toLowerCase().replace(" ", "_");
        }
        return StringHandler.formatWord(formattedKey.toString());
    }

    public static String wrapFormattedStringToWidth(String stringInput, int wrapWidth) {
        int stringSizeToWidth = StringHandler.sizeStringToWidth(stringInput, wrapWidth);
        if (stringInput.length() <= stringSizeToWidth) {
            return stringInput;
        }
        String subString = stringInput.substring(0, stringSizeToWidth);
        char currentCharacter = stringInput.charAt(stringSizeToWidth);
        boolean flag = Character.isSpaceChar(currentCharacter) || currentCharacter == '\n';
        String s1 = StringHandler.getFormatFromString(subString) + stringInput.substring(stringSizeToWidth + (flag ? 1 : 0));
        return subString + "\n" + StringHandler.wrapFormattedStringToWidth(s1, wrapWidth);
    }

    public static String getFormatFromString(String text) {
        StringBuilder s = new StringBuilder();
        int index = -1;
        int stringLength = text.length();
        while ((index = text.indexOf(167, index + 1)) != -1) {
            char currentCharacter;
            if (index >= stringLength - 1 || !STRIP_COLOR_PATTERN.matcher(String.valueOf(currentCharacter = text.charAt(index + 1))).find()) continue;
            s = new StringBuilder("\u00a7" + currentCharacter);
        }
        return s.toString();
    }

    public static int getStringWidth(String stringEntry) {
        if (StringHandler.isNullOrEmpty(stringEntry)) {
            return 0;
        }
        int strLength = 0;
        for (char strChar : stringEntry.toCharArray()) {
            strLength += StringHandler.getCharWidth(strChar, Constants.TRANSLATOR.isUnicode);
        }
        return strLength;
    }

    public static int getCharWidth(char characterInput, boolean usingUnicode) {
        if (Character.isSpaceChar(characterInput) || characterInput == '\u00a0') {
            return 4;
        }
        if (characterInput == '\u00a7') {
            return -1;
        }
        try {
            if (characterInput > '\u0000' && characterInput <= MC_CHAR_WIDTH.length && !usingUnicode) {
                return MC_CHAR_WIDTH[characterInput];
            }
            if (MC_GLYPH_WIDTH[characterInput] != 0) {
                int glyphIndex = MC_GLYPH_WIDTH[characterInput] & 0xFF;
                int shiftedIndex = glyphIndex >>> 4;
                int remappedIndex = glyphIndex & 0xF;
                return (++remappedIndex - shiftedIndex) / 2 + 1;
            }
            return 4;
        }
        catch (Exception ex) {
            return 4;
        }
    }

    public static int sizeStringToWidth(String stringEntry, int wrapWidth) {
        int currentLine;
        int stringLength = stringEntry.length();
        int charWidth = 0;
        int currentIndex = -1;
        boolean flag = false;
        for (currentLine = 0; currentLine < stringLength; ++currentLine) {
            char currentCharacter = stringEntry.charAt(currentLine);
            switch (currentCharacter) {
                case '\n': {
                    --currentLine;
                    break;
                }
                case ' ': {
                    currentIndex = currentLine;
                }
                default: {
                    charWidth += StringHandler.getCharWidth(currentCharacter, Constants.TRANSLATOR.isUnicode);
                    if (!flag) break;
                    ++charWidth;
                    break;
                }
                case '\u00a7': {
                    char charIndex;
                    String stringOfCharacter;
                    if (currentLine >= stringLength - 1) break;
                    boolean bl = flag = (stringOfCharacter = String.valueOf(charIndex = stringEntry.charAt(++currentLine))).equalsIgnoreCase("l") && !stringOfCharacter.equalsIgnoreCase("r") && !STRIP_COLOR_PATTERN.matcher(stringOfCharacter).find();
                }
            }
            if (currentCharacter == '\n') {
                currentIndex = ++currentLine;
                break;
            }
            if (charWidth > wrapWidth) break;
        }
        return currentLine != stringLength && currentIndex != -1 && currentIndex < currentLine ? currentIndex : currentLine;
    }

    public static String capitalizeWord(String str) {
        StringBuilder s = new StringBuilder();
        int charIndex = 32;
        for (int index = 0; index < str.length(); ++index) {
            if (charIndex == 32 && str.charAt(index) != ' ') {
                s.append(Character.toUpperCase(str.charAt(index)));
            } else {
                s.append(str.charAt(index));
            }
            charIndex = str.charAt(index);
        }
        return s.toString().trim();
    }

    public static List<String> splitTextByNewLine(String original) {
        if (!StringHandler.isNullOrEmpty(original)) {
            String formattedText = original;
            if (formattedText.contains("\n")) {
                formattedText = original.replace("\n", "&newline&");
            }
            if (formattedText.contains("\\n")) {
                formattedText = original.replace("\\n", "&newline&");
            }
            if (formattedText.contains("\\\\n+")) {
                formattedText = original.replace("\\\\n+", "&newline&");
            }
            return Arrays.asList(formattedText.split("&newline&"));
        }
        return Lists.newArrayList();
    }

    public static void sendMessageToPlayer(Entity sender, String message) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            List<String> lines = StringHandler.splitTextByNewLine(message);
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    player.func_145747_a((ITextComponent)new TextComponentString(line));
                }
            }
        }
    }

    public static InputStream getResourceAsStream(Class<?> fallbackClass, String pathToSearch) {
        InputStream in = null;
        boolean useFallback = false;
        try {
            in = Constants.CLASS_LOADER.getResourceAsStream(pathToSearch);
        }
        catch (Exception ex) {
            useFallback = true;
        }
        if (useFallback || in == null) {
            in = fallbackClass.getResourceAsStream(pathToSearch);
        }
        return in;
    }

    public static boolean elementExists(String[] data, int index) {
        return StringHandler.elementExists(Arrays.asList(data), index);
    }

    public static boolean elementExists(List<String> data, int index) {
        boolean result;
        try {
            result = data.size() >= index && !StringHandler.isNullOrEmpty(data.get(index));
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static Object lookupObject(Class<?> classToAccess, Object instance, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            try {
                Field lookupField = classToAccess.getDeclaredField(fieldName);
                if (lookupField == null) continue;
                lookupField.setAccessible(true);
                return lookupField.get(instance);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void executeMethod(Class<?> classToAccess, Object instance, String[] methodNames, Object[] args, Class<?> ... argumentTypes) {
        for (String methodName : methodNames) {
            try {
                Method lookupMethod = classToAccess.getDeclaredMethod(methodName, argumentTypes);
                if (lookupMethod == null) continue;
                lookupMethod.setAccessible(true);
                lookupMethod.invoke(instance, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int generateHash(Object ... values) {
        return Arrays.hashCode(values);
    }

    public static String stripColors(String input) {
        return StringHandler.isNullOrEmpty(input) ? input : STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }
}

