/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.handler;

import com.gitlab.cdagaming.craftpresence.Constants;
import com.gitlab.cdagaming.craftpresence.handler.discord.rpc.DiscordRPC;

public class SystemHandler {
    public int TIMER = 0;
    public String OS_NAME;
    public String OS_ARCH;
    public String USER_DIR;
    public boolean IS_LINUX = false;
    public boolean IS_MAC = false;
    public boolean IS_WINDOWS = false;
    public long CURRENT_TIMESTAMP;
    private boolean isTiming = false;
    private boolean refreshedCallbacks = false;
    private long BEGINNING_TIMESTAMP;
    private long ELAPSED_TIME;

    public SystemHandler() {
        try {
            this.OS_NAME = System.getProperty("os.name");
            this.OS_ARCH = System.getProperty("os.arch");
            this.USER_DIR = System.getProperty("user.dir");
            this.IS_LINUX = this.OS_NAME.startsWith("Linux") || this.OS_NAME.startsWith("LINUX");
            this.IS_MAC = this.OS_NAME.startsWith("Mac");
            this.IS_WINDOWS = this.OS_NAME.startsWith("Windows");
            this.CURRENT_TIMESTAMP = System.currentTimeMillis();
        }
        catch (Exception ex) {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.system", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
    }

    public void tick() {
        this.ELAPSED_TIME = (System.currentTimeMillis() - this.CURRENT_TIMESTAMP) / 1000L;
        if (this.TIMER > 0) {
            if (!this.isTiming) {
                this.startTimer();
            } else {
                this.checkTimer();
            }
        }
        if (this.ELAPSED_TIME % 2L == 0L) {
            if (!this.refreshedCallbacks) {
                DiscordRPC.INSTANCE.Discord_RunCallbacks();
                this.refreshedCallbacks = true;
            }
        } else {
            this.refreshedCallbacks = false;
        }
    }

    private void startTimer() {
        this.BEGINNING_TIMESTAMP = System.currentTimeMillis() + (long)this.TIMER * 1000L;
        this.isTiming = true;
    }

    private void checkTimer() {
        if (this.TIMER > 0) {
            long remainingTime = (this.BEGINNING_TIMESTAMP - System.currentTimeMillis()) / 1000L;
            this.TIMER = (int)remainingTime;
        } else if (this.isTiming) {
            this.isTiming = false;
        }
    }
}

