/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.handler;

import com.gitlab.cdagaming.craftpresence.Constants;
import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;

public class TranslationHandler {
    public static TranslationHandler instance;
    public boolean isUnicode = false;
    private String languageID = "en_US";
    private String modID;
    private Map<String, String> translationMap = Maps.newHashMap();
    private Map<String, Boolean> requestMap = Maps.newHashMap();
    private boolean usingJSON = false;

    public TranslationHandler() {
        this.setLanguage(CraftPresence.CONFIG != null ? CraftPresence.CONFIG.languageID : this.languageID);
        this.setUsingJSON(false);
        this.getTranslationMap();
        this.checkUnicode();
    }

    public TranslationHandler(boolean useJSON) {
        this.setLanguage(CraftPresence.CONFIG != null ? CraftPresence.CONFIG.languageID : this.languageID);
        this.setUsingJSON(useJSON);
        this.getTranslationMap();
        this.checkUnicode();
    }

    public TranslationHandler(String modID) {
        this.setLanguage(CraftPresence.CONFIG != null ? CraftPresence.CONFIG.languageID : this.languageID);
        this.setModID(modID);
        this.setUsingJSON(false);
        this.getTranslationMap();
        this.checkUnicode();
    }

    public TranslationHandler(String modID, boolean useJSON) {
        this.setLanguage(CraftPresence.CONFIG != null ? CraftPresence.CONFIG.languageID : this.languageID);
        this.setModID(modID);
        this.setUsingJSON(useJSON);
        this.getTranslationMap();
        this.checkUnicode();
    }

    void tick() {
        if (!(CraftPresence.CONFIG == null || this.languageID.equals(CraftPresence.CONFIG.languageID) || this.requestMap.containsKey(CraftPresence.CONFIG.languageID) && !this.requestMap.get(CraftPresence.CONFIG.languageID).booleanValue())) {
            this.setLanguage(CraftPresence.CONFIG.languageID);
            this.getTranslationMap();
            this.checkUnicode();
        }
        if (CraftPresence.instance.field_71474_y != null && this.isUnicode != CraftPresence.instance.field_71474_y.field_151455_aw) {
            this.checkUnicode();
        }
    }

    private void checkUnicode() {
        this.isUnicode = false;
        int i = 0;
        int totalLength = 0;
        for (String currentString : this.translationMap.values()) {
            int currentLength = currentString.length();
            totalLength += currentLength;
            for (int index = 0; index < currentLength; ++index) {
                if (currentString.charAt(index) < '\u0100') continue;
                ++i;
            }
        }
        float f = (float)i / (float)totalLength;
        this.isUnicode = (double)f > 0.1 || CraftPresence.instance.field_71474_y != null && CraftPresence.instance.field_71474_y.field_151455_aw;
    }

    private void setUsingJSON(boolean usingJSON) {
        this.usingJSON = usingJSON;
    }

    private void setLanguage(String languageID) {
        this.languageID = !StringHandler.isNullOrEmpty(languageID) ? languageID : "en_US";
    }

    private void setModID(String modID) {
        this.modID = !StringHandler.isNullOrEmpty(modID) ? modID : null;
    }

    private void getTranslationMap() {
        this.translationMap = Maps.newHashMap();
        InputStream in = StringHandler.getResourceAsStream(TranslationHandler.class, "/assets/" + (!StringHandler.isNullOrEmpty(this.modID) ? this.modID + "/" : "") + "lang/" + this.languageID + (this.usingJSON ? ".json" : ".lang"));
        InputStream fallbackIn = StringHandler.getResourceAsStream(TranslationHandler.class, "/assets/" + (!StringHandler.isNullOrEmpty(this.modID) ? this.modID + "/" : "") + "lang/" + this.languageID.toLowerCase() + (this.usingJSON ? ".json" : ".lang"));
        if (in != null || fallbackIn != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in != null ? in : fallbackIn, Charset.forName("UTF-8")));
            try {
                String currentString;
                while ((currentString = reader.readLine()) != null) {
                    String[] splitTranslation;
                    if ((currentString = currentString.trim()).startsWith("#") || currentString.startsWith("[{}]") || !(this.usingJSON ? currentString.contains(":") : currentString.contains("="))) continue;
                    String[] stringArray = splitTranslation = this.usingJSON ? currentString.split(":", 2) : currentString.split("=", 2);
                    if (this.usingJSON) {
                        String str1 = splitTranslation[0].substring(1, splitTranslation[0].length() - 1).replace("\\n", "\n").replace("\\", "").trim();
                        String str2 = splitTranslation[1].substring(2, splitTranslation[1].length() - 2).replace("\\n", "\n").replace("\\", "").trim();
                        this.translationMap.put(str1, str2);
                        continue;
                    }
                    this.translationMap.put(splitTranslation[0].trim(), splitTranslation[1].trim());
                }
                if (in != null) {
                    in.close();
                }
                if (fallbackIn != null) {
                    fallbackIn.close();
                }
            }
            catch (Exception ex) {
                Constants.LOG.error("An Exception has Occurred while Loading Translation Mappings, Things may not work well...", new Object[0]);
                ex.printStackTrace();
            }
        } else {
            Constants.LOG.error("Translations for " + this.modID + " do not exist for " + this.languageID, new Object[0]);
            this.requestMap.put(this.languageID, false);
            this.setLanguage("en_US");
        }
    }

    public String translate(boolean stripColors, String translationKey, Object ... parameters) {
        boolean hasError = false;
        String translatedString = translationKey;
        try {
            if (this.translationMap.containsKey(translationKey)) {
                translatedString = String.format(this.translationMap.get(translationKey), parameters);
            } else {
                hasError = true;
            }
        }
        catch (Exception ex) {
            Constants.LOG.error("Exception Parsing " + translationKey, new Object[0]);
            ex.printStackTrace();
            hasError = true;
        }
        if (hasError) {
            Constants.LOG.error("Unable to retrieve a Translation for " + translationKey, new Object[0]);
        }
        return stripColors ? StringHandler.stripColors(translatedString) : translatedString;
    }

    public String translate(String translationKey, Object ... parameters) {
        return this.translate(CraftPresence.CONFIG != null && CraftPresence.CONFIG.stripTranslationColors, translationKey, parameters);
    }
}

